/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls350InvReconcileReportResponse;
import com.tridium.tls.messages.Tls350Message;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsReceivedMessage;
import com.tridium.tls.point.BTls350InvReconcileReportProxyExt;
import javax.baja.nre.util.ByteArrayUtil;

public class Tls350InvReconcileReport
extends Tls350Message
implements TlsMessageConst {
    private BTls350InvReconcileReportProxyExt ext;
    private boolean debug;

    public Tls350InvReconcileReport() {
        super("C05");
    }

    public Tls350InvReconcileReport(BTls350InvReconcileReportProxyExt ext) {
        super("C05", ext.getProductNumber());
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public Tls350InvReconcileReport(int productNumber) {
        super("C05", productNumber);
    }

    public Tls350InvReconcileReport(int productNumber, BTls350InvReconcileReportProxyExt ext) {
        super("C05", productNumber);
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    @Override
    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        if (this.debug) {
            this.ext.getLog().trace("TlsIRRReponse :toResponse []=" + ByteArrayUtil.toHexString((byte[])rmBytes, (int)0, (int)rmBytes.length));
        }
        Tls350InvReconcileReportResponse rsp = new Tls350InvReconcileReportResponse(this.ext);
        rsp.readResponse(rmBytes);
        return rsp;
    }
}

