/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls350InventoryReportResponse;
import com.tridium.tls.messages.Tls350Message;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsReceivedMessage;
import com.tridium.tls.point.BTls350InTankInvProxyExt;
import javax.baja.nre.util.ByteArrayUtil;

public class Tls350InventoryReport
extends Tls350Message
implements TlsMessageConst {
    private BTls350InTankInvProxyExt ext;
    private boolean debug;

    public Tls350InventoryReport() {
    }

    public Tls350InventoryReport(int tank) {
        super("201", tank);
    }

    public Tls350InventoryReport(int tank, BTls350InTankInvProxyExt ext) {
        super("201", tank);
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    @Override
    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        if (this.debug) {
            this.ext.getLog().trace("TlsInvReport :toResponse []=" + ByteArrayUtil.toHexString((byte[])rmBytes, (int)0, (int)rmBytes.length));
        }
        Tls350InventoryReportResponse rsp = new Tls350InventoryReportResponse(this.ext);
        rsp.readResponse(rmBytes);
        return rsp;
    }
}

