/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.enums.BTlsLiquidSensorStatusEnum;
import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350LiqSenStaProxyExt;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class Tls350LiqSenStaResponse
extends Tls350Response {
    public BAbsTime readTime;
    private int sensorNumber;
    private BTlsLiquidSensorStatusEnum sensorStatus;
    private BTls350LiqSenStaProxyExt ext;
    private boolean debug;

    public Tls350LiqSenStaResponse() {
    }

    public Tls350LiqSenStaResponse(BTls350LiqSenStaProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public BAbsTime getDateTime() {
        return this.readTime;
    }

    public int getSensorNumber() {
        return this.sensorNumber;
    }

    public BTlsLiquidSensorStatusEnum getSensorStatus() {
        return this.sensorStatus;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsLSSResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16) {
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) break;
            inStream.reset();
            if (inStream.available() < 8 || this.tank <= 0) break;
            this.sensorNumber = inStream.readAsciiInt(2);
            this.sensorStatus = BTlsLiquidSensorStatusEnum.make(inStream.readAsciiInt(4));
        }
        if (this.debug) {
            this.ext.getLog().trace("TlsLSSResponse :readResponse sensorNumber=" + this.sensorNumber + " sensorStatus=" + (Object)((Object)this.sensorStatus));
        }
        return inStream;
    }
}

