/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsReceivedMessage;
import javax.baja.nre.util.ByteArrayUtil;

public class Tls350Response
extends ReceivedMessage {
    protected byte[] messageData;
    protected String functionCode;
    protected int tank;

    public String getStringValue() {
        return "";
    }

    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        Tls350Response rsp = new Tls350Response();
        rsp.readResponse(rmBytes);
        return rsp;
    }

    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = new TlsInputStream(message);
        inStream.read();
        inStream.read();
        this.functionCode = inStream.readString(3);
        this.tank = inStream.readAsciiInt(2);
        this.messageData = new byte[inStream.available() - 1];
        for (int i = 0; i < this.messageData.length; ++i) {
            this.messageData[i] = (byte)(inStream.read() & 0xFF);
        }
        inStream = new TlsInputStream(this.messageData);
        return inStream;
    }

    public String toDebugString() {
        return ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length);
    }
}

