/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.TlsMessageConst;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;

public class TlsInputStream
extends ByteArrayInputStream
implements TlsMessageConst {
    public TlsInputStream(byte[] buf) {
        super(buf);
    }

    public TlsInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public int readInt() {
        return this.read() | this.read() << 8;
    }

    public int readInt(int size) {
        int value = 0;
        switch (size) {
            case 4: {
                value = (this.read() & 0xFF) << 0 | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
                break;
            }
            case 3: {
                value = (this.read() & 0xFF) << 0 | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16;
                break;
            }
            case 2: {
                value = (this.read() & 0xFF) << 0 | (this.read() & 0xFF) << 8;
            }
        }
        return value;
    }

    public long readLong(int size) {
        long value = 0L;
        switch (size) {
            case 1: {
                value = this.read() & 0xFF;
                break;
            }
            case 2: {
                value = (long)(this.read() & 0xFF) << 0 | (long)(this.read() & 0xFF) << 8;
                break;
            }
            case 3: {
                value = (long)(this.read() & 0xFF) << 0 | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16;
                break;
            }
            case 4: {
                value = (long)(this.read() & 0xFF) << 0 | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24;
                break;
            }
            case 5: {
                value = (long)(this.read() & 0xFF) << 0 | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24 | (long)(this.read() & 0xFF) << 32;
                break;
            }
            case 6: {
                value = (long)(this.read() & 0xFF) << 0 | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24 | (long)(this.read() & 0xFF) << 32 | (long)(this.read() & 0xFF) << 40;
                break;
            }
            case 7: {
                value = (long)(this.read() & 0xFF) << 0 | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24 | (long)(this.read() & 0xFF) << 32 | (long)(this.read() & 0xFF) << 40 | (long)(this.read() & 0xFF) << 48;
                break;
            }
            case 8: {
                value = (long)(this.read() & 0xFF) << 0 | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24 | (long)(this.read() & 0xFF) << 32 | (long)(this.read() & 0xFF) << 40 | (long)(this.read() & 0xFF) << 48 | (long)(this.read() & 0xFF) << 56;
            }
        }
        return value;
    }

    public float readFloat() {
        int bitView = this.read() << 0 & 0xFF;
        bitView |= this.read() << 8 & 0xFF00;
        bitView |= this.read() << 16 & 0xFF0000;
        return Float.intBitsToFloat(bitView |= this.read() << 24 & 0xFF000000);
    }

    public String readString(int maxLen) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        boolean done = false;
        while (count++ < maxLen) {
            int data = this.read();
            if (data == -1) {
                done = true;
            }
            char ch = (char)data;
            if (done) continue;
            if (ch == '\u0000') {
                done = true;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public byte[] readByteArray(int count) {
        byte[] a = new byte[count];
        for (int i = 0; i < count; ++i) {
            a[i] = (byte)this.read();
        }
        return a;
    }

    public void read(ByteArrayOutputStream s, int cnt) {
        while (cnt-- > 0) {
            s.write((byte)this.read());
        }
    }

    public BAbsTime readDateTime(boolean is350) {
        int year = 0;
        BAbsTime now = BAbsTime.now();
        int nowYear = now.getYear();
        if (is350) {
            int twoDigitYear = this.readAsciiInt(2);
            year = twoDigitYear + 2000;
            if (year > nowYear) {
                year = twoDigitYear + 1900;
            }
            int month = this.readAsciiInt(2);
            int dom = this.readAsciiInt(2);
            int hours = this.readAsciiInt(2);
            int minutes = this.readAsciiInt(2);
            now = BAbsTime.make((int)year, (BMonth)BMonth.make((int)(month - 1)), (int)dom, (int)hours, (int)minutes);
        } else {
            int month = this.readAsciiInt(2) - 1;
            int dom = this.readAsciiInt(2);
            int hours = this.readAsciiInt(2);
            int minutes = this.readAsciiInt(2);
            now = BAbsTime.make((int)year, (BMonth)BMonth.make((int)(month - 1)), (int)dom, (int)hours, (int)minutes);
        }
        return now;
    }

    public int readAsciiInt(int size) {
        int value = 0;
        int multiplier = (int)Math.pow(10.0, size - 1);
        for (int i = 0; i < size; ++i) {
            char x = (char)this.read();
            int charValue = Character.getNumericValue(x);
            if (charValue == -1) {
                return -1;
            }
            value += charValue * multiplier;
            multiplier /= 10;
        }
        return value;
    }

    public int readAsciiHex(int size) {
        int value = 0;
        int multiplier = (int)Math.pow(16.0, size - 1);
        for (int i = 0; i < size; ++i) {
            char x = (char)this.read();
            int charValue = Character.getNumericValue(x);
            if (charValue == -1) {
                return -1;
            }
            value += charValue * multiplier;
            multiplier /= 16;
        }
        return value;
    }

    public float readAsciiFloat(int size, int divisor) {
        float rawValue = this.readAsciiInt(size);
        return rawValue / (float)divisor;
    }

    public float readAsciiFloat() {
        long bits;
        String sValue = this.readString(8);
        try {
            bits = Long.parseLong(sValue.trim(), 16);
        }
        catch (Exception e) {
            System.out.println(" Integer.parseInt threw exception: " + e);
            return Float.NaN;
        }
        return Float.intBitsToFloat((int)bits);
    }
}

