/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BBirAdjDelHistoryRecord;
import com.tridium.tls.datatypes.BBirAdjustedDeliveryEntry;
import com.tridium.tls.datatypes.BBirAdjustedDeliveryTable;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350BirAdjustedDeliveryReport;
import com.tridium.tls.messages.Tls350BirAdjustedDeliveryReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350BadDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minimumPollInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(2)"), @NiagaraProperty(name="birAdjustedDeliveryTable", type="BBirAdjustedDeliveryTable", defaultValue="new BBirAdjustedDeliveryTable()"), @NiagaraProperty(name="maxOldEntriesSaved", type="int", defaultValue="8", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")})})
@NiagaraAction(name="purgeHashtable", flags=4)
public class BTls350BirAdjDelProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    @Generated
    public static final Property minimumPollInterval = BTls350BirAdjDelProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    @Generated
    public static final Property birAdjustedDeliveryTable = BTls350BirAdjDelProxyExt.newProperty((int)0, (BValue)new BBirAdjustedDeliveryTable(), null);
    @Generated
    public static final Property maxOldEntriesSaved = BTls350BirAdjDelProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Action purgeHashtable = BTls350BirAdjDelProxyExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350BirAdjDelProxyExt.class);
    private Vector<BBirAdjustedDeliveryEntry> bADEntriesVector;
    private Hashtable<Long, BBirAdjustedDeliveryEntry> bADHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;

    @Generated
    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    @Generated
    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    @Generated
    public BBirAdjustedDeliveryTable getBirAdjustedDeliveryTable() {
        return (BBirAdjustedDeliveryTable)this.get(birAdjustedDeliveryTable);
    }

    @Generated
    public void setBirAdjustedDeliveryTable(BBirAdjustedDeliveryTable v) {
        this.set(birAdjustedDeliveryTable, (BValue)v, null);
    }

    @Generated
    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    @Generated
    public void setMaxOldEntriesSaved(int v) {
        this.setInt(maxOldEntriesSaved, v, null);
    }

    @Generated
    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BBirAdjustedDeliveryEntry[] saved = this.getBirAdjustedDeliveryTable().getEntries();
            this.bADHashtable = new Hashtable(saved.length * 2);
            for (int i = 0; i < saved.length; ++i) {
                Long key = saved[i].getHTKey();
                this.bADHashtable.put(key, saved[i]);
            }
            TlsHistoryHelper.initHistory(BBirAdjDelHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.bADHashtable = null;
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        int tankNumber = ((BTls350FuelTankDevice)this.device()).getTankNumber();
        Tls350BirAdjustedDeliveryReport req = new Tls350BirAdjustedDeliveryReport(tankNumber, this);
        Tls350BirAdjustedDeliveryReportResponse rsp = (Tls350BirAdjustedDeliveryReportResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                Tls350BirAdjustedDeliveryReportResponse.BirAdjustedDelivery[] entries = rsp.getBirAdjustedDeliveryEntries();
                if (entries == null || entries.length <= 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + entries.length + " entries");
                }
                if (tankNumber == 0) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! proxy point's tank number not initialized... initialize tank number to valid tank\n\n");
                    return;
                }
                if (tankNumber != entries[0].getTankNumber()) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + entries[0].getTankNumber() + " may be lost\n\n");
                    }
                    return;
                }
                this.bADEntriesVector = new Vector();
                boolean newEntryDetected = false;
                for (int i = entries.length - 1; i > -1; --i) {
                    BBirAdjustedDeliveryEntry newADEntry = new BBirAdjustedDeliveryEntry();
                    newADEntry.setStore(Sys.getStation().getStationName());
                    newADEntry.setTank(tankNumber);
                    newADEntry.setStartDateTime(entries[i].getDeliveryStartDateTime());
                    newADEntry.setEndDateTime(entries[i].getDeliveryEndDateTime());
                    newADEntry.setStartVolume(entries[i].getStartVolume());
                    newADEntry.setEndVolume(entries[i].getEndVolume());
                    newADEntry.setAdjustedDelVolume(entries[i].getAdjustedDelivery());
                    newADEntry.setAdjustedTcDelVolume(entries[i].getAdjustedTcDelivery());
                    newADEntry.setStartFuelHeight(entries[i].getStartFuelHeight());
                    newADEntry.setStartFuelTemp1(entries[i].getStartFuelTemp1());
                    newADEntry.setStartFuelTemp2(entries[i].getStartFuelTemp2());
                    newADEntry.setStartFuelTemp3(entries[i].getStartFuelTemp3());
                    newADEntry.setStartFuelTemp4(entries[i].getStartFuelTemp4());
                    newADEntry.setStartFuelTemp5(entries[i].getStartFuelTemp5());
                    newADEntry.setStartFuelTemp6(entries[i].getStartFuelTemp6());
                    newADEntry.setEndFuelHeight(entries[i].getEndFuelHeight());
                    newADEntry.setEndFuelTemp1(entries[i].getEndFuelTemp1());
                    newADEntry.setEndFuelTemp2(entries[i].getEndFuelTemp2());
                    newADEntry.setEndFuelTemp3(entries[i].getEndFuelTemp3());
                    newADEntry.setEndFuelTemp4(entries[i].getEndFuelTemp4());
                    newADEntry.setEndFuelTemp5(entries[i].getEndFuelTemp5());
                    newADEntry.setEndFuelTemp6(entries[i].getEndFuelTemp6());
                    newADEntry.setTotDispensedDurDel(entries[i].getTotDispensedDurDel());
                    newADEntry.setStartFuelTempAvg(entries[i].getStartFuelTempAvg());
                    newADEntry.setEndFuelTempAvg(entries[i].getEndFuelTempAvg());
                    BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (newADEntry.getEndDateTime().isBefore(previousTime)) {
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newADEntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    Long newHtKey = newADEntry.getHTKey();
                    if (this.bADHashtable == null || this.bADHashtable.get(newHtKey) == null || newEntryDetected) {
                        this.bADHashtable.put(newHtKey, newADEntry);
                        this.bADEntriesVector.addElement(newADEntry);
                        newEntryDetected = true;
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + newADEntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    if (!pollDebug) continue;
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newADEntry.createCommaDelimitedString() + " for " + this.getName());
                }
                if (this.bADEntriesVector.size() > 0) {
                    this.setValue(this.bADEntriesVector);
                    return;
                }
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)sv);
                this.updateDemuxedProxyPoints();
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector<BBirAdjustedDeliveryEntry> values) {
        BBirAdjustedDeliveryEntry[] valuesCopy = new BBirAdjustedDeliveryEntry[values.size()];
        values.copyInto((Object[])valuesCopy);
        BBirAdjustedDeliveryTable sendToCsMgrCopy = new BBirAdjustedDeliveryTable();
        for (int i = 0; i < valuesCopy.length; ++i) {
            try {
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                String newValue = valuesCopy[i].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + newValue);
                }
                sv.setValue(newValue);
                this.readOk((BStatusValue)sv);
                this.getBirAdjustedDeliveryTable().add("birAdjustedDeliveryEntry?", (BValue)valuesCopy[i]);
                sendToCsMgrCopy.add("birAdjustedDeliveryEntry?", (BValue)((BBirAdjustedDeliveryEntry)valuesCopy[i].newCopy()));
                BBirAdjDelHistoryRecord newrec = new BBirAdjDelHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), valuesCopy[i]);
                TlsHistoryHelper.appendTlsHistory((BStruct)newrec);
                continue;
            }
            catch (Exception e) {
                this.readFail(e.toString());
            }
        }
        this.updateDemuxedProxyPoints();
        BBirAdjustedDeliveryEntry[] sortedValues = this.getBirAdjustedDeliveryTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        int numRemoveEntries = sortedValues.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350BirAdjDelProxyExt setValue sortedValues.length=" + sortedValues.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (numRemoveEntries > 0) {
            Vector<BBirAdjustedDeliveryEntry> removeEntries = new Vector<BBirAdjustedDeliveryEntry>();
            for (int i = 0; i < numRemoveEntries; ++i) {
                removeEntries.addElement(sortedValues[i]);
            }
            Enumeration re = removeEntries.elements();
            while (re.hasMoreElements()) {
                BBirAdjustedDeliveryEntry oldestEntryCopy = (BBirAdjustedDeliveryEntry)((Object)re.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350BirAdjDelProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + oldestEntryCopy.createCommaDelimitedString());
                }
                this.getBirAdjustedDeliveryTable().remove((BComplex)oldestEntryCopy);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, sendToCsMgrCopy));
    }

    private void updateDemuxedProxyPoints() {
        BBirAdjustedDeliveryEntry[] sortedValues = this.getBirAdjustedDeliveryTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        BBirAdjustedDeliveryEntry mostRecentValue = sortedValues[sortedValues.length - 1];
        String[] demuxedValueStrings = CsMgrBaseUtil.createStringArrayOfAllNames((String)mostRecentValue.createCommaDelimitedString());
        if (demuxedValueStrings != null && demuxedValueStrings.length > 0) {
            BControlPoint[] dCPA;
            BTls350BadDemuxedPointDeviceExt baddExt = null;
            BDeviceExt[] exts = this.getDevice().getDeviceExts();
            for (int k = 0; k < exts.length; ++k) {
                if (!(exts[k] instanceof BTls350BadDemuxedPointDeviceExt)) continue;
                baddExt = (BTls350BadDemuxedPointDeviceExt)exts[k];
                break;
            }
            if (baddExt != null && (dCPA = baddExt.getPoints()) != null && dCPA.length > 0) {
                for (int k = 0; k < dCPA.length; ++k) {
                    if (dCPA[k].getProxyExt().getType() != BTls350DemuxedProxyExt.TYPE) continue;
                    ((BTls350DemuxedProxyExt)dCPA[k].getProxyExt()).updateValueFrom(demuxedValueStrings);
                }
            }
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }

    @Override
    public void clearDataNow() {
        this.getBirAdjustedDeliveryTable().lease(2);
        BBirAdjustedDeliveryEntry[] bade = (BBirAdjustedDeliveryEntry[])this.getBirAdjustedDeliveryTable().getChildren(BBirAdjustedDeliveryEntry.class);
        if (bade != null && bade.length > 0) {
            for (int i = 0; i < bade.length; ++i) {
                this.getBirAdjustedDeliveryTable().remove((BComplex)bade[i]);
            }
        }
        this.bADHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context cx) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration<Long> bADkeys = this.bADHashtable.keys();
        while (bADkeys.hasMoreElements()) {
            Long nextKey = bADkeys.nextElement();
            BBirAdjustedDeliveryEntry nextEntry = this.bADHashtable.get(nextKey);
            BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!nextEntry.getEndDateTime().isBefore(previousTime)) continue;
            this.bADHashtable.remove(nextKey);
        }
        this.reschedPurgeHashtable();
    }

    private void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime nextChangeOfDay = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)nextChangeOfDay, (Action)purgeHashtable, null);
    }
}

