/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.tls.enums.BTls350DataTypeEnum;
import com.tridium.tls.point.BTls350BadDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350DvDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350FmDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350IrrDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350ItiDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350ItsDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350LsaDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350PahDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350PointDeviceExt;
import com.tridium.tls.point.BTls350ProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="msgType", type="BTls350DataTypeEnum", defaultValue="BTls350DataTypeEnum.None"), @NiagaraProperty(name="dataType", type="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT")})
public class BTls350DemuxedProxyExt
extends BTls350ProxyExt {
    @Generated
    public static final Property msgType = BTls350DemuxedProxyExt.newProperty((int)0, (BValue)BTls350DataTypeEnum.None, null);
    @Generated
    public static final Property dataType = BTls350DemuxedProxyExt.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350DemuxedProxyExt.class);

    @Generated
    public BTls350DataTypeEnum getMsgType() {
        return (BTls350DataTypeEnum)this.get(msgType);
    }

    @Generated
    public void setMsgType(BTls350DataTypeEnum v) {
        this.set(msgType, (BValue)v, null);
    }

    @Generated
    public BDynamicEnum getDataType() {
        return (BDynamicEnum)this.get(dataType);
    }

    @Generated
    public void setDataType(BDynamicEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTls350DemuxedProxyExt() {
    }

    public BTls350DemuxedProxyExt(BTls350DataTypeEnum msgType) {
        this.setMsgType(msgType);
    }

    public BTls350DemuxedProxyExt(BTls350DataTypeEnum msgType, BDynamicEnum dataType) {
        this.setMsgType(msgType);
        this.setDataType(dataType);
    }

    @Override
    public Type getDeviceExtType() {
        BTls350DataTypeEnum msgType = this.getMsgType();
        if (msgType == BTls350DataTypeEnum.Tls350PriAlmHisMsgType) {
            return BTls350PahDemuxedPointDeviceExt.TYPE;
        }
        if (msgType == BTls350DataTypeEnum.Tls350BirAdjDelMsgType) {
            return BTls350BadDemuxedPointDeviceExt.TYPE;
        }
        if (msgType == BTls350DataTypeEnum.Tls350DelVarMsgType) {
            return BTls350DvDemuxedPointDeviceExt.TYPE;
        }
        if (msgType == BTls350DataTypeEnum.Tls350FuelMgmtMsgType) {
            return BTls350FmDemuxedPointDeviceExt.TYPE;
        }
        if (msgType == BTls350DataTypeEnum.Tls350InTankInvMsgType) {
            return BTls350ItiDemuxedPointDeviceExt.TYPE;
        }
        if (msgType == BTls350DataTypeEnum.Tls350InTankStaMsgType) {
            return BTls350ItsDemuxedPointDeviceExt.TYPE;
        }
        if (msgType == BTls350DataTypeEnum.Tls350LiqSenAlmHisMsgType) {
            return BTls350LsaDemuxedPointDeviceExt.TYPE;
        }
        if (msgType == BTls350DataTypeEnum.Tls350InvRecRowMsgType) {
            return BTls350IrrDemuxedPointDeviceExt.TYPE;
        }
        return BTls350PointDeviceExt.TYPE;
    }

    public void started() throws Exception {
    }

    public void stopped() throws Exception {
    }

    public void updateValueFrom(String[] newValuesSA) {
        if (newValuesSA != null && newValuesSA.length > 0) {
            int myDataTypeOrdinal;
            int mySAIndex = myDataTypeOrdinal = this.getDataType().getOrdinal();
            String myValueString = "";
            if (++mySAIndex < newValuesSA.length) {
                myValueString = newValuesSA[mySAIndex];
            }
            if (this.isTraceOn() && this.device().getUserData().indexOf("demux") != -1) {
                this.getLog().trace("BTls350DemuxedProxyExt proxy=" + this.getName() + " updateValueFrom mySAIndex=" + mySAIndex + " myValueString=" + myValueString);
            }
            if (this.getParentPoint() instanceof BNumericPoint) {
                try {
                    double myValue = Double.parseDouble(myValueString);
                    BStatusNumeric sv = (BStatusNumeric)this.getReadValue().newCopy();
                    if (this.isTraceOn() && this.device().getUserData().indexOf("demux") != -1) {
                        this.getLog().trace(this.device().getName() + " : " + this.getName() + " :setValue... newest value = " + myValue);
                    }
                    sv.setValue(myValue);
                    this.readOk((BStatusValue)sv);
                }
                catch (NumberFormatException nfe) {
                    this.readFail(nfe.toString());
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BNumericPoint nfe=" + nfe);
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BNumericPoint myValueString=" + myValueString);
                }
                catch (Exception e) {
                    this.readFail(e.toString());
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BNumericPoint e=" + e);
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BNumericPoint myValueString=" + myValueString);
                }
            } else if (this.getParentPoint() instanceof BStringPoint) {
                try {
                    String myValue = myValueString;
                    BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                    if (this.isTraceOn() && this.device().getUserData().indexOf("demux") != -1) {
                        this.getLog().trace(this.device().getName() + " : " + this.getName() + " :setValue... newest value = " + myValue);
                    }
                    sv.setValue(myValue);
                    this.readOk((BStatusValue)sv);
                }
                catch (NumberFormatException nfe) {
                    this.readFail(nfe.toString());
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BStringPoint nfe=" + nfe);
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BStringPoint myValueString=" + myValueString);
                }
                catch (Exception e) {
                    this.readFail(e.toString());
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BStringPoint e=" + e);
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BStringPoint myValueString=" + myValueString);
                }
            } else if (this.getParentPoint() instanceof BBooleanPoint) {
                try {
                    boolean myValue = false;
                    if (myValueString.equals("1") || myValueString.equalsIgnoreCase("true")) {
                        myValue = true;
                    }
                    BStatusBoolean sv = (BStatusBoolean)this.getReadValue().newCopy();
                    if (this.isTraceOn() && this.device().getUserData().indexOf("demux") != -1) {
                        this.getLog().trace(this.device().getName() + " : " + this.getName() + " :setValue... newest value = " + myValue);
                    }
                    sv.setValue(myValue);
                    this.readOk((BStatusValue)sv);
                }
                catch (NumberFormatException nfe) {
                    this.readFail(nfe.toString());
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BBooleanPoint nfe=" + nfe);
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BBooleanPoint myValueString=" + myValueString);
                }
                catch (Exception e) {
                    this.readFail(e.toString());
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BBooleanPoint e=" + e);
                    this.getLog().error("BTls350DemuxedProxyExt updateValueFrom BBooleanPoint myValueString=" + myValueString);
                }
            }
        }
    }
}

