/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.tls.enums.BTlsLiquidSensorStatusEnum;
import com.tridium.tls.messages.Tls350LiqSenDiagReport;
import com.tridium.tls.messages.Tls350LiqSenDiagReportResponse;
import com.tridium.tls.messages.Tls350LiqSenStaRequest;
import com.tridium.tls.messages.Tls350LiqSenStaResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350ConsoleDevicePointDeviceExt;
import com.tridium.tls.point.BTls350ProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minimumPollInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(2)"), @NiagaraProperty(name="sensorNumber", type="int", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="liquidChannelReadingAvg", type="float", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="liquidChannelReadingLast", type="float", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")})})
public class BTls350LiqSenStaProxyExt
extends BTls350ProxyExt
implements TlsMessageConst {
    @Generated
    public static final Property minimumPollInterval = BTls350LiqSenStaProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    @Generated
    public static final Property sensorNumber = BTls350LiqSenStaProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property liquidChannelReadingAvg = BTls350LiqSenStaProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property liquidChannelReadingLast = BTls350LiqSenStaProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350LiqSenStaProxyExt.class);

    @Generated
    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    @Generated
    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    @Generated
    public int getSensorNumber() {
        return this.getInt(sensorNumber);
    }

    @Generated
    public void setSensorNumber(int v) {
        this.setInt(sensorNumber, v, null);
    }

    @Generated
    public float getLiquidChannelReadingAvg() {
        return this.getFloat(liquidChannelReadingAvg);
    }

    @Generated
    public void setLiquidChannelReadingAvg(float v) {
        this.setFloat(liquidChannelReadingAvg, v, null);
    }

    @Generated
    public float getLiquidChannelReadingLast() {
        return this.getFloat(liquidChannelReadingLast);
    }

    @Generated
    public void setLiquidChannelReadingLast(float v) {
        this.setFloat(liquidChannelReadingLast, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350ConsoleDevicePointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        int sensorNumber = this.getSensorNumber();
        Tls350LiqSenStaRequest req = new Tls350LiqSenStaRequest(sensorNumber, this);
        Tls350LiqSenStaResponse rsp = (Tls350LiqSenStaResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow response returned");
                }
                if (sensorNumber == 0) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! sensor number not initialized... initialize sensor number to valid sensor\n\n");
                    return;
                }
                if (sensorNumber != rsp.getSensorNumber()) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! sensor number does no match response sensor number " + sensorNumber + "!=" + rsp.getSensorNumber() + "\n\n");
                    this.readFail("Error Response... Sensor number mismatch");
                    return;
                }
                BTlsLiquidSensorStatusEnum lsStateEnum = BTlsLiquidSensorStatusEnum.make(rsp.getSensorStatus().getOrdinal());
                BStatusEnum sv = new BStatusEnum((BEnum)lsStateEnum, BStatus.ok);
                this.readOk((BStatusValue)sv);
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response... Unsuccessful response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("Error Response... Null Response");
            this.device().ping();
        }
        Tls350LiqSenDiagReport req2 = new Tls350LiqSenDiagReport(sensorNumber, this);
        Tls350LiqSenDiagReportResponse rsp2 = (Tls350LiqSenDiagReportResponse)this.network().sendSync(req2);
        if (rsp2 != null && rsp2.getSuccessfulResponse()) {
            this.device().setPollSinceLastPingFlag();
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow response returned");
            }
            if (sensorNumber == 0) {
                System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! sensor number not initialized... initialize sensor number to valid sensor\n\n");
                return;
            }
            if (sensorNumber != rsp2.getSensorNumber()) {
                System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! sensor number does no match response sensor number " + sensorNumber + "!=" + rsp2.getSensorNumber() + "\n\n");
                this.readFail("Error Response... Sensor number mismatch");
                return;
            }
            this.setLiquidChannelReadingAvg(rsp2.getLiqChanAvgRead());
            this.setLiquidChannelReadingLast(rsp2.getLiqChanLastRead());
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }
}

