/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.util;

import com.tridium.tls.messages.TlsMessageConst;

public abstract class TlsUtil
implements TlsMessageConst {
    public static String getAlarmWarningCategoryString(int alarmWarningCategory) {
        switch (alarmWarningCategory) {
            case 0: {
                return "All Functions Normal";
            }
            case 1: {
                return "System Alarm";
            }
            case 2: {
                return "Tank Alarm";
            }
            case 3: {
                return "Liquid Sensor Alarm";
            }
            case 4: {
                return "Vapor Sensor Alarm";
            }
            case 5: {
                return "Input Alarm";
            }
            case 6: {
                return "Volumetric Line Leak Alarm";
            }
            case 7: {
                return "Groundwater Sensor Alarm";
            }
            case 8: {
                return "Type A Sensor Alarm";
            }
            case 12: {
                return "Type B Sensor Alarm";
            }
            case 13: {
                return "Universal Sensor Alarm";
            }
            case 14: {
                return "Auto-Dial Fax Alarm";
            }
            case 18: {
                return "Mechanical Dispenser Interface Alarm";
            }
            case 19: {
                return "Electronic Dispenser Interface Alarm";
            }
            case 20: {
                return "Product Alarm";
            }
            case 21: {
                return "Pressure Line Leak Alarm";
            }
            case 26: {
                return "Wireless PLLD Alarm";
            }
            case 28: {
                return "Smart Sensor Alarm";
            }
            case 29: {
                return "Modbus Alarm";
            }
            case 30: {
                return "ISD Site Alarm";
            }
            case 31: {
                return "ISD Hose Alarm";
            }
            case 32: {
                return "ISD Vapr Flow Meter Alarm";
            }
            case 33: {
                return "PMC Alarm";
            }
            case 34: {
                return "Pump Relay Monitor Alarm";
            }
            case 35: {
                return "VMCI Dsipenser Interface Alarm";
            }
            case 36: {
                return "VMC Alarm";
            }
            case 37: {
                return "APM Alarm";
            }
            case 99: {
                return "Externally Detected Alarm (not reported by Console)";
            }
        }
        return "Unknown alarmWarningCategory=" + alarmWarningCategory;
    }

    public static String getSensorCategoryString(int sensorCategory) {
        switch (sensorCategory) {
            case 0: {
                return "Other";
            }
            case 1: {
                return "Annular";
            }
            case 2: {
                return "Dispenser Pan";
            }
            case 3: {
                return "Monitoring Well";
            }
            case 4: {
                return "STP Sump";
            }
            case 5: {
                return "Piping Sump";
            }
        }
        return "Unknown sensorCategory=" + sensorCategory;
    }

    public static String getAlarmTypeNumberString(int alarmWarningCategory, int alarmTypeNumber) {
        if (alarmWarningCategory == 0) {
            return " ";
        }
        if (alarmWarningCategory == 1) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Printer out of Paper";
                }
                case 2: {
                    return "Printer Error";
                }
                case 3: {
                    return "EEPROM Configuration Error";
                }
                case 4: {
                    return "Battery Off";
                }
                case 5: {
                    return "Too Many Tanks";
                }
                case 6: {
                    return "System Security Warning";
                }
                case 7: {
                    return "ROM Revision Warning";
                }
                case 8: {
                    return "Remote Display Communications Error";
                }
                case 9: {
                    return "Autodial Error";
                }
                case 10: {
                    return "Software Module Warning";
                }
                case 11: {
                    return "Tank Test Shutdown Warning";
                }
                case 12: {
                    return "Protective Cover Alarm";
                }
                case 13: {
                    return "BIR Shift Close Pending";
                }
                case 14: {
                    return "BIR Daily Close Pending";
                }
                case 15: {
                    return "PC(H8) Revision Warning";
                }
                case 16: {
                    return "System Self Test Error";
                }
                case 17: {
                    return "System Clock Incorrect Warning";
                }
                case 18: {
                    return "System Device Poll Timeout";
                }
                case 19: {
                    return "Maintenance Tracker NVMem Removed";
                }
                case 20: {
                    return "Maintenance Tracker Communications Module Removed";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 2) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Tank Setup Data Warning";
                }
                case 2: {
                    return "Tank Leak Alarm";
                }
                case 3: {
                    return "Tank High Water Alarm";
                }
                case 4: {
                    return "Tank Overfill Alarm";
                }
                case 5: {
                    return "Tank Low Product Alarm";
                }
                case 6: {
                    return "Tank Sudden Loss Alarm";
                }
                case 7: {
                    return "Tank High Product Alarm";
                }
                case 8: {
                    return "Tank Invalid Fuel Level Alarm";
                }
                case 9: {
                    return "Tank Probe Out Alarm";
                }
                case 10: {
                    return "Tank High Water Warning";
                }
                case 11: {
                    return "Tank Delivery Needed Warning";
                }
                case 12: {
                    return "Tank Maximum Product Alarm";
                }
                case 13: {
                    return "Tank Gross Leak Test Fail Alarm";
                }
                case 14: {
                    return "Tank Periodic Leak Test Fail Alarm";
                }
                case 15: {
                    return "Tank Annual Leak Test Fail Alarm";
                }
                case 16: {
                    return "Tank Periodic Test Needed Warning";
                }
                case 17: {
                    return "Tank Annual Test Needed Warning";
                }
                case 18: {
                    return "Tank Periodic Test Needed Alarm";
                }
                case 19: {
                    return "Tank Annual Test Needed Alarm";
                }
                case 20: {
                    return "Tank Leak Test Active";
                }
                case 21: {
                    return "Tank No CSLD Idle Time Warning";
                }
                case 22: {
                    return "Tank Siphon Break Active Warning";
                }
                case 23: {
                    return "Tank CSLD Rate Increase Warning";
                }
                case 24: {
                    return "Tank AccuChart Calibration Warning";
                }
                case 25: {
                    return "Tank HRM Reconciliation Warning";
                }
                case 26: {
                    return "Tank HRM Reconciliation Alarm";
                }
                case 27: {
                    return "Tank Cold Temperature Warning";
                }
                case 28: {
                    return "Tank Missing Delivery Ticket Warning";
                }
                case 29: {
                    return "Tank/Line Gross Leak Alarm";
                }
                case 30: {
                    return "Delivery Density Warning";
                }
                case 31: {
                    return "Density Warning";
                }
                case 32: {
                    return "Fuel Quality Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 3 || alarmWarningCategory == 4 || alarmWarningCategory == 7 || alarmWarningCategory == 8 || alarmWarningCategory == 12 || alarmWarningCategory == 13) {
            switch (alarmTypeNumber) {
                case 2: {
                    return "Sensor Setup Data Warning";
                }
                case 3: {
                    return "Sensor Fuel Alarm";
                }
                case 4: {
                    return "Sensor Out Alarm";
                }
                case 5: {
                    return "Sensor Short Alarm";
                }
                case 6: {
                    return "Sensor Water Alarm";
                }
                case 7: {
                    return "Sensor Water Out Alarm";
                }
                case 8: {
                    return "Sensor High Liquid Alarm";
                }
                case 9: {
                    return "Sensor Low Liquid Alarm";
                }
                case 10: {
                    return "Sensor Liquid Warning";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 5) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Input Setup Data Warning";
                }
                case 2: {
                    return "Input Normal";
                }
                case 3: {
                    return "Input Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 6) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "VLLD Setup Data Warning";
                }
                case 2: {
                    return "VLLD Self Test Alarm";
                }
                case 3: {
                    return "VLLD Shutdown Alarm";
                }
                case 4: {
                    return "VLLD Leak Test Fail Alarm";
                }
                case 5: {
                    return "VLLD Selftest Invalid Warning";
                }
                case 6: {
                    return "VLLD Continuous Handle On Warning";
                }
                case 7: {
                    return "VLLD Gross Line Test Fail Alarm";
                }
                case 8: {
                    return "VLLD Gross Line Selftest Fail Alarm";
                }
                case 9: {
                    return "VLLD Gross Pump Test Fail Alarm";
                }
                case 10: {
                    return "VLLD Gross Pump Selftest Fail Alarm";
                }
                case 11: {
                    return "VLLD Periodic Test Needed Warning";
                }
                case 12: {
                    return "VLLD Annual Test Needed Warning";
                }
                case 13: {
                    return "VLLD Periodic Test Needed Alarm";
                }
                case 14: {
                    return "VLLD Annual Test Needed Alarm";
                }
                case 15: {
                    return "VLLD Periodic Line Test Fail Alarm";
                }
                case 16: {
                    return "VLLD Periodic Line Selftest Fail Alarm";
                }
                case 17: {
                    return "VLLD Periodic Pump Test Fail Alarm";
                }
                case 18: {
                    return "VLLD Periodic Pump Selftest Fail Alarm";
                }
                case 19: {
                    return "VLLD Annual Line Test Fail Alarm";
                }
                case 20: {
                    return "VLLD Annual Line Selftest Fail Alarm";
                }
                case 21: {
                    return "VLLD Annual Pump Test Fail Alarm";
                }
                case 22: {
                    return "VLLD Annual Pump Selftest Fail Alarm";
                }
                case 23: {
                    return "VLLD Pressure Warning";
                }
                case 24: {
                    return "VLLD Pressure Alarm";
                }
                case 25: {
                    return "VLLD Gross Test Fault Alarm";
                }
                case 26: {
                    return "VLLD Periodic Test Fault Alarm";
                }
                case 27: {
                    return "VLLD Annual Test Fault Alarm";
                }
                case 28: {
                    return "VLLD Fuel Out Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 14) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Autodial Setup Data Warning";
                }
                case 2: {
                    return "Autodial Failed Alarm";
                }
                case 3: {
                    return "Autodial Service Report Warning (Added in V19)";
                }
                case 4: {
                    return "Autodial Alarm Clear Warning (Added in V19)";
                }
                case 5: {
                    return "Autodial Delivery Report Warning (Added in V19)";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 18 || alarmWarningCategory == 19) {
            switch (alarmTypeNumber) {
                case 2: {
                    return "DIM Disabled Alarm";
                }
                case 3: {
                    return "DIM Communication Failure Alarm";
                }
                case 4: {
                    return "DIM Transaction Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 20) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "BIR Setup Data Warning";
                }
                case 2: {
                    return "BIR Threshold Alarm";
                }
                case 3: {
                    return "BIR Close Shift Warning";
                }
                case 4: {
                    return "BIR Close Daily Warning";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 21) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "PLLD Setup Data Warning";
                }
                case 2: {
                    return "PLLD Gross Test Fail Alarm";
                }
                case 3: {
                    return "PLLD Annual Test Fail Alarm";
                }
                case 4: {
                    return "PLLD Periodic Test Needed Warning";
                }
                case 5: {
                    return "PLLD Periodic Test Needed Alarm";
                }
                case 6: {
                    return "PLLD Sensor Open Alarm";
                }
                case 7: {
                    return "PLLD High Pressure Alarm (Obsolete V19)";
                }
                case 8: {
                    return "PLLD Shutdown Alarm";
                }
                case 9: {
                    return "PLLD High Pressure Warning (Obsolete V19)";
                }
                case 10: {
                    return "PLLD Continuous Handle On Warning (Obsolete V19)";
                }
                case 11: {
                    return "PLLD Periodic Test Fail Alarm";
                }
                case 12: {
                    return "PLLD Annual Test Needed Warning";
                }
                case 13: {
                    return "PLLD Annual Test Needed Alarm";
                }
                case 14: {
                    return "PLLD Low Pressure Alarm";
                }
                case 15: {
                    return "PLLD Sensor Short Alarm (Obsolete V19)";
                }
                case 16: {
                    return "PLLD Continuous Handle On Alarm";
                }
                case 17: {
                    return "PLLD Fuel Out Alarm";
                }
                case 18: {
                    return "PLLD Line Equipment Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 26) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "WPLLD Setup Data Warning";
                }
                case 2: {
                    return "WPLLD Gross Test Fail Alarm";
                }
                case 3: {
                    return "WPLLD Periodic Test Fail Alarm";
                }
                case 4: {
                    return "WPLLD Periodic Test Needed Warning";
                }
                case 5: {
                    return "WPLLD Periodic Test Needed Alarm";
                }
                case 6: {
                    return "WPLLD Sensor Open Alarm";
                }
                case 7: {
                    return "WPLLD Communications Alarm";
                }
                case 8: {
                    return "WPLLD Shutdown Alarm";
                }
                case 9: {
                    return "WPLLD Continuous Handle On Warning (Obsolete V19)";
                }
                case 10: {
                    return "WPLLD Annual Test Fail Alarm";
                }
                case 11: {
                    return "WPLLD Annual Test Needed Warning";
                }
                case 12: {
                    return "WPLLD Annual Test Needed Alarm";
                }
                case 13: {
                    return "WPLLD High Pressure Warning (Obsolete V19)";
                }
                case 14: {
                    return "WPLLD High Pressure Alarm (Obsolete V19)";
                }
                case 15: {
                    return "WPLLD Sensor Short Alarm (Obsolete V19)";
                }
                case 16: {
                    return "WPLLD Continuous Handle On Alarm";
                }
                case 17: {
                    return "WPLLD Fuel Out Alarm";
                }
                case 18: {
                    return "WPLLD Line Equipment Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 28) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Smart Sensor Setup Data Warning";
                }
                case 2: {
                    return "Smart Sensor Communication Alarm";
                }
                case 3: {
                    return "Smart Sensor Fault Alarm";
                }
                case 4: {
                    return "Smart Sensor Fuel Warning";
                }
                case 5: {
                    return "Smart Sensor Fuel Alarm";
                }
                case 6: {
                    return "Smart Sensor Water Warning";
                }
                case 7: {
                    return "Smart Sensor Water Alarm";
                }
                case 8: {
                    return "Smart Sensor High Liquid Warning";
                }
                case 9: {
                    return "Smart Sensor High Liquid Alarm";
                }
                case 10: {
                    return "Smart Sensor Low Liquid Warning";
                }
                case 11: {
                    return "Smart Sensor Low Liquid Alarm";
                }
                case 12: {
                    return "Smart Sensor Temperature Warning";
                }
                case 13: {
                    return "Smart Sensor Relay Active";
                }
                case 14: {
                    return "Smart Sensor Install Alarm";
                }
                case 15: {
                    return "Smart Sensor Sensor Fault";
                }
                case 16: {
                    return "Smart Sensor Vacuum Warning";
                }
                case 17: {
                    return "Smart Sensor No Vacuum Warning";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 29) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Improper Setup alarm";
                }
                case 2: {
                    return "Communication Loss alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 30) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Stage 1 Transfer Monitoring Failure warning";
                }
                case 2: {
                    return "Containment Monitoring Gross Failure warning";
                }
                case 3: {
                    return "Containment Monitoring Gross Failure alarm";
                }
                case 4: {
                    return "Containment Monitoring Degradation Failure";
                }
                case 5: {
                    return "Containment Monitoring Degradation Failure";
                }
                case 6: {
                    return "Containment Monitoring CVLD Failure warning";
                }
                case 7: {
                    return "Containment Monitoring CVLD Failure alarm";
                }
                case 8: {
                    return "Vapor Processor Over Pressure Failure warning";
                }
                case 9: {
                    return "Vapor Processor Over Pressure Failure alarm";
                }
                case 10: {
                    return "Vapor Processor Status Test warning";
                }
                case 11: {
                    return "Vapor Processor Status Test alarm";
                }
                case 12: {
                    return "Missing Relay Setup alarm";
                }
                case 13: {
                    return "Missing Hose Setup alarm";
                }
                case 14: {
                    return "Missing Tank Setup alarm";
                }
                case 15: {
                    return "Missing Vapor Flow Meter alarm";
                }
                case 16: {
                    return "Missing Vapor Pressure Sensor alarm";
                }
                case 17: {
                    return "Missing Vapor Pressure Input alarm";
                }
                case 18: {
                    return "Setup Fail warning";
                }
                case 19: {
                    return "Setup Fail alarm";
                }
                case 20: {
                    return "Sensor Out warning";
                }
                case 21: {
                    return "Sensor Out alarm";
                }
                case 22: {
                    return "PC-ISD Offline";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 31) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Collection Monitoring Gross Failure warning";
                }
                case 2: {
                    return "Collection Monitoring Gross Failure alarm";
                }
                case 3: {
                    return "Collection Monitoring Degradation Failure warning";
                }
                case 4: {
                    return "Collection Monitoring Degradation Failure alarm";
                }
                case 5: {
                    return "Flow Performance Hose Blockage Failure warning";
                }
                case 6: {
                    return "Flow Performance Hose Blockage Failure alarm";
                }
                case 7: {
                    return "Vapor Flow Meter Setup alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 32) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Locked rotor alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 33) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Vapor Processor Run Time Fault warning";
                }
                case 2: {
                    return "Processor Monitoring Effluent Emissions Failure warning";
                }
                case 3: {
                    return "Processor Monitoring Effluent Emissions Failure alarm";
                }
                case 4: {
                    return "Processor Monitoring Over Pressure Failure warning";
                }
                case 5: {
                    return "Processor Monitoring Over Pressure Failure alarm";
                }
                case 6: {
                    return "Processor Monitoring Duty Cycle Failure warning";
                }
                case 7: {
                    return "Processor Monitoring Duty Cycle Failure alarm";
                }
                case 8: {
                    return "PMC (stand alone mode only) Setup warning";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 34) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Setup Data Warning";
                }
                case 2: {
                    return "Pump Relay Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 35) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Setup Data Warning";
                }
                case 2: {
                    return "Disabled VMCI Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 36) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "VMC Comm timeout";
                }
                case 2: {
                    return "Meter Not Connected";
                }
                case 3: {
                    return "FP Shutdown Warning";
                }
                case 4: {
                    return "FP Shutdown Alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 37) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Gross Over-Pressure Test Warning";
                }
                case 2: {
                    return "APM Gross Over-Pressure Test Failure warning";
                }
                case 3: {
                    return "APM Gross Over-Pressure Test Failure alarm";
                }
                case 4: {
                    return "APM Degradation Over-Pressure Test Failure warning";
                }
                case 5: {
                    return "APM Degradation Over-Pressure Test Failure alarm";
                }
                case 6: {
                    return "APM Sensor Test Failure warning";
                }
                case 7: {
                    return "APM Sensor Test Failure alarm";
                }
                case 8: {
                    return "APM Setup Failure warning";
                }
                case 9: {
                    return "APM Sensor Out Failure warning";
                }
                case 10: {
                    return "APM Sensor Out Failure alarm";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        if (alarmWarningCategory == 99) {
            switch (alarmTypeNumber) {
                case 1: {
                    return "Externally Dectected Communication Alarm";
                }
                case 2: {
                    return "Communications: return - Data Reception Timeout";
                }
                case 3: {
                    return "Communications: return - Failed Checksum";
                }
                case 4: {
                    return "Communications: return - Parity Error";
                }
                case 5: {
                    return "Modem - return - Line Busy";
                }
                case 6: {
                    return "Modem - No Answer";
                }
                case 7: {
                    return "Modem - No Carrier";
                }
                case 8: {
                    return "Modem - No Dial Tone";
                }
                case 9: {
                    return "Modem - Modem Error";
                }
                case 10: {
                    return "Modem - Modem Not Responding";
                }
                case 11: {
                    return "Modem - Port Not Available";
                }
                case 12: {
                    return "Polling - Could Not Update Queue";
                }
                case 13: {
                    return "Polling - Invalid Data Type Requested";
                }
            }
            return "Unknown alarmTypeNumber=" + alarmTypeNumber + " for alarmWarningCategory=" + alarmWarningCategory;
        }
        return "Unknown alarmWarningCategory=" + alarmWarningCategory;
    }

    public static String getAlarmStateString(int alarmState) {
        switch (alarmState) {
            case 1: {
                return "Cleared";
            }
            case 2: {
                return "Occurred";
            }
        }
        return "Unknown=" + alarmState;
    }

    public static String getAlarmTypeString(int alarmType) {
        switch (alarmType) {
            case 1: {
                return "A01 Tank Setup Data Warning";
            }
            case 2: {
                return "A02 Tank Leak Alarm";
            }
            case 3: {
                return "A03 Tank High Water Alarm";
            }
            case 4: {
                return "A04 Tank Overfill Alarm";
            }
            case 5: {
                return "A05 Tank Low Product Alarm";
            }
            case 6: {
                return "A06 Tank Sudden Loss Alarm";
            }
            case 7: {
                return "A07 Tank High Product Alarm";
            }
            case 8: {
                return "A08 Tank Invalid Level Alarm";
            }
            case 9: {
                return "A09 Tank Probe Out Alarm";
            }
            case 10: {
                return "A10 Tank High Water Warning";
            }
            case 11: {
                return "A11 Tank Delivery Needed Warning";
            }
            case 12: {
                return "A12 Tank Maximum Product Alarm";
            }
            case 13: {
                return "A13 Tank Gross Leak Test Fail Alarm";
            }
            case 14: {
                return "A14 Tank Periodic Leak Test Fail Alarm";
            }
            case 15: {
                return "A15 Tank Annual Leak Test Fail Alarm";
            }
            case 16: {
                return "A16 Tank Periodic Test Needed Warning";
            }
            case 17: {
                return "A17 Tank Annual Test Needed Warning";
            }
            case 18: {
                return "A18 Tank Periodic Test Needed Alarm";
            }
            case 19: {
                return "A19 Tank Annual Test Needed Alarm";
            }
            case 20: {
                return "A20 Tank Leak Test Active";
            }
            case 21: {
                return "A21 Tank No CSLD Idle Time Warning";
            }
            case 22: {
                return "A22 Tank Siphon Break Active Warning";
            }
            case 23: {
                return "A23 Tank CSLD Rate Increase Warning";
            }
            case 24: {
                return "A24 Tank AccuChart Calibration Warning";
            }
            case 25: {
                return "A25 Tank HRM Reconciliation Warning";
            }
            case 26: {
                return "A26 Tank HRM Reconciliation Alarm";
            }
            case 27: {
                return "A27 Tank Cold Temperature Warning";
            }
            case 28: {
                return "A28 Tank Missing Delivery Ticket Warning";
            }
            case 29: {
                return "A29 Tank/Line Gross Leak Alarm";
            }
            case 30: {
                return "A30 Delivery Density Warning";
            }
            case 31: {
                return "A31 Density Warning";
            }
            case 32: {
                return "A32 Fuel Quality Alarm";
            }
        }
        return "Unknown alarmType=" + alarmType;
    }

    public static final short calcTlsChksum(byte[] data, int length) {
        short checksum = 0;
        for (int i = 0; i < length; ++i) {
            checksum = (short)(checksum + data[i]);
        }
        checksum = ~checksum;
        return checksum;
    }
}

