/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.certificate;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NRsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alias", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="commonName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="organizationalUnit", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="organization", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="locality", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="stateProvince", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="countryCode", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="notBefore", type="BAbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="notAfter", type="BAbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="keySize", type="int", defaultValue="2048"), @NiagaraProperty(name="purpose", type="int", defaultValue="KeyPurpose.SERVER_CERT.getValue()"), @NiagaraProperty(name="alternateServerName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="alternateServerUri", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="emailAddress", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="keyUsage", type="int", defaultValue="0")})
public class BGenerateCertJobStep
extends BDeviceJobStep {
    @Generated
    public static final Property alias = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property commonName = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property organizationalUnit = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property organization = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property locality = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property stateProvince = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property countryCode = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property notBefore = BGenerateCertJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property notAfter = BGenerateCertJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property keySize = BGenerateCertJobStep.newProperty((int)0, (int)2048, null);
    @Generated
    public static final Property purpose = BGenerateCertJobStep.newProperty((int)0, (int)KeyPurpose.SERVER_CERT.getValue(), null);
    @Generated
    public static final Property alternateServerName = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property alternateServerUri = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property emailAddress = BGenerateCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property password = BGenerateCertJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property keyUsage = BGenerateCertJobStep.newProperty((int)0, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BGenerateCertJobStep.class);
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Generated
    public String getAlias() {
        return this.getString(alias);
    }

    @Generated
    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    @Generated
    public String getCommonName() {
        return this.getString(commonName);
    }

    @Generated
    public void setCommonName(String v) {
        this.setString(commonName, v, null);
    }

    @Generated
    public String getOrganizationalUnit() {
        return this.getString(organizationalUnit);
    }

    @Generated
    public void setOrganizationalUnit(String v) {
        this.setString(organizationalUnit, v, null);
    }

    @Generated
    public String getOrganization() {
        return this.getString(organization);
    }

    @Generated
    public void setOrganization(String v) {
        this.setString(organization, v, null);
    }

    @Generated
    public String getLocality() {
        return this.getString(locality);
    }

    @Generated
    public void setLocality(String v) {
        this.setString(locality, v, null);
    }

    @Generated
    public String getStateProvince() {
        return this.getString(stateProvince);
    }

    @Generated
    public void setStateProvince(String v) {
        this.setString(stateProvince, v, null);
    }

    @Generated
    public String getCountryCode() {
        return this.getString(countryCode);
    }

    @Generated
    public void setCountryCode(String v) {
        this.setString(countryCode, v, null);
    }

    @Generated
    public BAbsTime getNotBefore() {
        return (BAbsTime)this.get(notBefore);
    }

    @Generated
    public void setNotBefore(BAbsTime v) {
        this.set(notBefore, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNotAfter() {
        return (BAbsTime)this.get(notAfter);
    }

    @Generated
    public void setNotAfter(BAbsTime v) {
        this.set(notAfter, (BValue)v, null);
    }

    @Generated
    public int getKeySize() {
        return this.getInt(keySize);
    }

    @Generated
    public void setKeySize(int v) {
        this.setInt(keySize, v, null);
    }

    @Generated
    public int getPurpose() {
        return this.getInt(purpose);
    }

    @Generated
    public void setPurpose(int v) {
        this.setInt(purpose, v, null);
    }

    @Generated
    public String getAlternateServerName() {
        return this.getString(alternateServerName);
    }

    @Generated
    public void setAlternateServerName(String v) {
        this.setString(alternateServerName, v, null);
    }

    @Generated
    public String getAlternateServerUri() {
        return this.getString(alternateServerUri);
    }

    @Generated
    public void setAlternateServerUri(String v) {
        this.setString(alternateServerUri, v, null);
    }

    @Generated
    public String getEmailAddress() {
        return this.getString(emailAddress);
    }

    @Generated
    public void setEmailAddress(String v) {
        this.setString(emailAddress, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public int getKeyUsage() {
        return this.getInt(keyUsage);
    }

    @Generated
    public void setKeyUsage(int v) {
        this.setInt(keyUsage, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BGenerateCertJobStep() {
    }

    public BGenerateCertJobStep(String alias, String commonName, String organizationalUnit, String organization, String locality, String stateProvince, String countryCode, BAbsTime notBefore, BAbsTime notAfter, int keySize, int purpose, String alternativeServerName, String emailAddress, BPassword password) {
        this(alias, commonName, organizationalUnit, organization, locality, stateProvince, countryCode, notBefore, notAfter, keySize, purpose, alternativeServerName, "", emailAddress, password, 0);
    }

    public BGenerateCertJobStep(String alias, String commonName, String organizationalUnit, String organization, String locality, String stateProvince, String countryCode, BAbsTime notBefore, BAbsTime notAfter, int keySize, int purpose, String alternativeServerName, String alternativeServerUri, String emailAddress, BPassword password, int keyUsage) {
        this.setAlias(alias);
        this.setCommonName(commonName);
        this.setOrganizationalUnit(organizationalUnit);
        this.setOrganization(organization);
        this.setLocality(locality);
        this.setStateProvince(stateProvince);
        this.setCountryCode(countryCode);
        this.setNotBefore(notBefore);
        this.setNotAfter(notAfter);
        this.setKeySize(keySize);
        this.setPurpose(purpose);
        this.setAlternateServerName(alternativeServerName);
        this.setAlternateServerUri(alternativeServerUri);
        this.setEmailAddress(emailAddress);
        if (password != null) {
            this.setPassword(password);
        }
        this.setKeyUsage(keyUsage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BSession session = this.getSession(util);
            String tempName = this.getCommonName();
            if (tempName.equals(lex.getText("GenerateCertDialog.hostname"))) {
                tempName = session.getHost().getHostname();
            }
            String dn = CertUtils.assembleDN((String)(tempName.length() > 0 ? tempName : null), (String)(this.getOrganizationalUnit().length() > 0 ? this.getOrganizationalUnit() : null), (String)(this.getOrganization().length() > 0 ? this.getOrganization() : null), (String)(this.getLocality().length() > 0 ? this.getLocality() : null), (String)(this.getStateProvince().length() > 0 ? this.getStateProvince() : null), (String)(this.getCountryCode().length() > 0 ? this.getCountryCode() : null));
            NCertificateParameters certParams = new NCertificateParameters(this.getAlias(), dn, dn, new Date(this.getNotBefore().getMillis()), new Date(this.getNotAfter().getMillis()), this.getKeySize(), KeyPurpose.values()[this.getPurpose()], this.getAlternateServerName().length() > 0 ? this.getAlternateServerName() : null, this.getAlternateServerUri().length() > 0 ? this.getAlternateServerUri() : null, this.getEmailAddress().length() > 0 ? this.getEmailAddress() : null, this.getPassword() != null && !this.getPassword().isDefault() ? AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()) : null, this.getKeyUsage());
            NX509CertificateBuilder builder = CertUtils.createCertBuilderFromParameters((NCertificateParameters)certParams);
            ICoreCryptoManager ccm = this.getPlatCryptoManager(session, util);
            try {
                details.message("provisioningNiagara", "GenerateCertJobStep.generating");
                SecretChars password = this.getPassword() != null && !this.getPassword().isDefault() ? new SecretChars(AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()).toCharArray(), false) : null;
                int requestId = ccm.generateSelfSignedCert(builder, (NKeyPairGenerator)new NRsaKeyPairGenerator(this.getKeySize()), password);
                while (true) {
                    int status;
                    if ((status = ccm.getCertGenerationStatus(requestId)) == -1) {
                        details.failed("provisioningNiagara", "GenerateCertJobStep.failed");
                        details.complete(BJobState.failed);
                        break;
                    }
                    if (status == 2) {
                        details.message("provisioningNiagara", "GenerateCertJobStep.generated");
                        details.success();
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                util.reset();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    protected BSession getSession(ProvisioningConnectionUtil util) throws Exception {
        boolean stationRunning = util.hasRunningStation();
        Object session = stationRunning ? util.getEngagedFoxSession() : util.getDaemonSession();
        return session;
    }

    protected ICoreCryptoManager getPlatCryptoManager(BSession session, ProvisioningConnectionUtil util) throws Exception {
        BPlatCryptoManager ccm;
        boolean stationRunning = util.hasRunningStation();
        if (stationRunning) {
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)session);
            ccm = new ChannelCryptoManager((BComponent)remoteCertService);
        } else {
            ccm = new BPlatCryptoManager((BDaemonSession)session);
        }
        return ccm;
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        String alias = this.getAlias();
        String commonName = this.getCommonName();
        String organization = this.getOrganization();
        return this.getLexicon().getText("GenerateCertJobStep.display", new Object[]{alias, commonName, organization});
    }
}

