/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.certificate;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.ui.certificate.BFileNameFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fileNaming", type="BFileNameFormat", defaultValue="BFileNameFormat.DEFAULT"), @NiagaraProperty(name="serverCertAlias", type="String", defaultValue="BString.DEFAULT", deprecated=true), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="certAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="useFilenameForAlias", type="boolean", defaultValue="false")})
public class BImportSignedCertificateJobStep
extends BDeviceJobStep {
    @Generated
    public static final Property fileNaming = BImportSignedCertificateJobStep.newProperty((int)0, (BValue)BFileNameFormat.DEFAULT, null);
    @Deprecated
    @Generated
    public static final Property serverCertAlias = BImportSignedCertificateJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property password = BImportSignedCertificateJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property certAliasAndPassword = BImportSignedCertificateJobStep.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property useFilenameForAlias = BImportSignedCertificateJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BImportSignedCertificateJobStep.class);
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Generated
    public BFileNameFormat getFileNaming() {
        return (BFileNameFormat)this.get(fileNaming);
    }

    @Generated
    public void setFileNaming(BFileNameFormat v) {
        this.set(fileNaming, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public String getServerCertAlias() {
        return this.getString(serverCertAlias);
    }

    @Deprecated
    @Generated
    public void setServerCertAlias(String v) {
        this.setString(serverCertAlias, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(certAliasAndPassword);
    }

    @Generated
    public void setCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(certAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public boolean getUseFilenameForAlias() {
        return this.getBoolean(useFilenameForAlias);
    }

    @Generated
    public void setUseFilenameForAlias(boolean v) {
        this.setBoolean(useFilenameForAlias, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BImportSignedCertificateJobStep() {
    }

    public BImportSignedCertificateJobStep(BFileNameFormat fileNaming, boolean useFilenameForAlias, String serverCertAlias, BPassword privateKeyPassword, BPassword certificatePassword) {
        this.setFileNaming(fileNaming);
        this.setUseFilenameForAlias(useFilenameForAlias);
        this.setServerCertAlias(serverCertAlias);
        if (privateKeyPassword != null) {
            this.setPassword(privateKeyPassword);
        }
        this.getCertAliasAndPassword().setAlias(serverCertAlias);
        this.getCertAliasAndPassword().setPassword(certificatePassword);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            ICoreKeyStore keyStore;
            Throwable throwable;
            String certAlias;
            BDaemonSession session = util.getDaemonSession();
            BFileNameFormat fileNaming = this.getFileNaming();
            String fileName = fileNaming == BFileNameFormat.hostname ? ((BNiagaraStation)device).getRemoteHost().getHostname() : (fileNaming == BFileNameFormat.hostId ? session.getHostProperties().getHostId() : ((BNiagaraStation)device).getStationName());
            if (this.getUseFilenameForAlias()) {
                certAlias = fileName;
                fileName = fileName + ".pem";
            } else {
                certAlias = this.getCertAliasAndPassword().getAlias();
                fileName = fileName + '.' + this.getCertAliasAndPassword().getAlias() + ".pem";
            }
            File folder = new File(Sys.getStationHome(), "certImport");
            File pemFile = new File(folder, fileName);
            if (!pemFile.exists()) {
                details.failed("provisioningNiagara", "ImportSignedCertificate.failed.doesNotExist", pemFile.getAbsolutePath());
                details.complete(BJobState.failed);
                return;
            }
            Array certs = new Array(X509Certificate.class);
            PrivateKey pkey = null;
            try (FileInputStream fis = new FileInputStream(pemFile);){
                throwable = null;
                try (InputStreamReader isr = new InputStreamReader(fis);
                     FriendlyPemReader fpr = new FriendlyPemReader((Reader)isr);
                     PEMParser pr = new PEMParser((Reader)fpr);){
                    Object obj = pr.readObject();
                    while (obj != null) {
                        JcaPEMKeyConverter converter;
                        JcePEMDecryptorProviderBuilder builder;
                        if (obj instanceof X509Certificate) {
                            certs.add((Object)((X509Certificate)obj));
                        } else if (obj instanceof X509CertificateHolder) {
                            X509Certificate cert = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)obj);
                            certs.add((Object)cert);
                        } else if (obj instanceof PrivateKey) {
                            if (pkey != null) throw new IOException(LEX.get("ImportSignedCertificate.failed.multipleKeys"));
                            pkey = (PrivateKey)obj;
                        } else if (obj instanceof KeyPair) {
                            if (pkey != null) throw new IOException(LEX.get("ImportSignedCertificate.failed.multipleKeys"));
                            pkey = ((KeyPair)obj).getPrivate();
                        } else if (obj instanceof PEMKeyPair) {
                            if (pkey != null) throw new IOException(LEX.get("ImportSignedCertificate.failed.multipleKeys"));
                            pkey = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).getPrivateKey(((PEMKeyPair)obj).getPrivateKeyInfo());
                        } else if (obj instanceof PEMEncryptedKeyPair) {
                            if (pkey != null) throw new IOException(LEX.get("ImportSignedCertificate.failed.multipleKeys"));
                            builder = new JcePEMDecryptorProviderBuilder().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                            PEMDecryptorProvider decryptor = builder.build(AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()).toCharArray());
                            converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                            pkey = converter.getPrivateKey(((PEMEncryptedKeyPair)obj).decryptKeyPair(decryptor).getPrivateKeyInfo());
                        } else if (obj instanceof PKCS8EncryptedPrivateKeyInfo) {
                            builder = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                            InputDecryptorProvider pkcs8Prov = builder.build(AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()).toCharArray());
                            converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                            pkey = converter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)obj).decryptPrivateKeyInfo(pkcs8Prov));
                        } else {
                            if (!(obj instanceof PrivateKeyInfo)) throw new IOException(LEX.get("ImportSignedCertificate.failed.unsupportedObjectType") + obj.getClass().getName());
                            JcaPEMKeyConverter converter2 = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                            pkey = converter2.getPrivateKey((PrivateKeyInfo)obj);
                        }
                        obj = pr.readObject();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "ImportSignedCertificate.failed.fileParse", pemFile.getAbsolutePath(), (Throwable)e);
                details.complete(BJobState.failed);
                if (util == null) return;
                if (var6_7 != null) {
                    try {
                        util.close();
                        return;
                    }
                    catch (Throwable throwable3) {
                        var6_7.addSuppressed(throwable3);
                    }
                    return;
                } else {
                    util.close();
                }
                return;
            }
            BPlatCryptoManager remoteCoreCryptoManager = this.getPlatCryptoManager(session);
            try {
                keyStore = remoteCoreCryptoManager.getKeyStore();
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "ImportSignedCertificate.failed.keyStore", (Throwable)e);
                details.complete(BJobState.failed);
                if (util == null) return;
                if (var6_7 != null) {
                    try {
                        util.close();
                        return;
                    }
                    catch (Throwable throwable4) {
                        var6_7.addSuppressed(throwable4);
                    }
                    return;
                } else {
                    util.close();
                }
                return;
            }
            if (keyStore == null) {
                details.failed("provisioningNiagara", "ImportSignedCertificate.failed.keyStore");
                details.complete(BJobState.failed);
                return;
            }
            if (pkey == null) {
                if (this.getCertAliasAndPassword().getPassword().isDefault()) {
                    pkey = (PrivateKey)keyStore.getKey(certAlias, null);
                } else {
                    throwable = null;
                    try (SecretChars certificatePasswordValue = SecretChars.fromString((String)AccessController.doPrivileged(() -> ((BPassword)this.getCertAliasAndPassword().getPassword()).getValue()));){
                        pkey = (PrivateKey)keyStore.getKey(certAlias, certificatePasswordValue.get());
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
            }
            if (pkey == null) {
                details.failed("provisioningNiagara", "ImportSignedCertificate.failed.privateKey");
                details.complete(BJobState.failed);
                return;
            }
            X509Certificate[] xChain = CertUtils.sortCertChain((List)certs.list()).toArray(new X509Certificate[0]);
            try {
                if (remoteCoreCryptoManager.getCryptoManagerVersion().compareTo((Object)ICoreCryptoManager.ADVANCED_CERT_GEN_VERSION) >= 0) {
                    if (this.getCertAliasAndPassword().getPassword().isDefault()) {
                        keyStore.setKeyEntry(certAlias, (Key)pkey, null, xChain);
                    } else {
                        try (SecretChars certificatePasswordValue = SecretChars.fromString((String)AccessController.doPrivileged(() -> ((BPassword)this.getCertAliasAndPassword().getPassword()).getValue()));){
                            keyStore.setKeyEntry(certAlias, (Key)pkey, certificatePasswordValue.get(), xChain);
                        }
                    }
                } else {
                    keyStore.setKeyEntry(this.getServerCertAlias(), (Key)pkey, null, xChain);
                }
                keyStore.save();
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "ImportSignedCertificate.failed.saveCert", (Throwable)e);
                details.complete(BJobState.failed);
                if (util == null) return;
                if (var6_7 != null) {
                    try {
                        util.close();
                        return;
                    }
                    catch (Throwable throwable6) {
                        var6_7.addSuppressed(throwable6);
                    }
                    return;
                } else {
                    util.close();
                }
                return;
            }
            details.success();
            return;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    protected BPlatCryptoManager getPlatCryptoManager(BDaemonSession session) {
        return new BPlatCryptoManager(session);
    }

    public void started() throws Exception {
        super.started();
        if (!Flags.has((BComplex)this, (Slot)serverCertAlias, (int)0x10000000)) {
            this.getCertAliasAndPassword().setAlias(this.getServerCertAlias());
            Flags.add((BComponent)this, (Slot)serverCertAlias, null, (int[])new int[]{0x10000005});
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        return this.getLexicon().getText("ImportSignedCertificateJobStep.displayName", new Object[]{this.getFileNaming().toString(context), this.getUseFilenameForAlias() ? this.getFileNaming().toString(context) : this.getCertAliasAndPassword().getAlias()});
    }
}

