/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.certificate;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NSigningParameters;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.nre.security.IX509Extension;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="serverCertAlias", type="String", defaultValue="BString.DEFAULT", deprecated=true), @NiagaraProperty(name="serverCertAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="caCertAlias", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="caPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="notBefore", type="BAbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="notAfter", type="BAbsTime", defaultValue="BAbsTime.DEFAULT")})
public class BSignCertJobStep
extends BDeviceJobStep {
    @Deprecated
    @Generated
    public static final Property serverCertAlias = BSignCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property serverCertAliasAndPassword = BSignCertJobStep.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property caCertAlias = BSignCertJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property caPassword = BSignCertJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property notBefore = BSignCertJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property notAfter = BSignCertJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSignCertJobStep.class);
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Deprecated
    @Generated
    public String getServerCertAlias() {
        return this.getString(serverCertAlias);
    }

    @Deprecated
    @Generated
    public void setServerCertAlias(String v) {
        this.setString(serverCertAlias, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getServerCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(serverCertAliasAndPassword);
    }

    @Generated
    public void setServerCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(serverCertAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public String getCaCertAlias() {
        return this.getString(caCertAlias);
    }

    @Generated
    public void setCaCertAlias(String v) {
        this.setString(caCertAlias, v, null);
    }

    @Generated
    public BPassword getCaPassword() {
        return (BPassword)this.get(caPassword);
    }

    @Generated
    public void setCaPassword(BPassword v) {
        this.set(caPassword, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNotBefore() {
        return (BAbsTime)this.get(notBefore);
    }

    @Generated
    public void setNotBefore(BAbsTime v) {
        this.set(notBefore, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNotAfter() {
        return (BAbsTime)this.get(notAfter);
    }

    @Generated
    public void setNotAfter(BAbsTime v) {
        this.set(notAfter, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSignCertJobStep() {
    }

    public BSignCertJobStep(String serverCertAlias, BPassword serverCertPassword, String caCertAlias, BPassword caPassword, BAbsTime notBefore, BAbsTime notAfter) {
        this.setServerCertAlias(serverCertAlias);
        this.getServerCertAliasAndPassword().setAlias(serverCertAlias);
        this.getServerCertAliasAndPassword().setPassword(serverCertPassword);
        this.setCaCertAlias(caCertAlias);
        this.setCaPassword(caPassword);
        this.setNotBefore(notBefore);
        this.setNotAfter(notAfter);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ICoreCryptoManager localCoreCryptoManager;
        try {
            localCoreCryptoManager = (ICoreCryptoManager)AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SignCertJobStep.failed.remoteCcm", (Throwable)e);
            details.complete(BJobState.failed);
            return;
        }
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            IX509Extension[] extensions;
            PrivateKey privateKey;
            NPKCS10CertificationRequest csr;
            BSession session = this.getSession(util);
            ICoreCryptoManager remoteCoreCryptoManager = this.getPlatCryptoManager(session, util);
            String serverCertPassword = null;
            try {
                if (remoteCoreCryptoManager.getCryptoManagerVersion().compareTo((Object)ICoreCryptoManager.ADVANCED_CERT_GEN_VERSION) >= 0) {
                    serverCertPassword = this.getServerCertAliasAndPassword().getPassword() != null && !this.getServerCertAliasAndPassword().getPassword().isDefault() ? AccessController.doPrivileged(() -> ((BPassword)this.getServerCertAliasAndPassword().getPassword()).getValue()) : null;
                    csr = remoteCoreCryptoManager.generateCSR(this.getServerCertAliasAndPassword().getAlias(), serverCertPassword);
                } else {
                    csr = remoteCoreCryptoManager.generateCSR(this.getServerCertAlias(), null);
                }
            }
            catch (Exception e) {
                util.disengageFoxSession();
                details.failed("provisioningNiagara", "SignCertJobStep.failed.csr", (Throwable)e);
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var7_9 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            if (csr == null) {
                util.disengageFoxSession();
                details.failed("provisioningNiagara", "SignCertJobStep.failed.csr");
                details.complete(BJobState.failed);
                return;
            }
            X509Certificate caCertificate = localCoreCryptoManager.getKeyStore().getCertificate(this.getCaCertAlias());
            if (caCertificate == null) {
                details.failed("provisioningNiagara", "SignCertJobStep.failed.ca");
                details.complete(BJobState.failed);
                return;
            }
            try {
                privateKey = (PrivateKey)localCoreCryptoManager.getKeyStore().getKey(this.getCaCertAlias(), AccessController.doPrivileged(() -> ((BPassword)this.getCaPassword()).getValue()).toCharArray());
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "SignCertJobStep.failed.caPassword", (Throwable)e);
                details.complete(BJobState.failed);
                return;
            }
            NX509CertificateEntry ca = NX509CertificateEntry.make(null, (X509Certificate[])new X509Certificate[]{caCertificate}, (PrivateKey)privateKey);
            Date notBeforeDate = new Date(this.getNotBefore().getMillis());
            Date notAfterDate = new Date(this.getNotAfter().getMillis());
            NSigningParameters params = NSigningParameters.make((Date)notBeforeDate, (Date)notAfterDate);
            for (IX509Extension ext : extensions = csr.getExtensions()) {
                params.addExtension(ext);
            }
            NX509Certificate signedCertificate = CertUtils.signCertificate((NPKCS10CertificationRequest)csr, (IX509CertificateEntry)ca, (NSigningParameters)params);
            X509Certificate[] caChain = localCoreCryptoManager.getKeyStore().getCertificateChain(this.getCaCertAlias());
            X509Certificate[] certChain = new X509Certificate[caChain.length + 1];
            certChain[0] = signedCertificate.getCertificate();
            System.arraycopy(caChain, 0, certChain, 1, caChain.length);
            ICoreKeyStore keyStore = remoteCoreCryptoManager.getKeyStore();
            PrivateKey serverPrivateKey = remoteCoreCryptoManager.getCryptoManagerVersion().compareTo((Object)ICoreCryptoManager.ADVANCED_CERT_GEN_VERSION) >= 0 ? (PrivateKey)keyStore.getKey(this.getServerCertAliasAndPassword().getAlias(), serverCertPassword != null ? serverCertPassword.toCharArray() : null) : (PrivateKey)keyStore.getKey(this.getServerCertAlias(), null);
            if (serverPrivateKey == null) {
                details.failed("provisioningNiagara", "SignCertJobStep.failed.remoteCert");
                details.complete(BJobState.failed);
                return;
            }
            if (this.getServerCertAliasAndPassword().getPassword().isDefault()) {
                keyStore.setKeyEntry(this.getServerCertAliasAndPassword().getAlias(), (Key)serverPrivateKey, null, certChain);
            } else {
                keyStore.setKeyEntry(this.getServerCertAliasAndPassword().getAlias(), (Key)serverPrivateKey, serverCertPassword.toCharArray(), certChain);
            }
            keyStore.save();
            util.reset();
            details.message("provisioningNiagara", "SignCertJobStep.signed");
            details.success();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    protected ICoreCryptoManager getPlatCryptoManager(BSession session, ProvisioningConnectionUtil util) throws Exception {
        BPlatCryptoManager ccm;
        boolean stationRunning = util.hasRunningStation();
        if (stationRunning) {
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)session);
            ccm = new ChannelCryptoManager((BComponent)remoteCertService);
        } else {
            ccm = new BPlatCryptoManager((BDaemonSession)session);
        }
        return ccm;
    }

    protected BSession getSession(ProvisioningConnectionUtil util) throws Exception {
        boolean stationRunning = util.hasRunningStation();
        Object session = stationRunning ? util.getEngagedFoxSession() : util.getDaemonSession();
        return session;
    }

    public void started() throws Exception {
        super.started();
        if (!Flags.has((BComplex)this, (Slot)serverCertAlias, (int)0x10000000)) {
            this.getServerCertAliasAndPassword().setAlias(this.getServerCertAlias());
            Flags.add((BComponent)this, (Slot)serverCertAlias, null, (int[])new int[]{0x10000005});
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        String serverCertAlias = this.getServerCertAliasAndPassword().getAlias();
        return this.getLexicon().getText("SignCertJobStep.display", new Object[]{serverCertAlias});
    }
}

