/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.component;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.component.BSetPropertyJobStep;
import java.util.ArrayList;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.search.BSearchService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="target", type="BOrd", defaultValue="BOrd.make(\"station:|slot:/\")"), @NiagaraProperty(name="propertyName", type="String", defaultValue=""), @NiagaraProperty(name="useNeql", type="boolean", defaultValue="false"), @NiagaraProperty(name="neqlPredicate", type="String", defaultValue="")})
public class BRemovePropertyJobStep
extends BDeviceJobStep {
    @Generated
    public static final Property target = BRemovePropertyJobStep.newProperty((int)0, (BValue)BOrd.make((String)"station:|slot:/"), null);
    @Generated
    public static final Property propertyName = BRemovePropertyJobStep.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property useNeql = BRemovePropertyJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property neqlPredicate = BRemovePropertyJobStep.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRemovePropertyJobStep.class);

    @Generated
    public BOrd getTarget() {
        return (BOrd)this.get(target);
    }

    @Generated
    public void setTarget(BOrd v) {
        this.set(target, (BValue)v, null);
    }

    @Generated
    public String getPropertyName() {
        return this.getString(propertyName);
    }

    @Generated
    public void setPropertyName(String v) {
        this.setString(propertyName, v, null);
    }

    @Generated
    public boolean getUseNeql() {
        return this.getBoolean(useNeql);
    }

    @Generated
    public void setUseNeql(boolean v) {
        this.setBoolean(useNeql, v, null);
    }

    @Generated
    public String getNeqlPredicate() {
        return this.getString(neqlPredicate);
    }

    @Generated
    public void setNeqlPredicate(String v) {
        this.setString(neqlPredicate, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BFoxSession foxSession = util.getEngagedFoxSession();
            ArrayList<BComponent> targetList = new ArrayList<BComponent>();
            if (this.getUseNeql()) {
                BSearchService searchService = (BSearchService)foxSession.getService(BSearchService.TYPE);
                if (searchService == null) {
                    details.failed("provisioningNiagara", "SetPropertyJobStep.failed.noSearchService");
                    details.complete(BJobState.failed);
                    return;
                }
                Array<BComponent> neqlResults = BSetPropertyJobStep.findMatchingObjects(this.getNeqlPredicate(), searchService, details);
                if (neqlResults == null || neqlResults.isEmpty()) {
                    details.failed("provisioningNiagara", "SetPropertyJobStep.failed.noSearchResults");
                    details.complete(BJobState.success);
                    return;
                }
                for (BComponent result : neqlResults) {
                    targetList.add(result);
                }
            } else {
                BObject target = this.getTarget().get((BObject)foxSession);
                if (!(target instanceof BComponent)) {
                    details.failed("provisioningNiagara", "RemovePropertyJobStep.failed.notComponent", this.getPropertyName());
                    details.complete(BJobState.failed);
                    return;
                }
                targetList.add(target.asComponent());
            }
            for (BComponent target : targetList) {
                String targetString = this.getTarget().toString();
                target.lease();
                targetString = target.getSlotPath().toDisplayString();
                String escapedName = SlotPath.escape((String)this.getPropertyName());
                Property property = target.getProperty(escapedName);
                if (property == null) continue;
                if (property.isFrozen()) {
                    details.vaFailed("RemovePropertyJobStep.failed.isFrozen", new String[]{this.getPropertyName()});
                    details.complete(BJobState.failed);
                    continue;
                }
                target.remove(property);
                details.vaMessage("RemovePropertyJobStep.propertyRemoved", new String[]{this.getPropertyName(), targetString});
                details.success();
            }
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "RemovePropertyJobStep.failed", this.getPropertyName(), (Throwable)e);
            details.complete(BJobState.failed);
        }
    }

    public String toString(Context cx) {
        String targetType = this.getUseNeql() ? "NEQL" : "ORD";
        String targetString = this.getUseNeql() ? this.getNeqlPredicate() : this.getTarget().toString();
        String propertyNameString = this.getPropertyName();
        return this.getLexicon().getText("RemovePropertyJobStep.display", new Object[]{targetType, targetString, propertyNameString});
    }
}

