/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.license;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperties(value={@NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="licenseStatus", type="BLicenseStatus", defaultValue="BLicenseStatus.unknown", flags=1), @NiagaraProperty(name="licenseSummary", type="BEnvLicenseSummary", defaultValue="new BEnvLicenseSummary()", flags=1), @NiagaraProperty(name="certificateSummaries", type="BVector", defaultValue="new BVector()", flags=1)})
@NiagaraAction(name="poll", flags=16)
public class BLicenseStationExt
extends BProvisioningStationExt {
    @Generated
    public static final Property lastUpdate = BLicenseStationExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property licenseStatus = BLicenseStationExt.newProperty((int)1, (BValue)BLicenseStatus.unknown, null);
    @Generated
    public static final Property licenseSummary = BLicenseStationExt.newProperty((int)1, (BValue)new BEnvLicenseSummary(), null);
    @Generated
    public static final Property certificateSummaries = BLicenseStationExt.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Action poll = BLicenseStationExt.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLicenseStationExt.class);
    private static final BIcon icon = BIcon.std((String)"doc.png");
    private static final Logger LOGGER = Logger.getLogger("provisioningNiagara");

    @Generated
    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    @Generated
    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Generated
    public BLicenseStatus getLicenseStatus() {
        return (BLicenseStatus)this.get(licenseStatus);
    }

    @Generated
    public void setLicenseStatus(BLicenseStatus v) {
        this.set(licenseStatus, (BValue)v, null);
    }

    @Generated
    public BEnvLicenseSummary getLicenseSummary() {
        return (BEnvLicenseSummary)this.get(licenseSummary);
    }

    @Generated
    public void setLicenseSummary(BEnvLicenseSummary v) {
        this.set(licenseSummary, (BValue)v, null);
    }

    @Generated
    public BVector getCertificateSummaries() {
        return (BVector)this.get(certificateSummaries);
    }

    @Generated
    public void setCertificateSummaries(BVector v) {
        this.set(certificateSummaries, (BValue)v, null);
    }

    @Generated
    public void poll() {
        this.invoke(poll, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("LicenseStationExt");
    }

    public void doPoll() throws Exception {
        if (this.isUnoperational()) {
            return;
        }
        try {
            AccessController.doPrivileged(() -> {
                VendorLicense[] lics = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])new BEnvLicenseSummary[]{this.makeLicenseSummary()}, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
                VendorCertificate[] certs = PortalLicenseUtil.getUpdatedCertificates((BCertificateSummary[])this.makeCertificateSummaries(), (CertificateDatabase)CertificateDatabase.LOCAL_INSTANCE);
                if (lics.length == 0 && certs.length == 0) {
                    this.setLicenseStatus(BLicenseStatus.upToDate);
                } else {
                    this.setLicenseStatus(BLicenseStatus.outOfDate);
                }
                return null;
            });
        }
        catch (Exception e) {
            this.setLicenseStatus(BLicenseStatus.unknown);
            this.processException(e);
        }
        finally {
            this.setLastUpdate(BAbsTime.now());
        }
    }

    public List<LicenseInfo> getExistingLicenses() throws Exception {
        if (this.isUnoperational()) {
            throw new BajaRuntimeException("License ext for " + this.getNiagaraStation().getDisplayName(null) + " status is " + this.getStatus());
        }
        BPlatformConnection platformConn = (BPlatformConnection)this.getNiagaraStation().getMixIn(BPlatformConnection.TYPE);
        if (platformConn.isUnoperational()) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " status is " + platformConn.getStatus());
        }
        BDaemonSession daemonSession = platformConn.getDaemonSession();
        if (daemonSession == null) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " is unavailable");
        }
        BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)daemonSession, null, (boolean)false);
        platform.checkSession(null);
        BHostIdStatus hostIdStatus = daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus();
        boolean isNiagaraHomeReadonly = daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
        BDirectory dir = (BDirectory)daemonSession.getFileSpace().findFile(SystemFilePaths.getLicensesDirPath((BIFileSpace)daemonSession.getFileSpace(), (boolean)hostIdStatus.isPerpetual(), (boolean)isNiagaraHomeReadonly));
        if (dir != null) {
            return AccessController.doPrivileged(() -> {
                ArrayList<LicenseInfo> licenses = new ArrayList<LicenseInfo>();
                for (BIFile file : dir.listFiles()) {
                    if (!"license".equals(file.getExtension())) continue;
                    licenses.add(new LicenseInfo(file));
                }
                return licenses;
            });
        }
        return new ArrayList<LicenseInfo>();
    }

    public BEnvLicenseSummary makeLicenseSummary() throws Exception {
        if (this.isUnoperational()) {
            throw new BajaRuntimeException("License ext for " + this.getNiagaraStation().getDisplayName(null) + " status is " + this.getStatus());
        }
        BPlatformConnection platformConn = (BPlatformConnection)this.getNiagaraStation().getMixIn(BPlatformConnection.TYPE);
        if (platformConn.isUnoperational()) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " status is " + platformConn.getStatus());
        }
        BDaemonSession daemonSession = platformConn.getDaemonSession();
        if (daemonSession == null) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " is unavailable");
        }
        BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)daemonSession, null, (boolean)false);
        platform.checkSession(null);
        String brandName = platform.getBrandPart().isNull() ? null : platform.getBrandPart().getPartName();
        BEnvLicenseSummary summary = new BEnvLicenseSummary(platform.getHostId(), brandName);
        BHostIdStatus hostIdStatus = daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus();
        boolean isNiagaraHomeReadonly = daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
        BDirectory dir = (BDirectory)daemonSession.getFileSpace().findFile(SystemFilePaths.getLicensesDirPath((BIFileSpace)daemonSession.getFileSpace(), (boolean)hostIdStatus.isPerpetual(), (boolean)isNiagaraHomeReadonly));
        if (dir != null) {
            AccessController.doPrivileged(() -> {
                for (BIFile file : dir.listFiles()) {
                    if (!"license".equals(file.getExtension())) continue;
                    try {
                        VendorLicense license = VendorLicense.make((BIFile)file);
                        LicenseDatabase.LOCAL_INSTANCE.add(license);
                        summary.updateVendorInfo(license);
                    }
                    catch (Exception e) {
                        LOGGER.severe("Invalid license file - " + file + " for station " + this.getNiagaraStation().getDisplayName(null));
                    }
                }
                return null;
            });
        }
        this.setLicenseSummary(summary);
        return summary;
    }

    public BCertificateSummary[] makeCertificateSummaries() throws Exception {
        if (this.isUnoperational()) {
            throw new BajaRuntimeException("License ext for " + this.getNiagaraStation().getDisplayName(null) + " status is " + this.getStatus());
        }
        BPlatformConnection platformConn = (BPlatformConnection)this.getNiagaraStation().getMixIn(BPlatformConnection.TYPE);
        if (platformConn.isUnoperational()) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " status is " + platformConn.getStatus());
        }
        BDaemonSession daemonSession = platformConn.getDaemonSession();
        if (daemonSession == null) {
            throw new BajaRuntimeException("Platform connection for " + this.getNiagaraStation().getDisplayName(null) + " is unavailable");
        }
        BHostIdStatus hostIdStatus = daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus();
        boolean isNiagaraHomeReadonly = daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
        BDirectory dir = (BDirectory)daemonSession.getFileSpace().findFile(SystemFilePaths.getCertificatesDirPath((BIFileSpace)daemonSession.getFileSpace(), (boolean)hostIdStatus.isPerpetual(), (boolean)isNiagaraHomeReadonly));
        ArrayList<BCertificateSummary> certSummaries = new ArrayList<BCertificateSummary>();
        this.getCertificateSummaries().removeAll();
        if (dir != null) {
            for (BIFile bIFile : dir.listFiles()) {
                if (!"certificate".equals(bIFile.getExtension())) continue;
                try {
                    BCertificateSummary certSummary = BCertificateSummary.make((BIFile)bIFile);
                    certSummaries.add(certSummary);
                    this.getCertificateSummaries().add(SlotPath.escape((String)certSummary.getVendor()), (BValue)certSummary);
                }
                catch (Exception e) {
                    LOGGER.severe("Invalid certificate file - " + bIFile + " for station " + this.getNiagaraStation().getDisplayName(null));
                }
            }
        }
        for (String string : this.getLicenseSummary().getVendors()) {
            String propName = SlotPath.escape((String)string);
            Property p = this.getCertificateSummaries().getProperty(propName);
            if (p != null) continue;
            BCertificateSummary certSummary = BCertificateSummary.makeEmpty((String)string);
            certSummaries.add(certSummary);
            this.getCertificateSummaries().add(propName, (BValue)certSummary);
        }
        return certSummaries.toArray(new BCertificateSummary[0]);
    }

    public void setCertificateSummaries(BCertificateSummary[] summaries) {
        this.getCertificateSummaries().removeAll();
        for (BCertificateSummary summary : summaries) {
            this.getCertificateSummaries().add(SlotPath.escape((String)summary.getVendor()), summary.newCopy());
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

