/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.license;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BrandProps;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.provisioningNiagara.BNiagaraProvisioningChannel;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.baja.batchJob.BValueList;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="allowLicenseServerAccess", type="boolean", defaultValue="true")
@NiagaraAction(name="updateStationLicenseStatus", parameterType="BValueList", defaultValue="BValueList.DEFAULT", flags=4)
public class BSupervisorLicenses
extends BComponent {
    @Generated
    public static final Property allowLicenseServerAccess = BSupervisorLicenses.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action updateStationLicenseStatus = BSupervisorLicenses.newAction((int)4, (BValue)BValueList.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSupervisorLicenses.class);
    private static final BIcon icon = BIcon.std((String)"doc.png");
    private BrandProps brandProps = null;

    @Generated
    public boolean getAllowLicenseServerAccess() {
        return this.getBoolean(allowLicenseServerAccess);
    }

    @Generated
    public void setAllowLicenseServerAccess(boolean v) {
        this.setBoolean(allowLicenseServerAccess, v, null);
    }

    @Generated
    public void updateStationLicenseStatus(BValueList parameter) {
        this.invoke(updateStationLicenseStatus, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getBrandProps().get("license.onlineRequest", true)) {
            this.setFlags((Slot)allowLicenseServerAccess, this.getFlags((Slot)allowLicenseServerAccess) & 0xFFFFFFFE);
        } else {
            this.setFlags((Slot)allowLicenseServerAccess, this.getFlags((Slot)allowLicenseServerAccess) | 1);
            if (this.getAllowLicenseServerAccess()) {
                this.setAllowLicenseServerAccess(false);
            }
        }
    }

    public VendorLicense[] getUpdatedLicenses(BEnvLicenseSummary[] summaries) throws Exception {
        return this.getChannel().getUpdatedLicenses(summaries);
    }

    public BEnvLicenseSummary[] getLicenseSummaries(String[] hostIds) throws Exception {
        return this.getChannel().getLicenseSummaries(hostIds);
    }

    public BCertificateSummary[] getCertificateSummaries() throws Exception {
        return this.getChannel().getCertificateSummaries();
    }

    public void importLicenseFile(BIFile file) throws Exception {
        this.getChannel().importLicenseFile(file);
    }

    public String[] getLicensedHostIds() throws Exception {
        return this.getChannel().getLicensedHostIds();
    }

    public VendorLicense[] getLicenses(String hostId) throws Exception {
        return this.getChannel().getLicenses(hostId);
    }

    public void exportLicenses(OutputStream out) throws Exception {
        this.getChannel().exportLicenses(out);
    }

    public void exportLicenses(String[] hostIds, OutputStream out) throws Exception {
        this.getChannel().exportLicenses(hostIds, out);
    }

    public void remove(VendorLicense license) throws Exception {
        this.getChannel().removeLicense(license);
    }

    public Iterator<VendorLicense> licenseIterator() throws Exception {
        return this.getChannel().licenseIterator();
    }

    public boolean add(VendorLicense license) throws Exception {
        return this.getChannel().addLicense(license);
    }

    public boolean add(VendorCertificate cert) throws Exception {
        return this.getChannel().addCertificate(cert);
    }

    public void doUpdateStationLicenseStatus(BValueList stationNames) throws Exception {
        if (stationNames.size() == 0) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (int ixName = 0; ixName < stationNames.size(); ++ixName) {
            names.add(stationNames.getValue(ixName).toString());
        }
        BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] devices = nn.getDevices();
        HashMap<String, BEnvLicenseSummary> licenseSummaryByHostId = new HashMap<String, BEnvLicenseSummary>();
        HashMap certInfoByHostId = new HashMap();
        HashMap<String, BCertificateSummary> latestCertSummaryByVendor = new HashMap<String, BCertificateSummary>();
        for (BDevice device : devices) {
            BCertificateSummary[] certs;
            BDaemonSession daemonSession;
            BPlatformConnection platformConn;
            BLicenseStationExt ext;
            BNiagaraStation station = (BNiagaraStation)device;
            if (!names.contains(station.getStationName()) || (ext = (BLicenseStationExt)station.getMixIn(BLicenseStationExt.TYPE)).isUnoperational() || (platformConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE)).isUnoperational() || (daemonSession = platformConn.getDaemonSession()) == null) continue;
            ext.setLicenseStatus(BLicenseStatus.unknown);
            ext.setLastUpdate(BAbsTime.now());
            BEnvLicenseSummary licenses = ext.makeLicenseSummary();
            licenseSummaryByHostId.put(licenses.getHostId(), licenses);
            HashMap<String, BCertificateSummary> stationCertSummaryByVendor = new HashMap<String, BCertificateSummary>();
            for (BCertificateSummary cert : certs = ext.makeCertificateSummaries()) {
                String vendor = cert.getVendor();
                stationCertSummaryByVendor.put(vendor, cert);
                BCertificateSummary latest = (BCertificateSummary)latestCertSummaryByVendor.get(vendor);
                if (latest != null && latest.getCertificateGenerated() >= cert.getCertificateGenerated()) continue;
                latestCertSummaryByVendor.put(vendor, cert);
            }
            certInfoByHostId.put(licenses.getHostId(), stationCertSummaryByVendor);
        }
        HashMap licenseUpdateByHostId = new HashMap();
        BEnvLicenseSummary[] licenseSummaries = licenseSummaryByHostId.values().toArray(new BEnvLicenseSummary[0]);
        BCertificateSummary[] certSummaries = latestCertSummaryByVendor.values().toArray(new BCertificateSummary[0]);
        AccessController.doPrivileged(() -> {
            VendorLicense[] updatedLicenses = PortalLicenseUtil.requestLicensesOnline() ? PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])licenseSummaries) : PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])licenseSummaries, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
            for (VendorLicense vendorLicense : updatedLicenses) {
                ArrayList<VendorLicense> hostLicenses;
                String vendor = vendorLicense.getVendor();
                if (!PortalLicenseUtil.requestLicensesOnline()) {
                    LicenseDatabase.LOCAL_INSTANCE.add(vendorLicense);
                }
                if ((hostLicenses = (ArrayList<VendorLicense>)licenseUpdateByHostId.get(vendorLicense.getHostId())) == null) {
                    hostLicenses = new ArrayList<VendorLicense>();
                    licenseUpdateByHostId.put(vendorLicense.getHostId(), hostLicenses);
                }
                hostLicenses.add(vendorLicense);
                Map stationCertSummaryByVendor = (Map)certInfoByHostId.get(vendorLicense.getHostId());
                if (!stationCertSummaryByVendor.containsKey(vendor)) {
                    stationCertSummaryByVendor.put(vendor, BCertificateSummary.makeEmpty((String)vendor));
                }
                if (latestCertSummaryByVendor.containsKey(vendor)) continue;
                latestCertSummaryByVendor.put(vendor, BCertificateSummary.makeEmpty((String)vendor));
            }
            if (PortalLicenseUtil.requestLicensesOnline()) {
                for (VendorLicense vendorLicense : PortalLicenseUtil.getPortalUpdates((BCertificateSummary[])certSummaries)) {
                    CertificateDatabase.LOCAL_INSTANCE.add((VendorCertificate)vendorLicense);
                }
            } else {
                PortalLicenseUtil.getUpdatedCertificates((BCertificateSummary[])certSummaries, (CertificateDatabase)CertificateDatabase.LOCAL_INSTANCE);
            }
            return null;
        });
        for (BDevice device : devices) {
            BDaemonSession daemonSession;
            BPlatformConnection platformConn;
            BLicenseStationExt ext;
            BNiagaraStation station = (BNiagaraStation)device;
            if (!names.contains(station.getStationName()) || (ext = (BLicenseStationExt)station.getMixIn(BLicenseStationExt.TYPE)).isUnoperational() || (platformConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE)).isUnoperational() || (daemonSession = platformConn.getDaemonSession()) == null) continue;
            boolean isTargetNiagara4 = daemonSession.getHostProperties().isNiagara4();
            BEnvLicenseSummary newLicenseSummary = (BEnvLicenseSummary)ext.getLicenseSummary().newCopy();
            List hostLicenses = (List)licenseUpdateByHostId.get(ext.getLicenseSummary().getHostId());
            BLicenseStatus status = BLicenseStatus.upToDate;
            if (hostLicenses != null) {
                for (VendorLicense license : hostLicenses) {
                    if (license.getVersion().major() == 3 && isTargetNiagara4) continue;
                    newLicenseSummary.updateVendorInfo(license);
                    status = BLicenseStatus.outOfDate;
                }
            }
            if (status == BLicenseStatus.upToDate) {
                Map stationCertSummaryByVendor = (Map)certInfoByHostId.get(newLicenseSummary.getHostId());
                status = AccessController.doPrivileged(() -> {
                    for (Object o : stationCertSummaryByVendor.keySet()) {
                        String vendor = (String)o;
                        BCertificateSummary existingSummary = (BCertificateSummary)stationCertSummaryByVendor.get(vendor);
                        VendorCertificate cert = CertificateDatabase.LOCAL_INSTANCE.getCertificate(vendor);
                        if (cert == null || existingSummary.getCertificateGenerated() >= cert.getGenerated()) continue;
                        return BLicenseStatus.outOfDate;
                    }
                    return BLicenseStatus.upToDate;
                });
            }
            ext.setLicenseStatus(status);
            ext.setLastUpdate(BAbsTime.now());
        }
    }

    protected BNiagaraProvisioningChannel getChannel() {
        BFoxSession session = (BFoxSession)this.getSession();
        return (BNiagaraProvisioningChannel)session.getConnection().getChannels().get("niagaraProv", BNiagaraProvisioningChannel.TYPE);
    }

    protected BrandProps getBrandProps() {
        if (this.brandProps == null) {
            this.brandProps = new BrandProps((BFileSpace)BOrd.make((String)"file:").get((BObject)this));
        }
        return this.brandProps;
    }

    public BIcon getIcon() {
        return icon;
    }
}

