/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.provisioningNiagara.software.BInstallableNavNode;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import com.tridium.sys.Nre;
import java.util.ArrayList;
import java.util.Comparator;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="installableName", type="String", defaultValue="", flags=7), @NiagaraProperty(name="installableType", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=7)})
public class BInstallableSummary
extends BComponent {
    @Generated
    public static final Property installableName = BInstallableSummary.newProperty((int)7, (String)"", null);
    @Generated
    public static final Property installableType = BInstallableSummary.newProperty((int)7, (BValue)BTypeSpec.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInstallableSummary.class);

    @Generated
    public String getInstallableName() {
        return this.getString(installableName);
    }

    @Generated
    public void setInstallableName(String v) {
        this.setString(installableName, v, null);
    }

    @Generated
    public BTypeSpec getInstallableType() {
        return (BTypeSpec)this.get(installableType);
    }

    @Generated
    public void setInstallableType(BTypeSpec v) {
        this.set(installableType, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInstallableSummary() {
    }

    public BInstallableSummary(BInstallable inst) {
        this.setInstallableName(inst.getInstallableName());
        this.setInstallableType(inst.getType().getTypeSpec());
        this.addInstallable(inst);
    }

    public void addInstallable(BInstallable inst) {
        if (!inst.getInstallableName().equals(this.getInstallableName())) {
            throw new IllegalArgumentException("Illegal name " + inst.getInstallableName() + " != " + this.getInstallableName());
        }
        if (!inst.getType().getTypeSpec().equals((Object)this.getInstallableType())) {
            throw new IllegalArgumentException("Illegal type " + inst.getType().getTypeSpec() + " != " + this.getInstallableType());
        }
        String versionSlot = SlotPath.escape((String)inst.getVersion().getVendorVersionString());
        BInstallableSpec spec = (BInstallableSpec)this.get(versionSlot);
        if (spec == null) {
            this.add(versionSlot, (BValue)BInstallableSpec.make((BInstallable)inst));
        }
    }

    public BVersion[] getVersions() {
        ArrayList<BVersion> result = new ArrayList<BVersion>();
        SlotCursor c = this.getProperties();
        while (c.next(BInstallableSpec.class)) {
            BInstallableSpec spec = (BInstallableSpec)c.get();
            result.add(spec.getVersion());
        }
        return result.toArray(new BVersion[0]);
    }

    public BInstallableSpec getInstallableSpec(BVersion version) {
        return (BInstallableSpec)this.get(SlotPath.escape((String)version.getVendorVersionString()));
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BSoftwareContainer.TYPE);
    }

    public BIcon getIcon() {
        if (Nre.getLeaseManager() != null) {
            this.lease();
        }
        if (this.getInstallableType() != BTypeSpec.DEFAULT) {
            return this.getInstallableType().getTypeInfo().getIcon(null);
        }
        return this.getInstallableType().getIcon();
    }

    public String toString(Context cx) {
        if (Nre.getLeaseManager() != null) {
            this.lease();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getInstallableName());
        stringBuilder.append(" (");
        if (this.getInstallableType() != BTypeSpec.DEFAULT) {
            stringBuilder.append(this.getInstallableType().getTypeInfo().getDisplayName(cx));
        } else {
            stringBuilder.append(this.getInstallableType().toString(cx));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public BINavNode[] getNavChildren() {
        ArrayList<BInstallableNavNode> result = new ArrayList<BInstallableNavNode>();
        SlotCursor c = this.getProperties();
        while (c.next(BInstallableSpec.class)) {
            result.add(new BInstallableNavNode((BInstallableSpec)c.get()));
        }
        result.sort(Comparator.comparing(n -> n.getInstallableSpec().getVersion()));
        return result.toArray(new BINavNode[0]);
    }
}

