/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.systempassphrase;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="oldPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="newPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="isFips", type="BBoolean", defaultValue="BBoolean.FALSE")})
public class BSetSystemPassphraseJobStep
extends BDeviceJobStep
implements BIPrivilegedDeviceJobStep {
    @Generated
    public static final Property oldPassword = BSetSystemPassphraseJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property newPassword = BSetSystemPassphraseJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property isFips = BSetSystemPassphraseJobStep.newProperty((int)0, (boolean)((BBoolean)BBoolean.FALSE.as(BBoolean.class)).getBoolean(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetSystemPassphraseJobStep.class);
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Generated
    public BPassword getOldPassword() {
        return (BPassword)this.get(oldPassword);
    }

    @Generated
    public void setOldPassword(BPassword v) {
        this.set(oldPassword, (BValue)v, null);
    }

    @Generated
    public BPassword getNewPassword() {
        return (BPassword)this.get(newPassword);
    }

    @Generated
    public void setNewPassword(BPassword v) {
        this.set(newPassword, (BValue)v, null);
    }

    @Generated
    public boolean getIsFips() {
        return this.getBoolean(isFips);
    }

    @Generated
    public void setIsFips(boolean v) {
        this.setBoolean(isFips, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetSystemPassphraseJobStep() {
    }

    public BSetSystemPassphraseJobStep(BPassword oldPassword, BPassword newPassword, boolean isFips) {
        this.setOldPassword(oldPassword);
        this.setNewPassword(newPassword);
        this.setIsFips(isFips);
    }

    public BSetSystemPassphraseJobStep(BPassword oldPassword, BPassword newPassword) {
        this(oldPassword, newPassword, false);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BDaemonSession daemonSession = util.getDaemonSession();
            XElem systemPasswordInfo = util.getDaemonResponse((DaemonMessage)new SystemPasswordMessage());
            if (systemPasswordInfo.getb("readonly", false)) {
                details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.readonlyPassword");
                details.complete(BJobState.failed);
                return;
            }
            BPassword oldPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getOldPassword()).getValue()));
            BPassword newPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()));
            BPasswordStrength passwordStrength = FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(this.getIsFips(), daemonSession);
            try {
                passwordStrength.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()));
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.weakPassword");
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var6_7 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            try {
                util.sendDaemonMessage((DaemonMessage)new SystemPasswordMessage(null, oldPassword, true, util.generateDaemonSessionSharedSecretKey("setsystempassphrase")));
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.currentMismatch");
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var6_7 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            try {
                util.sendDaemonMessage((DaemonMessage)new SystemPasswordMessage(newPassword, null, true, util.generateDaemonSessionSharedSecretKey("setsystempassphrase")));
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.defaultPassphrase");
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var6_7 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            try {
                util.sendDaemonMessage((DaemonMessage)new SystemPasswordMessage(newPassword, oldPassword, false, util.generateDaemonSessionSharedSecretKey("setsystempassphrase")));
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "SetSystemPassphraseJobStep.error", (Throwable)e);
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var6_7 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            FipsOptionsHelper.getInstance().updateSystemPassphraseCookie(daemonSession.getHostProperties().isFips() || this.getIsFips(), daemonSession);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

