/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.template;

import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.template.ProvisioningBulkDeployUtil;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.UpgradeUtil;
import com.tridium.template.ui.BulkDeployUtil;
import java.security.AccessController;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="excelFileOrd", type="BOrd", defaultValue="BOrd.DEFAULT"), @NiagaraProperty(name="isPasswordProtected", type="boolean", defaultValue="false"), @NiagaraProperty(name="encodingPassword", type="BPassword", defaultValue="BPassword.DEFAULT")})
public class BUpdateConfigurationStep
extends BDeviceJobStep {
    @Generated
    public static final Property excelFileOrd = BUpdateConfigurationStep.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Property isPasswordProtected = BUpdateConfigurationStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property encodingPassword = BUpdateConfigurationStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUpdateConfigurationStep.class);
    Level LOG_LEVEL = Level.FINE;
    private static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final BIcon icon = BIcon.std((String)"files/ntpl.png");
    private static final Logger log = Logger.getLogger("provisioningNiagara");
    private static final int DEPTH_FROM_STATION_TO_APPLICATION_SERVICE_TEMPLATE_CONFIG = 4;
    private static final int DEPTH_FROM_TEMPLATE_TO_PARENT = 1;
    private static final Level IMPORT_LOG_LEVEL = Level.FINE;

    @Generated
    public BOrd getExcelFileOrd() {
        return (BOrd)this.get(excelFileOrd);
    }

    @Generated
    public void setExcelFileOrd(BOrd v) {
        this.set(excelFileOrd, (BValue)v, null);
    }

    @Generated
    public boolean getIsPasswordProtected() {
        return this.getBoolean(isPasswordProtected);
    }

    @Generated
    public void setIsPasswordProtected(boolean v) {
        this.setBoolean(isPasswordProtected, v, null);
    }

    @Generated
    public BPassword getEncodingPassword() {
        return (BPassword)this.get(encodingPassword);
    }

    @Generated
    public void setEncodingPassword(BPassword v) {
        this.set(encodingPassword, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUpdateConfigurationStep() {
    }

    public BUpdateConfigurationStep(BIFile srcFile) {
        this.setExcelFileOrd(srcFile.getOrdInSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ProvisioningBulkDeployUtil bulkDeploy;
        List<BulkDeployUtil.DeployedWorksheet> deployedWorksheets;
        BNiagaraStation station = (BNiagaraStation)device;
        this.checkCanceled((BDevice)station);
        BIFile excelFile = (BIFile)this.getExcelFileOrd().resolve().get();
        if (excelFile == null || !excelFile.getExtension().equalsIgnoreCase("xlsx") && !excelFile.getExtension().equalsIgnoreCase("xls")) {
            details.failed("provisioningNiagara", "DeployTemplateStep.excelFileError", new String[]{excelFile != null ? excelFile.getFileName() : "(null)"});
            details.complete(BJobState.failed);
            return;
        }
        BFileSpace templateSpace = excelFile.getFileSpace();
        if (templateSpace == null) {
            details.failed("provisioningNiagara", "DeployTemplateStep.fileSpaceError", new String[]{excelFile.getFileName()});
            details.complete(BJobState.failed);
            return;
        }
        FilePath templatePath = excelFile.getFilePath();
        if (log.isLoggable(this.LOG_LEVEL)) {
            log.log(this.LOG_LEVEL, "Excel file path: " + templatePath.toString());
        }
        if ((deployedWorksheets = (bulkDeploy = new ProvisioningBulkDeployUtil()).loadExcelFileWorksheets(excelFile, this.getSpreadsheetPassword(details), details)) == null || deployedWorksheets.isEmpty()) {
            details.failed("template", "bulkDeploy.excelImport.importFileError", new String[]{excelFile.getFileName()});
            details.complete(BJobState.failed);
            return;
        }
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        int configAttempts = 0;
        int configSuccesses = 0;
        try {
            HashMap<BComponent, BNameMap> displayNames = new HashMap<BComponent, BNameMap>();
            for (BulkDeployUtil.DeployedWorksheet deployedWorksheet : deployedWorksheets) {
                for (BulkDeployUtil.DeployedRoot deployedRoot : deployedWorksheet.deployedRoots) {
                    if (!this.isDeviceTargetValid(deployedRoot, station)) continue;
                    ++configAttempts;
                    BComponent deployedTemplateComponent = this.findTemplateInstance(deployedWorksheet, deployedRoot, util);
                    if (deployedTemplateComponent == null) {
                        details.message("provisioningNiagara", "UpdateConfigurationStep.matchingComponentNotFound", new String[]{station.getStationName(), deployedRoot.getParentComponentSlotPath(), deployedRoot.getDeployName()});
                        continue;
                    }
                    if (!(deployedTemplateComponent instanceof BStation)) {
                        UpgradeUtil.deleteTemplateInputLinks((BComponent)deployedTemplateComponent, (List)deployedWorksheet.inputDefs);
                        UpgradeUtil.deleteTemplateOutputLinks((BComponent)deployedTemplateComponent, (List)deployedWorksheet.outputDefs);
                        UpgradeUtil.deleteTemplateInputRelations((BComponent)deployedTemplateComponent, (List)deployedWorksheet.relationDefs);
                        UpgradeUtil.deleteTemplateOutputRelations((BComponent)deployedTemplateComponent, (List)deployedWorksheet.relationDefs);
                    }
                    details.message("provisioningNiagara", "UpdateConfigurationStep.configuringTemplateComponentDetails", new String[]{station.getStationName(), deployedRoot.getParentComponentSlotPath(), deployedRoot.getDeployName()});
                    deployedRoot.setDeployedTemplate(deployedTemplateComponent);
                    List deployResponses = bulkDeploy.updateConfigurations(deployedWorksheet, deployedRoot);
                    if (!deployResponses.isEmpty()) {
                        for (String response : deployResponses) {
                            details.message(response);
                        }
                    }
                    if (!(deployedTemplateComponent instanceof BStation)) {
                        BulkDeployUtil.setComponentPosition((BComponent)deployedTemplateComponent, (String)deployedRoot.getPosition());
                        HashMap<String, BFormat> componentDisplayNames = new HashMap<String, BFormat>();
                        BComponent deployedRootComponent = this.resolveDeployComponent(deployedWorksheet, deployedRoot, util);
                        if (deployedRoot.getDisplayName() != null && !deployedRoot.getDisplayName().isEmpty()) {
                            String escapedName = SlotPath.escape((String)deployedRoot.getDeployName());
                            try {
                                componentDisplayNames.put(deployedRootComponent.getProperty(escapedName).getName(), BFormat.make((String)deployedRoot.getDisplayName()));
                            }
                            catch (Exception e) {
                                details.message("provisioningNiagara", "UpdateConfigurationStep.displayNameError", new String[]{deployedRoot.getDisplayName(), station.getStationName(), deployedRoot.getParentComponentSlotPath(), deployedRoot.getDeployName()});
                            }
                        }
                        if (!componentDisplayNames.isEmpty()) {
                            BNameMap nameMap = BNameMap.make(componentDisplayNames);
                            if (displayNames.containsKey(deployedRootComponent)) {
                                BNameMap mergedNameMap = BNameMap.make((BNameMap)((BNameMap)displayNames.get(deployedRootComponent)), (BNameMap)nameMap);
                                displayNames.put(deployedRootComponent, mergedNameMap);
                            } else {
                                displayNames.put(deployedRootComponent, nameMap);
                            }
                        }
                    }
                    ++configSuccesses;
                }
            }
            if (!displayNames.isEmpty()) {
                displayNames.forEach((key, value) -> {
                    details.message("provisioningNiagara", "UpdateConfigurationStep.updatingDisplayName", new String[]{value.encodeToString(), key.toString()});
                    bulkDeploy.updateTemplateDisplayNames((BComponent)key, (BNameMap)value);
                });
            }
        }
        catch (Exception e) {
            details.message("provisioningNiagara", "UpdateConfigurationStep.exceptionDeploysFailed", new String[]{station.getStationName(), e.getLocalizedMessage()});
        }
        finally {
            util.disengageFoxSession();
        }
        if (configAttempts > 0 && configSuccesses == 0) {
            details.failed((Throwable)new LocalizableRuntimeException("provisioningNiagara", "UpdateConfigurationStep.allDeploysFailed"));
        } else {
            details.success();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public String toString(Context cx) {
        return lex.getText("UpdateConfigurationFactory.display", new Object[]{this.getExcelFileOrd().encodeToString()});
    }

    private boolean isDeviceTargetValid(BulkDeployUtil.DeployedRoot deployedRoot, BNiagaraStation station) {
        String stationName = station.getStationName();
        if (log.isLoggable(this.LOG_LEVEL)) {
            log.log(this.LOG_LEVEL, "Station name: " + stationName);
        }
        if (deployedRoot.getDeviceTarget() == null || deployedRoot.getDeviceTarget().isEmpty()) {
            return true;
        }
        if (log.isLoggable(this.LOG_LEVEL)) {
            log.log(this.LOG_LEVEL, "Unique device: " + deployedRoot.getDeviceTarget());
        }
        if (deployedRoot.getDeviceTarget().contains(stationName)) {
            return true;
        }
        String deployDeviceTarget = "";
        try {
            BOrd addressOrd = station.getAddress();
            OrdQuery[] addressQuery = addressOrd.parse();
            deployDeviceTarget = addressQuery[0].getBody();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (log.isLoggable(this.LOG_LEVEL)) {
            log.log(this.LOG_LEVEL, "Host name: " + deployDeviceTarget);
        }
        return deployedRoot.getDeviceTarget().contains(deployDeviceTarget);
    }

    protected String getSpreadsheetPassword(BDeviceStepDetails details) {
        if (this.getIsPasswordProtected()) {
            try {
                return AccessController.doPrivileged(() -> ((BPassword)this.getEncodingPassword()).getValue());
            }
            catch (SecurityException e) {
                details.message("template", "bulkDeploy.excelImport.encryptionPassword.warning", new String[]{this.getExcelFileOrd().encodeToString()});
                return null;
            }
        }
        return null;
    }

    private BComponent findTemplateInstance(BulkDeployUtil.DeployedWorksheet deployedWorksheet, BulkDeployUtil.DeployedRoot deployedRoot, ProvisioningConnectionUtil util) throws Exception {
        BComponent deployedTemplateComponent = null;
        BComponent deployedRootComponent = this.resolveDeployComponent(deployedWorksheet, deployedRoot, util);
        if (deployedRootComponent instanceof BStation && "Application".contentEquals(deployedWorksheet.templateType)) {
            deployedTemplateComponent = deployedRootComponent;
        } else if (deployedRootComponent != null) {
            deployedRootComponent.lease(1);
            String escapedName = SlotPath.escape((String)deployedRoot.getDeployName());
            try {
                deployedTemplateComponent = deployedRootComponent.get(escapedName).asComponent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (deployedTemplateComponent == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateNotResolvedError", new Object[]{deployedRoot.getDeployName(), deployedWorksheet.title}));
        } else {
            deployedTemplateComponent.lease(4);
            BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)deployedTemplateComponent);
            if (templateConfig == null) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.invalidTemplateError", new Object[]{deployedTemplateComponent.getName()}));
                deployedTemplateComponent = null;
            } else if (!Objects.equals(templateConfig.getUID(), deployedWorksheet.uid)) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.invalidTemplateId", new Object[]{deployedTemplateComponent.getName()}));
                deployedTemplateComponent = null;
            }
        }
        return deployedTemplateComponent;
    }

    protected BComponent resolveDeployComponent(BulkDeployUtil.DeployedWorksheet deployedWorksheet, BulkDeployUtil.DeployedRoot deployedRoot, ProvisioningConnectionUtil util) throws Exception {
        BStation deployedRootComponent = null;
        BStation station = (BStation)BOrd.make((BOrd)util.getEngagedFoxSession().getAbsoluteOrd(), (String)"station:|slot:/").get();
        switch (deployedWorksheet.templateType) {
            case "Application": {
                deployedRootComponent = station;
                break;
            }
            default: {
                BOrd deployRootOrd = BOrd.make((String)(station.getSlotPathOrd() + deployedRoot.getParentComponentSlotPath()));
                if (log.isLoggable(IMPORT_LOG_LEVEL)) {
                    log.log(IMPORT_LOG_LEVEL, "deployRootOrd = " + deployRootOrd);
                }
                try {
                    deployedRootComponent = deployRootOrd.resolve((BObject)station).getComponent();
                    break;
                }
                catch (UnresolvedException unresolvedException) {
                    // empty catch block
                }
            }
        }
        if (deployedRootComponent == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.rootNotResolvedError", new Object[]{deployedRoot.getDeployName(), deployedWorksheet.title}));
        }
        return deployedRootComponent;
    }
}

