/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.template;

import com.tridium.install.BVersion;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.template.BTemplateStationExt;
import com.tridium.provisioningNiagara.template.ProvisionTemplateManager;
import com.tridium.provisioningNiagara.template.ProvisioningBulkDeployUtil;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.TemplateManager;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="templateFileOrd", type="BOrd", defaultValue="BOrd.DEFAULT")
public class BUpgradeTemplateStep
extends BDeviceJobStep {
    @Generated
    public static final Property templateFileOrd = BUpgradeTemplateStep.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUpgradeTemplateStep.class);
    Level PROVISION_LOG_LEVEL = Level.FINE;
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final BIcon icon = BIcon.std((String)"files/ntpl.png");
    public static final Logger log = Logger.getLogger("provisioningNiagara");

    @Generated
    public BOrd getTemplateFileOrd() {
        return (BOrd)this.get(templateFileOrd);
    }

    @Generated
    public void setTemplateFileOrd(BOrd v) {
        this.set(templateFileOrd, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUpgradeTemplateStep() {
    }

    public BUpgradeTemplateStep(BIFile srcFile) {
        this.setTemplateFileOrd(srcFile.getOrdInSession());
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp opIn) throws Exception {
        BNiagaraStation station = (BNiagaraStation)device;
        this.checkCanceled((BDevice)station);
        ProvisionTemplateManager tmInstance = new ProvisionTemplateManager();
        if (this.getTemplateFileOrd() == null || this.getTemplateFileOrd() == BOrd.DEFAULT) {
            details.failed("provisioningNiagara", "UpgradeTemplateStep.templateOrdNull");
            details.complete(BJobState.failed);
            return;
        }
        log.log(this.PROVISION_LOG_LEVEL, "Locate template file at " + this.getTemplateFileOrd().encodeToString());
        BObject templateObject = this.getTemplateFileOrd().resolve().get();
        if (templateObject == null) {
            details.failed("provisioningNiagara", "UpgradeTemplateStep.templateOrdError", new String[]{this.getTemplateFileOrd().encodeToString()});
            details.complete(BJobState.failed);
            return;
        }
        if (!(templateObject instanceof BNtplFile)) {
            details.failed("provisioningNiagara", "UpgradeTemplateStep.templateFileError", new String[]{this.getTemplateFileOrd().encodeToString()});
            details.complete(BJobState.failed);
            return;
        }
        BNtplFile templateFile = (BNtplFile)templateObject;
        TemplateManager.TemplateInfo cachedTemplateInfo = tmInstance.getTemplate(templateFile.getTitle(), templateFile.getVendor());
        log.log(this.PROVISION_LOG_LEVEL, "Template file version " + templateFile.getVersion() + " and vendor " + templateFile.getVendor());
        if (cachedTemplateInfo == null) {
            details.failed("provisioningNiagara", "UpgradeTemplateStep.templateInfoError", new String[]{templateFile.getTitle()});
            details.complete(BJobState.failed);
            return;
        }
        String cachedTemplateName = cachedTemplateInfo.getName();
        String cachedTemplateVersion = cachedTemplateInfo.getVersion();
        BUuid cachedTemplateUuid = cachedTemplateInfo.getUid();
        BOrd cachedTemplateOrd = cachedTemplateInfo.getNtpFileOrd();
        BTemplateStationExt templateExt = (BTemplateStationExt)station.getMixIn(BTemplateStationExt.TYPE);
        BVector compareResult = templateExt.compare(cachedTemplateOrd);
        if (compareResult == null || compareResult.getPropertiesArray().length <= 0) {
            details.failed("provisioningNiagara", "UpgradeTemplateStep.templateVersionError", new String[]{templateFile.getTitle(), cachedTemplateVersion});
            details.complete(BJobState.failed);
            return;
        }
        Property[] propertiesArray = compareResult.getPropertiesArray();
        ProvisioningBulkDeployUtil bulkDeployUtil = new ProvisioningBulkDeployUtil();
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            for (int i = 0; i < propertiesArray.length; ++i) {
                Property property = propertiesArray[i];
                String slotPath = property.getName();
                BValue bValue = compareResult.get(property);
                if (!(bValue instanceof BVersion)) continue;
                details.message("provisioningNiagara", "UpgradeTemplateStep.upgradeInitiateDetails", new String[]{templateFile.getTitle(), SlotPath.unescape((String)slotPath)});
                bulkDeployUtil.upgradeTemplateInstance(cachedTemplateInfo, SlotPath.unescape((String)slotPath), util, opIn, details);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
        details.success();
    }

    public BIcon getIcon() {
        return icon;
    }

    public String toString(Context cx) {
        return lex.getText("UpgradeTemplateFactory.display", new Object[]{this.getTemplateFileOrd().encodeToString()});
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

