/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.bootstrap;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.provisioningNiagara.bootstrap.BSetupReciprocalConnectionStep;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.baja.batchJob.BJobStep;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BSetupReciprocalConnectionStepDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BSetupReciprocalConnectionStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BSetupReciprocalConnectionStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetupReciprocalConnectionStepDialog.class);
    public static Logger log = Logger.getLogger("provisioningNiagara");
    private BJobStep result;
    private BButton okButton;
    private BButton cancelButton;
    private BTextField username = new BTextField();
    private BPasswordFE password = new BPasswordFE();
    private BTextField address = new BTextField();

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetupReciprocalConnectionStepDialog(BWidget owner) throws Exception {
        super(owner, "", true);
        this.setTitle(this.lexValue("title", new Object[0]));
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BJobStep show(BWidget owner) throws Exception {
        return BSetupReciprocalConnectionStepDialog.show(owner, null, null);
    }

    public static BJobStep show(BWidget owner, BObject step, Context context) throws Exception {
        BSetupReciprocalConnectionStepDialog dialog = new BSetupReciprocalConnectionStepDialog(owner);
        if (step != null) {
            BSetupReciprocalConnectionStep jobStep = (BSetupReciprocalConnectionStep)step;
            dialog.username.setText(jobStep.getUsername());
            dialog.password.loadValue((BObject)jobStep.getPassword(), context);
            if (jobStep.getAddress() != BOrd.NULL) {
                dialog.address.setText(jobStep.getAddress().encodeToString().substring(3));
            }
        }
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() throws Exception {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setCenter(this.buildContent());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(null, this.lexValue("title", new Object[0]), this.lexValue("description", new Object[0]));
    }

    private BWidget buildContent() throws Exception {
        BGridPane contentGrid = new BGridPane(3);
        this.addField(contentGrid, "username", (BValue)this.username, true);
        this.addField(contentGrid, "password", (BValue)this.password, true);
        this.addField(contentGrid, "address", (BValue)this.address, false);
        BBorderPane contentBorderPane = new BBorderPane((BWidget)contentGrid);
        return new BEdgePane(null, (BWidget)contentBorderPane, null, null, (BWidget)new BLabel(this.lexValue("topText", new Object[0])));
    }

    private void addField(BGridPane grid, String labelLexKey, BValue field, boolean required) {
        grid.add(null, (BValue)new BLabel(this.lexValue(labelLexKey, new Object[0])));
        grid.add(null, field);
        if (required) {
            grid.add(null, (BValue)new BLabel("(" + this.lexValue("required", new Object[0]) + ")"));
        } else {
            grid.add(null, (BValue)new BLabel(""));
        }
    }

    private BWidget buildButtonPane() throws Exception {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.okButton.setEnabled(true);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, 7.0, 7.0, 7.0, 7.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        block7: {
            block6: {
                if (this.username.getText().isEmpty()) {
                    BDialog.error((BWidget)this, (Object)this.lexValue("noUsername", new Object[0]));
                    return;
                }
                BPassword p1 = (BPassword)this.password.saveValue();
                if (p1 == null) break block6;
                if (AccessController.doPrivileged(() -> ((BPassword)p1).getValue()).trim().length() != 0) break block7;
            }
            BDialog.error((BWidget)this, (Object)this.lexValue("noPassword", new Object[0]));
            return;
        }
        BOrd addressOrd = BOrd.NULL;
        String addressStr = this.address.getText().trim();
        if (!addressStr.isEmpty()) {
            if (!IPAddressUtil.isValidHostFormat((String)addressStr)) {
                BDialog.error((BWidget)this, (Object)this.lexValue("invalidAddress", new Object[0]));
                return;
            }
            addressOrd = BOrd.make((String)("ip:" + this.address.getText()));
        }
        this.result = new BSetupReciprocalConnectionStep(this.username.getText(), (BPassword)this.password.saveValue(), addressOrd);
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    public BJobStep getResult() {
        return this.result;
    }

    protected String lexKey(String keySuffix) {
        return this.getType().getTypeName() + "." + keySuffix;
    }

    protected String lexValue(String keySuffix, Object ... parameters) {
        return this.getLexicon().getText(this.lexKey(keySuffix), parameters);
    }
}

