/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.certificate;

import com.tridium.platcrypto.ui.BPrivateKeyPasswordDialog;
import com.tridium.provisioningNiagara.certificate.BImportSignedCertificateJobStep;
import com.tridium.provisioningNiagara.ui.certificate.BFileNameFormat;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="checkBoxClicked"), @NiagaraAction(name="useFilenameForAliasCheckBoxClicked")})
public class BImportSignedCertificateDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BImportSignedCertificateDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BImportSignedCertificateDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action checkBoxClicked = BImportSignedCertificateDialog.newAction((int)0, null);
    @Generated
    public static final Action useFilenameForAliasCheckBoxClicked = BImportSignedCertificateDialog.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BImportSignedCertificateDialog.class);
    private static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private final BInsets insets = BInsets.make((double)7.0);
    private BFrozenEnumFE fileNaming;
    private BTextField certAlias;
    private BCheckBox useFilenameForAlias;
    private BCheckBox importPrivateKey;
    private BPasswordFE password;
    private BButton okButton;
    private BButton cancelButton;
    private BImportSignedCertificateJobStep result;
    private boolean showErrorDialogs = true;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void checkBoxClicked() {
        this.invoke(checkBoxClicked, null, null);
    }

    @Generated
    public void useFilenameForAliasCheckBoxClicked() {
        this.invoke(useFilenameForAliasCheckBoxClicked, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BImportSignedCertificateDialog() {
        this.showErrorDialogs = false;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public BImportSignedCertificateDialog(BWidget owner) {
        super(owner, lex.getText("ImportSignedCertificateFactory.displayName"), true);
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BImportSignedCertificateJobStep show(BWidget owner) {
        return BImportSignedCertificateDialog.show(owner, null, null);
    }

    public static BImportSignedCertificateJobStep show(BWidget owner, BObject step, Context context) {
        BImportSignedCertificateDialog dialog = new BImportSignedCertificateDialog(owner);
        if (step != null) {
            BImportSignedCertificateJobStep oldStep = (BImportSignedCertificateJobStep)step;
            dialog.fileNaming.loadValue((BObject)oldStep.getFileNaming());
            dialog.certAlias.setText(oldStep.getCertAliasAndPassword().getAlias());
            dialog.useFilenameForAlias.setSelected(oldStep.getUseFilenameForAlias());
            if (!oldStep.getPassword().isDefault()) {
                dialog.importPrivateKey.setSelected(true);
                dialog.password.setReadonly(false);
                dialog.password.loadValue((BObject)oldStep.getPassword(), context);
            }
        }
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() {
        BEdgePane pane = new BEdgePane();
        pane.setTop(BImportSignedCertificateDialog.buildHeader());
        pane.setCenter(this.buildBody());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private static BWidget buildHeader() {
        return new BWizardHeader(null, lex.getText("ImportSignedCertificateFactory.displayName"), lex.get("ImportSignedCertificateFactory.description"));
    }

    private BWidget buildBody() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        this.fileNaming = new BFrozenEnumFE();
        this.fileNaming.loadValue((BObject)BFileNameFormat.DEFAULT);
        this.useFilenameForAlias = new BCheckBox(lex.get("ImportSignedCertificate.useFilenameForAlias"));
        this.useFilenameForAlias.setSelected(false);
        this.linkTo("linkD", (BComponent)this.useFilenameForAlias, (Slot)BAbstractButton.actionPerformed, (Slot)useFilenameForAliasCheckBoxClicked);
        this.certAlias = new BTextField("", 40, true);
        this.importPrivateKey = new BCheckBox(lex.get("ImportSignedCertificate.privateKeyEncrypted"));
        this.importPrivateKey.setSelected(false);
        this.linkTo("linkC", (BComponent)this.importPrivateKey, (Slot)BAbstractButton.actionPerformed, (Slot)checkBoxClicked);
        this.password = new BPasswordFE();
        this.password.setReadonly(true);
        BGridPane contentGrid = new BGridPane(2);
        contentGrid.setRowGap(5.0);
        contentGrid.setColumnGap(5.0);
        contentGrid.setColumnAlign(BHalign.left);
        contentGrid.setStretchColumn(1);
        contentGrid.add(null, (BValue)new BLabel(lex.getText("ImportSignedCertificateDialog.fileNaming")));
        contentGrid.add(null, (BValue)this.fileNaming);
        contentGrid.add(null, (BValue)this.useFilenameForAlias);
        contentGrid.add(null, (BValue)new BNullWidget());
        contentGrid.add(null, (BValue)new BLabel(lex.getText("Provisioning.certificateAlias")));
        contentGrid.add(null, (BValue)this.certAlias);
        contentGrid.add(null, (BValue)this.importPrivateKey);
        contentGrid.add(null, (BValue)new BNullWidget());
        contentGrid.add(null, (BValue)new BLabel(lex.get("SetupReciprocalConnectionStepDialog.password")));
        contentGrid.add(null, (BValue)this.password);
        contentPane.add(null, (BValue)contentGrid);
        return new BBorderPane((BWidget)contentPane, this.insets);
    }

    private BWidget buildButtonPane() {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.okButton.setEnabled(true);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BAbstractButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BAbstractButton.actionPerformed, (Slot)cancelButtonPressed);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, this.insets);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        BPassword passwordValue;
        block6: {
            block7: {
                if (!this.useFilenameForAlias.getSelected() && this.certAlias.getText().length() == 0) {
                    if (this.showErrorDialogs) {
                        BDialog.error((BWidget)this, (Object)lex.getText("Provisioning.missingAlias"));
                    }
                    return;
                }
                passwordValue = (BPassword)this.password.saveValue();
                if (!this.importPrivateKey.getSelected()) break block6;
                if (passwordValue == null) break block7;
                if (AccessController.doPrivileged(() -> ((BPassword)passwordValue).getValue()).trim().length() != 0) break block6;
            }
            if (this.showErrorDialogs) {
                BDialog.error((BWidget)this, (Object)lex.getText("SignCertDialog.noPassword"));
            }
            return;
        }
        BPassword certPass = BPrivateKeyPasswordDialog.open((BWidget)this, (String)Lexicon.make((String)"platCrypto").get("cert.import.encryptKey.dialog.title"), (String)Lexicon.make((String)"platCrypto").get("cert.import.encryptKey.dialog.info"), (boolean)false);
        this.result = new BImportSignedCertificateJobStep((BFileNameFormat)this.fileNaming.saveValue(), this.useFilenameForAlias.getSelected(), this.certAlias.getText(), (BPassword)(this.importPrivateKey.getSelected() ? passwordValue : null), certPass);
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    public void doCheckBoxClicked() {
        this.password.setReadonly(!this.importPrivateKey.getSelected());
    }

    public void doUseFilenameForAliasCheckBoxClicked() {
        this.certAlias.setEditable(!this.useFilenameForAlias.getSelected());
    }

    public BImportSignedCertificateJobStep getResult() {
        return this.result;
    }
}

