/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.component;

import com.tridium.workbench.fieldeditors.BTypeSpecFE;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BFilteredTypeSpecFE
extends BTypeSpecFE {
    @Generated
    public static final Type TYPE = Sys.loadType(BFilteredTypeSpecFE.class);
    private final List<Filter> filters = new ArrayList<Filter>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFilteredTypeSpecFE() {
        String[] modules = this.getModules();
        for (int i = 0; i < modules.length; ++i) {
            this.mbox.getList().addItem((Object)modules[i]);
        }
        this.pane = new BGridPane(3);
        this.pane.setHalign(BHalign.left);
        this.pane.add("mbox", (BValue)this.mbox);
        this.pane.add("tbox", (BValue)this.tbox);
        this.pane.add("history", (BValue)this.history);
        this.setContent((BWidget)this.pane);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BTypeSpec typeSpec = (BTypeSpec)value;
        String defModule = typeSpec.getModuleName();
        String defType = typeSpec.getTypeName();
        if (defModule == null) {
            defModule = "baja";
            defType = "String";
        }
        this.mbox.getList().removeAllItems();
        Arrays.stream(this.getModules()).forEach(arg_0 -> ((BList)this.mbox.getList()).addItem(arg_0));
        this.mbox.getList().setSelectedItem((Object)defModule);
        if (this.mbox.getList().getSelectedIndex() == -1) {
            this.mbox.getList().setSelectedIndex(0);
        }
        this.loadTypes(defModule);
        this.tbox.getList().setSelectedItem((Object)defType);
        String checkSelected = (String)this.tbox.getSelectedItem();
        if (typeSpec.getTypeName() != null && !typeSpec.getTypeName().equals(checkSelected)) {
            value = null;
            this.doSetModified();
        }
        if (this.tbox.getList().getItemCount() > 0 && this.tbox.getList().getSelectedIndex() == -1) {
            this.tbox.getList().setSelectedIndex(0);
            defType = (String)this.tbox.getList().getSelectedItem();
        }
        this.tbox.setEnabled(this.tbox.getSelectedIndex() > -1);
        if (this.getParent() != null) {
            this.repaint();
        }
    }

    public void doMboxChanged() {
        String moduleName = (String)this.mbox.getSelectedItem();
        this.loadTypes(moduleName);
        this.tbox.setEnabled(this.tbox.getSelectedIndex() > -1);
    }

    protected String[] getTypes(String moduleName) {
        TreeSet<String> v = new TreeSet<String>();
        for (ModuleInfo mi : Sys.getRegistry().getModules(moduleName)) {
            for (TypeInfo type : mi.getTypes()) {
                if (type.isAbstract() || type.isInterface()) continue;
                boolean accept = true;
                for (Filter filter : this.filters) {
                    if (filter.accept(type)) continue;
                    accept = false;
                    break;
                }
                if (!accept) continue;
                v.add(type.getTypeName());
            }
        }
        return v.toArray(new String[0]);
    }

    protected boolean getShowInterface() {
        return false;
    }

    protected boolean getShowAbstract() {
        return false;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public static class CanBeEditedFilter
    extends Filter {
        @Override
        public boolean accept(TypeInfo type) {
            try {
                AgentList agents = Sys.getRegistry().getAgents(type).filter(AgentFilter.is((Type)BWbFieldEditor.TYPE));
                if (agents.size() < 1) {
                    return false;
                }
                Type resolvedType = type.getTypeSpec().getResolvedType();
                if (resolvedType.is(BSimple.TYPE)) {
                    Class clazz = resolvedType.getTypeClass();
                    Field field = clazz.getField("DEFAULT");
                    int mods = field.getModifiers();
                    return Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods);
                }
                Constructor constructor = resolvedType.getTypeClass().getDeclaredConstructor(new Class[0]);
                return Modifier.isPublic(constructor.getModifiers());
            }
            catch (Exception | IllegalAccessError ex) {
                return false;
            }
        }
    }

    public static abstract class Filter {
        public abstract boolean accept(TypeInfo var1);
    }
}

