/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BInstallableSummary;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import com.tridium.provisioningNiagara.software.ProvisioningRegistry;
import com.tridium.provisioningNiagara.ui.software.BSupervisorSoftwareManager;
import com.tridium.sys.Nre;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
public class BSoftwareContainerTree
extends BTree {
    @Generated
    public static final Type TYPE = Sys.loadType(BSoftwareContainerTree.class);
    private final BSupervisorSoftwareManager manager;
    private final BButtonPane buttons;
    private final CheckStationsCommand checkCommand;
    private static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSoftwareContainerTree() {
        throw new UnsupportedOperationException();
    }

    public BSoftwareContainerTree(BSupervisorSoftwareManager manager) {
        this.manager = manager;
        this.setModel(new Model());
        this.setSelection(new Selection());
        Command[] commandArray = new Command[3];
        commandArray[0] = new SyncCommand((BWidget)manager);
        commandArray[1] = new RegisterCommand((BWidget)manager);
        this.checkCommand = new CheckStationsCommand((BWidget)manager);
        commandArray[2] = this.checkCommand;
        this.buttons = new BButtonPane(commandArray);
    }

    BButtonPane getButtons() {
        return this.buttons;
    }

    void load(BSoftwareContainer container) throws Exception {
        ((Model)this.getModel()).load(container);
    }

    BSoftwareContainer getSoftwareContainer() {
        return this.manager.getSoftwareContainer();
    }

    public int dragOver(TransferContext cx) {
        Mark mark;
        BObject[] values;
        if (this.getSoftwareContainer() == null) {
            return 0;
        }
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark) && (values = (mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark)).getValues()).length > 0) {
            for (BObject value : values) {
                BInstallable inst = null;
                if (value instanceof BInstallable) {
                    inst = (BInstallable)value;
                } else if (value instanceof BIFile) {
                    inst = BInstallable.make((BIFile)((BIFile)value));
                }
                if (inst == null || inst.getVersion().getVendorVersion().equals((Object)Version.ZERO)) continue;
                return 16;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandArtifact drop(TransferContext cx) throws Exception {
        Mark mark;
        BObject[] values;
        if (this.getSoftwareContainer() == null) {
            return null;
        }
        ProvisioningRegistry registry = null;
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark) && (values = (mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark)).getValues()).length > 0) {
            for (BObject value : values) {
                BInstallableSpec spec;
                BInstallable existing;
                BInstallable inst = null;
                if (value instanceof BInstallable) {
                    inst = (BInstallable)value;
                } else if (value instanceof BIFile) {
                    inst = BInstallable.make((BIFile)((BIFile)value));
                }
                if (inst == null) continue;
                if (inst.getVersion().isNull()) {
                    BDialog.warning((BWidget)this, (String)lex.getText("SoftwareContainerTree.wrongType.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.wrongType.dlgMessage", new Object[]{inst}));
                    continue;
                }
                if (registry == null) {
                    registry = this.getSoftwareContainer().getNetworkExt().getInstallableRegistry();
                }
                if ((existing = registry.findInstallable((spec = BInstallableSpec.make((BInstallable)inst)).asDependency(), this.manager.getTaskListener())) == null) {
                    DaemonSessionTask task = new DaemonSessionTask(lex, "SoftwareContainerTree.registering.title", "SoftwareContainerTree.registering.message", new Object[]{spec});
                    try {
                        this.manager.getTaskListener().taskStarted(task);
                        registry.register(inst, null);
                        continue;
                    }
                    finally {
                        this.manager.getTaskListener().taskFinished(task);
                    }
                }
                BDialog.warning((BWidget)this, (String)lex.getText("SoftwareContainerTree.alreadyRegistered.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.alreadyRegistered.dlgMessage", new Object[]{spec}));
            }
        }
        return null;
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (evt.getId() == 1) {
            if (evt.getValue() instanceof BInstallableSpec) {
                VersionNode node = ((Model)this.getModel()).addVersionNode((BInstallableSpec)evt.getValue());
                node.getParent().setExpanded(true);
            } else if (evt.getValue() instanceof BInstallableSummary) {
                SummaryNode node = ((Model)this.getModel()).addSummaryNode((BInstallableSummary)evt.getValue());
                node.setExpanded(true);
            }
        }
    }

    private class CheckStationsCommand
    extends AsyncCommand {
        public CheckStationsCommand(BWidget owner) {
            super(owner, BSoftwareContainerTree.this.getLexicon(), "SoftwareContainerTree.checkStationsCommand");
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                TreeNode node = BSoftwareContainerTree.this.getSelection().getNodes()[0];
                if (node instanceof VersionNode) {
                    ((VersionNode)node).checkStations(this.getOwner());
                } else {
                    ((SummaryNode)node).getLatestVersionNode().checkStations(this.getOwner());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
        }
    }

    private class RegisterCommand
    extends AsyncCommand {
        public RegisterCommand(BWidget owner) {
            super(owner, BSoftwareContainerTree.this.getLexicon(), "SoftwareContainerTree.registerCommand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block8: {
                try {
                    BInstallableSpec spec;
                    BOrd fileOrd = BFileChooser.showOpen((BWidget)this.getOwner());
                    if (fileOrd == null) break block8;
                    BInstallable inst = BInstallable.make((BIFile)((BIFile)fileOrd.get()));
                    if (inst == null || inst.getVersion().isNull()) {
                        BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.wrongType.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.wrongType.dlgMessage", new Object[]{fileOrd}));
                        break block8;
                    }
                    if (BSoftwareContainer.isCleanDistFile(inst)) {
                        BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.cleanDist.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.cleanDist.dlgMessage", new Object[]{fileOrd}));
                        break block8;
                    }
                    ProvisioningRegistry registry = BSoftwareContainerTree.this.getSoftwareContainer().getNetworkExt().getInstallableRegistry();
                    BInstallable existing = registry.findInstallable((spec = BInstallableSpec.make((BInstallable)inst)).asDependency(), BSoftwareContainerTree.this.manager.getTaskListener());
                    if (existing == null) {
                        DaemonSessionTask task = new DaemonSessionTask(lex, "SoftwareContainerTree.registering.title", "SoftwareContainerTree.registering.message", new Object[]{spec});
                        try {
                            BSoftwareContainerTree.this.manager.getTaskListener().taskStarted(task);
                            registry.register(inst, null);
                            break block8;
                        }
                        finally {
                            BSoftwareContainerTree.this.manager.getTaskListener().taskFinished(task);
                        }
                    }
                    BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.alreadyRegistered.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.alreadyRegistered.dlgMessage", new Object[]{spec}));
                }
                catch (Exception e) {
                    CommandUtil.error((Command)this, (Throwable)e);
                }
            }
        }
    }

    private class SyncCommand
    extends AsyncCommand {
        public SyncCommand(BWidget owner) {
            super(owner, BSoftwareContainerTree.this.getLexicon(), "SoftwareContainerTree.syncCommand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block30: {
                Model model = (Model)BSoftwareContainerTree.this.getModel();
                try {
                    ProvisioningRegistry registry = BSoftwareContainerTree.this.getSoftwareContainer().getNetworkExt().getInstallableRegistry();
                    registry.findInstallable(BDependency.forModule((String)"baja"), BSoftwareContainerTree.this.manager.getTaskListener());
                    BSystemPlatformService platSvc = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)BSoftwareContainerTree.this.manager.getSoftwareContainer());
                    platSvc.lease(4, 500L);
                    if (platSvc.getHostId().equals(Nre.getHostId()) && platSvc.getBajaHome().equals(Nre.getNiagaraHome().getAbsolutePath())) {
                        BDialog.message((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.syncCommand.upToDate.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.syncCommand.upToDate.dlgMessage"));
                        return;
                    }
                    HashMap<BInstallableSpec, BInstallable> toSync = new HashMap<BInstallableSpec, BInstallable>();
                    CancelableDaemonSessionTask task = new CancelableDaemonSessionTask(lex, "SoftwareContainerTree.checking.title", "");
                    task.setImmediate(true);
                    BSoftwareContainerTree.this.manager.getTaskListener().taskStarted((DaemonSessionTask)task);
                    try {
                        IterableCursor cursor = LocalInstallableRegistry.getInstance().getInstallables(false, BSoftwareContainerTree.this.manager.getTaskListener());
                        Object object = null;
                        try {
                            while (cursor.next()) {
                                if (task.isCanceled()) {
                                    break;
                                }
                                BInstallable inst = (BInstallable)cursor.get();
                                BInstallableSpec spec = BInstallableSpec.make((BInstallable)inst);
                                task.setMessage(lex.getText("SoftwareContainerTree.checking.message", new Object[]{spec}));
                                BSoftwareContainerTree.this.manager.getTaskListener().taskUpdated((DaemonSessionTask)task);
                                if (model.getVersionNode(spec) != null) continue;
                                toSync.put(spec, inst);
                            }
                        }
                        catch (Throwable inst) {
                            object = inst;
                            throw inst;
                        }
                        finally {
                            if (cursor != null) {
                                if (object != null) {
                                    try {
                                        cursor.close();
                                    }
                                    catch (Throwable inst) {
                                        ((Throwable)object).addSuppressed(inst);
                                    }
                                } else {
                                    cursor.close();
                                }
                            }
                        }
                    }
                    finally {
                        BSoftwareContainerTree.this.manager.getTaskListener().taskFinished((DaemonSessionTask)task);
                    }
                    if (task.isCanceled()) {
                        return;
                    }
                    if (toSync.size() == 0) {
                        BDialog.message((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.syncCommand.upToDate.dlgTitle"), (Object)lex.getText("SoftwareContainerTree.syncCommand.upToDate.dlgMessage"));
                        break block30;
                    }
                    BIndentPane pane = new BIndentPane();
                    pane.add(lex.getText("SoftwareContainerTree.syncCommand.register.dlgHeader"));
                    pane.indent();
                    for (BInstallableSpec bInstallableSpec : toSync.keySet()) {
                        pane.add(bInstallableSpec.toString());
                    }
                    pane.unindent();
                    pane.add(lex.getText("SoftwareContainerTree.syncCommand.register.dlgFooter"));
                    BBrush backgroundColor = Theme.scrollPane().getControlBackground();
                    BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)pane, 4.0, 4.0, 4.0, 4.0));
                    scrollPane.setViewportBackground(backgroundColor);
                    scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                    BConstrainedPane constrained = new BConstrainedPane((BWidget)scrollPane);
                    constrained.setMinSize(350.0, 250.0);
                    constrained.setMaxSize(350.0, 500.0);
                    if (4 != BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("SoftwareContainerTree.syncCommand.register.dlgTitle"), (Object)constrained)) {
                        return;
                    }
                    task = new CancelableDaemonSessionTask(lex, "SoftwareContainerTree.registering.title", "");
                    BSoftwareContainerTree.this.manager.getTaskListener().taskStarted((DaemonSessionTask)task);
                    try {
                        for (BInstallableSpec spec : toSync.keySet()) {
                            if (task.isCanceled()) {
                                break;
                            }
                            BInstallable inst = (BInstallable)toSync.get(spec);
                            task.setMessage(lex.getText("SoftwareContainerTree.registering.message", new Object[]{spec}));
                            BSoftwareContainerTree.this.manager.getTaskListener().taskUpdated((DaemonSessionTask)task);
                            registry.register(inst, null);
                        }
                    }
                    finally {
                        BSoftwareContainerTree.this.manager.getTaskListener().taskFinished((DaemonSessionTask)task);
                    }
                }
                catch (Exception e) {
                    CommandUtil.error((Command)this, (Throwable)e);
                }
            }
        }
    }

    private class Selection
    extends TreeSelection {
        public void updateTree() {
            super.updateTree();
            TreeNode[] s = this.getNodes();
            if (s.length == 0) {
                BSoftwareContainerTree.this.manager.showSpec(null);
                BSoftwareContainerTree.this.checkCommand.setEnabled(false);
            } else if (s.length > 1) {
                BSoftwareContainerTree.this.manager.showSpec(null);
                BSoftwareContainerTree.this.checkCommand.setEnabled(false);
            } else {
                BSoftwareContainerTree.this.checkCommand.setEnabled(true);
                if (s[0] instanceof VersionNode) {
                    ((VersionNode)s[0]).showDetails();
                } else {
                    BSoftwareContainerTree.this.manager.showSpec(null);
                }
            }
        }
    }

    private class VersionNode
    extends TreeNode
    implements Comparable<VersionNode> {
        private final BInstallableSpec spec;
        private BInstallable installable;

        public VersionNode(SummaryNode parent, BInstallableSpec spec) {
            super((TreeNode)parent);
            this.installable = null;
            this.spec = spec;
        }

        @Override
        public int compareTo(VersionNode o1) {
            return this.getInstallableSpec().getVersion().compareTo((Object)o1.getInstallableSpec().getVersion());
        }

        public String getText() {
            return this.spec.getVersion().toString();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.spec.getInstallableType().getTypeInfo().getIcon(null));
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int index) {
            throw new IllegalStateException();
        }

        public BInstallableSpec getInstallableSpec() {
            return this.spec;
        }

        public BInstallable getInstallable() throws Exception {
            if (this.installable == null) {
                BProvisioningNiagaraNetworkExt prov = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get((BObject)BSoftwareContainerTree.this.getSoftwareContainer());
                ProvisioningRegistry registry = prov.getInstallableRegistry();
                this.installable = registry.findInstallable(this.spec.asDependency(), BSoftwareContainerTree.this.manager.getTaskListener());
            }
            return this.installable;
        }

        public void showDetails() {
            BSoftwareContainerTree.this.manager.showSpec(this.spec);
        }

        public void checkStations(BWidget owner) throws Exception {
            BSoftwareContainerTree.this.manager.checkStations(this.getInstallable());
        }
    }

    private class SummaryNode
    extends TreeNode
    implements Comparable<SummaryNode> {
        private final String installableName;
        private final BTypeSpec installableType;
        private final List<VersionNode> kids;
        private final Map<String, VersionNode> leafByVersion;

        public SummaryNode(Model model, BInstallableSummary summary) {
            this(model, summary.getInstallableName(), summary.getInstallableType());
        }

        private SummaryNode(Model model, String installableName, BTypeSpec installableType) {
            super((TreeModel)model);
            this.kids = new ArrayList<VersionNode>();
            this.leafByVersion = new HashMap<String, VersionNode>();
            this.installableName = installableName;
            this.installableType = installableType;
        }

        public void updateTree() {
            this.kids.sort(Comparator.naturalOrder());
            this.getModel().updateTree();
        }

        public int getChildCount() {
            return this.kids.size();
        }

        public TreeNode getChild(int index) {
            return this.kids.get(index);
        }

        public String getText() {
            return this.installableName;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.installableType.getTypeInfo().getIcon(null));
        }

        @Override
        public int compareTo(SummaryNode o1) {
            return this.getInstallableName().compareTo(o1.getInstallableName());
        }

        public void load(BInstallableSummary summary) {
            SlotCursor c = summary.getProperties();
            while (c.next(BInstallableSpec.class)) {
                this.addVersionNode((BInstallableSpec)c.get());
            }
        }

        public synchronized VersionNode addVersionNode(BInstallableSpec spec) {
            VersionNode kid = this.getVersionNode(spec.getVersion().getVendorVersionString());
            if (kid == null) {
                kid = new VersionNode(this, spec);
                this.leafByVersion.put(spec.getVersion().getVendorVersionString(), kid);
                this.kids.add(kid);
                this.updateTree();
            }
            return kid;
        }

        public VersionNode getVersionNode(String vendorVersionString) {
            return this.leafByVersion.get(vendorVersionString);
        }

        public VersionNode getLatestVersionNode() {
            VersionNode result = null;
            Version resultVersion = null;
            for (String checkVersionString : this.leafByVersion.keySet()) {
                Version checkVersion = new Version(checkVersionString);
                if (result != null && checkVersion.compareTo(resultVersion) <= 0) continue;
                resultVersion = checkVersion;
                result = this.leafByVersion.get(checkVersionString);
            }
            return result;
        }

        public String getInstallableName() {
            return this.installableName;
        }
    }

    private class Model
    extends TreeModel {
        private final Map<String, SummaryNode> summaryByName = new ConcurrentSkipListMap<String, SummaryNode>();

        public int getRootCount() {
            return this.summaryByName.size();
        }

        public TreeNode getRoot(int index) {
            Object[] roots = this.summaryByName.values().toArray();
            return (TreeNode)roots[index];
        }

        public void load(BSoftwareContainer container) {
            SlotCursor c = container.getProperties();
            while (c.next(BInstallableSummary.class)) {
                this.addSummaryNode((BInstallableSummary)c.get());
            }
        }

        public synchronized VersionNode addVersionNode(BInstallableSpec spec) {
            SummaryNode kid = this.getSummaryNode(spec.getInstallableName());
            if (kid == null) {
                kid = new SummaryNode(this, spec.getInstallableName(), spec.getInstallableType());
                this.summaryByName.put(spec.getInstallableName(), kid);
            }
            return kid.addVersionNode(spec);
        }

        public VersionNode getVersionNode(BInstallableSpec spec) {
            SummaryNode kid = this.getSummaryNode(spec.getInstallableName());
            return kid == null ? null : kid.getVersionNode(spec.getVersion().getVendorVersionString());
        }

        public synchronized SummaryNode addSummaryNode(BInstallableSummary summary) {
            SummaryNode kid = this.getSummaryNode(summary.getInstallableName());
            if (kid == null) {
                kid = new SummaryNode(this, summary);
                this.summaryByName.put(summary.getInstallableName(), kid);
            }
            kid.load(summary);
            return kid;
        }

        public SummaryNode getSummaryNode(String installableName) {
            return this.summaryByName.get(installableName);
        }
    }
}

