/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.install.BPartInstallStatus;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableRow;
import com.tridium.ui.BOptionDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.PatternFilter;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="isStatusEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="statusString", type="String", defaultValue=""), @NiagaraProperty(name="isNameEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="partNamePattern", type="String", defaultValue=""), @NiagaraProperty(name="partNameExclude", type="boolean", defaultValue="false")})
public class BStationSoftwareFilter
extends BComponent
implements IFilter {
    @Generated
    public static final Property isStatusEnabled = BStationSoftwareFilter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property statusString = BStationSoftwareFilter.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property isNameEnabled = BStationSoftwareFilter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property partNamePattern = BStationSoftwareFilter.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property partNameExclude = BStationSoftwareFilter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BStationSoftwareFilter.class);
    private int[] statusValues = new int[0];
    private boolean formatting = false;
    private static volatile Map<String, List<Integer>> statusTextMap = null;
    private PatternFilter[] nameFilters = null;

    @Generated
    public boolean getIsStatusEnabled() {
        return this.getBoolean(isStatusEnabled);
    }

    @Generated
    public void setIsStatusEnabled(boolean v) {
        this.setBoolean(isStatusEnabled, v, null);
    }

    @Generated
    public String getStatusString() {
        return this.getString(statusString);
    }

    @Generated
    public void setStatusString(String v) {
        this.setString(statusString, v, null);
    }

    @Generated
    public boolean getIsNameEnabled() {
        return this.getBoolean(isNameEnabled);
    }

    @Generated
    public void setIsNameEnabled(boolean v) {
        this.setBoolean(isNameEnabled, v, null);
    }

    @Generated
    public String getPartNamePattern() {
        return this.getString(partNamePattern);
    }

    @Generated
    public void setPartNamePattern(String v) {
        this.setString(partNamePattern, v, null);
    }

    @Generated
    public boolean getPartNameExclude() {
        return this.getBoolean(partNameExclude);
    }

    @Generated
    public void setPartNameExclude(boolean v) {
        this.setBoolean(partNameExclude, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationSoftwareFilter() {
        this.formatStatusString();
    }

    public final boolean accept(Object o) {
        SoftwareTableRow r = (SoftwareTableRow)o;
        return r.getInstallStatus() != BPartInstallStatus.noChange || r.getStatus() == 3 || r.getStatus() == 12 || r.getStatus() == 4 || this.acceptStatus(r) && this.acceptName(r);
    }

    public boolean getIsEnabled() {
        return this.getIsStatusEnabled() || this.getIsNameEnabled();
    }

    protected synchronized boolean acceptStatus(SoftwareTableRow row) {
        if (!this.getIsStatusEnabled()) {
            return true;
        }
        for (int statusValue : this.statusValues) {
            if (row.getStatus() != statusValue) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptName(SoftwareTableRow row) {
        if (!this.getIsNameEnabled()) {
            return true;
        }
        String name = row.getPartName() == null ? "" : row.getPartName();
        boolean result = false;
        for (PatternFilter f : this.getNameFilters()) {
            if (!f.accept(TextUtil.toLowerCase((String)name))) continue;
            result = true;
            break;
        }
        return this.getPartNameExclude() ? !result : result;
    }

    public static BStationSoftwareFilter getFilter(BWidget owner, BStationSoftwareFilter currentValue) {
        Prompt prompt = new Prompt(owner, currentValue);
        BOptionDialog dlg = new BOptionDialog(owner, TYPE.getModule().getLexicon().getText("StationSoftwareFilter.dlgTitle"), (BWidget)prompt.getPane(), 3, null, null);
        dlg.getOkButton().setText(TYPE.getModule().getLexicon().getText("StationSoftwareFilter.applyButton"));
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        if (dlg.getResult() == 1) {
            return prompt.getFilter();
        }
        return null;
    }

    public PatternFilter[] getNameFilters() {
        if (this.nameFilters == null) {
            this.nameFilters = PatternFilter.parseList((String)TextUtil.toLowerCase((String)this.getPartNamePattern()));
        }
        return this.nameFilters;
    }

    public synchronized void includeStatus(int value) {
        this.includeStatus(new int[]{value});
    }

    public synchronized void includeStatus(int[] values) {
        boolean updated = false;
        for (int value : values) {
            int ix;
            if (value == 3 || value == 12 || value == 4 || (ix = this.indexOfStatus(value)) >= 0) continue;
            int[] temp = new int[this.statusValues.length + 1];
            temp[0] = value;
            System.arraycopy(this.statusValues, 0, temp, 1, this.statusValues.length);
            this.statusValues = temp;
            updated = true;
        }
        if (updated) {
            this.formatStatusString();
        }
    }

    public synchronized void excludeStatus(int value) {
        this.excludeStatus(new int[]{value});
    }

    public synchronized void excludeStatus(int[] values) {
        boolean updated = false;
        for (int value : values) {
            int ix;
            if (value == 3 || value == 12 || value == 4 || (ix = this.indexOfStatus(value)) < 0) continue;
            int[] temp = new int[this.statusValues.length - 1];
            if (ix > 0) {
                System.arraycopy(this.statusValues, 0, temp, 0, ix);
            }
            if (ix < this.statusValues.length - 1) {
                System.arraycopy(this.statusValues, ix + 1, temp, ix, this.statusValues.length - ix - 1);
            }
            this.statusValues = temp;
            updated = true;
        }
        if (updated) {
            this.formatStatusString();
        }
    }

    private synchronized int indexOfStatus(int statusValue) {
        for (int i = 0; i < this.statusValues.length; ++i) {
            if (this.statusValues[i] != statusValue) continue;
            return i;
        }
        return -1;
    }

    public String[] getStatusStrings() {
        return TextUtil.split((String)this.getStatusString(), (char)'|');
    }

    public static String[] getAvailableStrings() {
        return new String[]{BStationSoftwareFilter.statusToString(6), BStationSoftwareFilter.statusToString(13), BStationSoftwareFilter.statusToString(2), BStationSoftwareFilter.statusToString(7), BStationSoftwareFilter.statusToString(8), BStationSoftwareFilter.statusToString(11)};
    }

    public static String statusToString(int status) {
        switch (status) {
            case 6: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.notInstalled");
            }
            case 13: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.needCommissioningMissing");
            }
            case 1: 
            case 2: 
            case 5: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.upToDate");
            }
            case 7: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.badInstallable");
            }
            case 8: 
            case 9: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.badTarget");
            }
            case 11: {
                return TYPE.getModule().getLexicon().getText("StationSoftwareView.status.noLocal");
            }
        }
        return "";
    }

    public static int[] stringToStatus(String string) {
        List<Integer> list = BStationSoftwareFilter.getStatusTextMap().get(string);
        if (list == null) {
            return new int[0];
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    private static Map<String, List<Integer>> getStatusTextMap() {
        if (statusTextMap == null) {
            statusTextMap = new HashMap<String, List<Integer>>();
            BStationSoftwareFilter.updateStatusMapEntry(0, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(1, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(2, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(5, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(6, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(13, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(7, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(8, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(9, statusTextMap);
            BStationSoftwareFilter.updateStatusMapEntry(11, statusTextMap);
        }
        return statusTextMap;
    }

    private static void updateStatusMapEntry(int status, Map<String, List<Integer>> map) {
        String key = BStationSoftwareFilter.statusToString(status);
        List<Integer> currentEntry = map.get(key);
        if (currentEntry == null) {
            currentEntry = new ArrayList<Integer>();
            map.put(key, currentEntry);
        }
        currentEntry.add(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseStatusString() {
        if (this.formatting) {
            return;
        }
        Property property = statusString;
        synchronized (property) {
            int[] temp = new int[50];
            int ix = 0;
            for (String token : this.getStatusStrings()) {
                for (int aToAdd : BStationSoftwareFilter.stringToStatus(token)) {
                    temp[ix++] = aToAdd;
                }
            }
            int[] result = new int[ix];
            System.arraycopy(temp, 0, result, 0, ix);
            this.statusValues = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatStatusString() {
        Property property = statusString;
        synchronized (property) {
            this.formatting = true;
            HashSet<String> set = new HashSet<String>();
            for (int statusValue : this.statusValues) {
                set.add(BStationSoftwareFilter.statusToString(statusValue));
            }
            this.setStatusString(String.join((CharSequence)"|", set));
            this.formatting = false;
        }
    }

    public void changed(Property property, Context context) {
        if (property == statusString) {
            this.parseStatusString();
        }
        if (property == partNamePattern) {
            this.nameFilters = null;
        }
    }

    private static class EnableCommand
    extends ToggleCommand {
        private final BWidget[] widgets;

        public EnableCommand(BWidget owner, BWidget[] pWidgets, boolean initialState, String lexTag) {
            super(owner, TYPE.getModule(), lexTag);
            this.widgets = pWidgets;
            this.setSelected(initialState);
            this.invoke();
        }

        public CommandArtifact doInvoke() {
            for (BWidget widget : this.widgets) {
                widget.setEnabled(this.isSelected());
            }
            return null;
        }
    }

    private static class CheckAllCommand
    extends Command {
        private final BCheckList statusCheckList;

        public CheckAllCommand(BWidget owner, BCheckList statusCheckList) {
            super(owner, TYPE.getModule(), "StationSoftwareFilter.CheckAllCommand");
            this.statusCheckList = statusCheckList;
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < this.statusCheckList.getItemCount(); ++i) {
                this.statusCheckList.getSelection().select(i);
            }
            return null;
        }
    }

    private static class ClearCommand
    extends Command {
        private final BCheckList statusCheckList;

        public ClearCommand(BWidget owner, BCheckList statusCheckList) {
            super(owner, TYPE.getModule(), "StationSoftwareFilter.ClearCommand");
            this.statusCheckList = statusCheckList;
        }

        public CommandArtifact doInvoke() {
            this.statusCheckList.getSelection().deselectAll();
            return null;
        }
    }

    private static class ExcludeCommand
    extends ToggleCommand {
        public ExcludeCommand(BWidget owner) {
            super(owner, TYPE.getModule(), "StationSoftwareFilter.ExcludeCommand");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    private static class IncludeCommand
    extends ToggleCommand {
        public IncludeCommand(BWidget owner) {
            super(owner, TYPE.getModule(), "StationSoftwareFilter.IncludeCommand");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    private static class StatusListModel
    extends ListModel {
        private final String[] strings = BStationSoftwareFilter.getAvailableStrings();

        public int getItemCount() {
            return this.strings.length;
        }

        public Object getItem(int row) {
            return this.strings[row];
        }
    }

    private static class Prompt {
        private final BCheckList statusCheckList;
        private final BTextField installableNameTextField;
        private final BRadioButton includeButton;
        private final BGridPane pane = new BGridPane(1);

        private Prompt(BWidget owner, BStationSoftwareFilter currentValue) {
            BGridPane innerGrid = new BGridPane(3);
            innerGrid.setRowGap(6.0);
            innerGrid.setColumnAlign(BHalign.fill);
            if (currentValue == null) {
                currentValue = new BStationSoftwareFilter();
            }
            this.statusCheckList = new BCheckList();
            this.statusCheckList.setModel((ListModel)new StatusListModel());
            ListSelection sel = this.statusCheckList.getSelection();
            String[] selectedStrings = currentValue.getStatusStrings();
            HashSet set = new HashSet();
            Collections.addAll(set, selectedStrings);
            for (int i = 0; i < this.statusCheckList.getItemCount(); ++i) {
                if (!set.contains(this.statusCheckList.getItem(i))) continue;
                sel.select(i);
            }
            BButton allButton = new BButton((Command)new CheckAllCommand(owner, this.statusCheckList));
            BButton clearButton = new BButton((Command)new ClearCommand(owner, this.statusCheckList));
            innerGrid.add(null, (BValue)new BCheckBox((ToggleCommand)new EnableCommand(owner, new BWidget[]{this.statusCheckList, allButton, clearButton}, currentValue.getIsStatusEnabled(), "InstallerTableFilterPrompt.enableStatus")));
            innerGrid.add(null, (BValue)this.statusCheckList);
            BGridPane buttonGrid = new BGridPane(1);
            buttonGrid.setColumnAlign(BHalign.fill);
            buttonGrid.setHalign(BHalign.left);
            buttonGrid.add(null, (BValue)allButton);
            buttonGrid.add(null, (BValue)clearButton);
            innerGrid.add(null, (BValue)buttonGrid);
            this.installableNameTextField = new BTextField(currentValue.getPartNamePattern());
            ToggleCommandGroup commandGroup = new ToggleCommandGroup();
            buttonGrid = new BGridPane(1);
            ToggleCommand cmd = new IncludeCommand(owner);
            this.includeButton = new BRadioButton(cmd);
            buttonGrid.add(null, (BValue)this.includeButton);
            commandGroup.add(cmd);
            cmd.setSelected(!currentValue.getPartNameExclude());
            cmd = new ExcludeCommand(owner);
            BRadioButton excludeButton = new BRadioButton(cmd);
            buttonGrid.add(null, (BValue)excludeButton);
            commandGroup.add(cmd);
            cmd.setSelected(currentValue.getPartNameExclude());
            innerGrid.add(null, (BValue)new BCheckBox((ToggleCommand)new EnableCommand(owner, new BWidget[]{this.installableNameTextField, this.includeButton, excludeButton}, currentValue.getIsNameEnabled(), "InstallerTableFilterPrompt.enableName")));
            innerGrid.add(null, (BValue)this.installableNameTextField);
            innerGrid.add(null, (BValue)buttonGrid);
            this.pane.add(null, (BValue)innerGrid);
        }

        public BGridPane getPane() {
            return this.pane;
        }

        protected BStationSoftwareFilter getFilter() {
            BStationSoftwareFilter result = new BStationSoftwareFilter();
            result.setIsStatusEnabled(this.statusCheckList.isEnabled());
            for (int i = 0; i < this.statusCheckList.getItemCount(); ++i) {
                if (!this.statusCheckList.getSelection().isSelected(i)) continue;
                result.includeStatus(BStationSoftwareFilter.stringToStatus(this.statusCheckList.getItem(i).toString()));
            }
            result.setIsNameEnabled(this.installableNameTextField.isEnabled());
            result.setPartNamePattern(this.installableNameTextField.getText());
            result.setPartNameExclude(!this.includeButton.isSelected());
            return result;
        }
    }
}

