/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.provisioningNiagara.template.BUpdateConfigurationStep;
import com.tridium.workbench.shell.BPasswordField;
import java.security.AccessController;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStep;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.provisioningNiagara.ui.BStationStepFactory;
import javax.baja.security.BPassword;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;

@NiagaraType(agent={@AgentOn(types={"provisioningNiagara:UpdateConfigurationStep"})})
@NiagaraSingleton
public class BUpdateConfigurationFactory
extends BStationStepFactory {
    @Generated
    public static final BUpdateConfigurationFactory INSTANCE = new BUpdateConfigurationFactory();
    @Generated
    public static final Type TYPE = Sys.loadType(BUpdateConfigurationFactory.class);
    protected BPasswordField passwordField;
    protected BCheckBox isPasswordProtectedBox;
    private static final BIcon icon = BIcon.std((String)"files/ntpl.png");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BJobStep makeStep(BWidget owner, BBatchJob currentBatchJob, BObject jobTarget, BObject source, Context cx) throws Exception {
        BIFile file = source instanceof BIFile ? (BIFile)source : this.getFileSelection(owner, BOrd.make((String)"file:^"), jobTarget);
        if (file == null) {
            return null;
        }
        Boolean isPasswordProtected = this.showPasswordDialog(owner);
        if (isPasswordProtected == null) {
            return null;
        }
        return this.generateStep(file, isPasswordProtected);
    }

    @Override
    public BJobStep editStep(BWidget owner, BBatchJob currentBatchJob, BObject jobTarget, BObject factoryArg, Context cx) throws Exception {
        BUpdateConfigurationStep oldStep = (BUpdateConfigurationStep)factoryArg;
        BIFile file = this.getFileSelection(owner, oldStep.getExcelFileOrd().getParent(), jobTarget);
        if (file == null) {
            return null;
        }
        Boolean isPasswordProtected = this.showPasswordDialog(owner, oldStep.getEncodingPassword());
        if (isPasswordProtected == null) {
            return null;
        }
        return this.generateStep(file, isPasswordProtected);
    }

    private BUpdateConfigurationStep generateStep(BIFile file, boolean isPasswordProtected) {
        BUpdateConfigurationStep newStep = new BUpdateConfigurationStep(file);
        newStep.setFactoryType(this.getType().getTypeSpec());
        newStep.setIsPasswordProtected(isPasswordProtected);
        if (isPasswordProtected) {
            newStep.setEncodingPassword(this.passwordField.getPassword());
        }
        return newStep;
    }

    private BIFile getFileSelection(BWidget owner, BOrd locationOrd, BObject jobTarget) {
        ExtFileFilter excelFilter = new ExtFileFilter("Excel Files", new String[]{"xlsx", "xls"});
        return BFileChooserDialog.chooseFile((BWidget)owner, (BImage)BImage.make((String)LEX.getText("NiagaraNetworkJobBuilder.updateConfigurationDialog.icon")), (String)LEX.getText("NiagaraNetworkJobBuilder.updateConfigurationDialog.title"), (String)LEX.getText("NiagaraNetworkJobBuilder.updateConfigurationDialog.message"), (BIFile)((BIFile)locationOrd.get(jobTarget)), (IFileFilter)excelFilter, (IFileFilter)excelFilter, null);
    }

    private Boolean showPasswordDialog(BWidget owner) {
        return this.showPasswordDialog(owner, null);
    }

    private Boolean showPasswordDialog(BWidget owner, BPassword password) {
        this.isPasswordProtectedBox = new BCheckBox(LEX.getText("UpdateConfigurationFactory.dialogTitle"), false);
        this.isPasswordProtectedBox.setCommand((Command)new SetSpreadsheetPasswordCommand((BWidget)this.isPasswordProtectedBox), false, false);
        if (password == null || password.isDefault()) {
            this.passwordField = new BPasswordField("", 40);
            this.isPasswordProtectedBox.setSelected(false);
        } else {
            this.passwordField = new BPasswordField(AccessController.doPrivileged(() -> ((BPassword)password).getValue()), 40);
            this.isPasswordProtectedBox.setSelected(true);
        }
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BWizardHeader(null, LEX.getText("UpdateConfigurationFactory.dialogTitle"), LEX.getText("UpdateConfigurationFactory.dialogMessage")));
        BGridPane contentPane = new BGridPane(1);
        contentPane.add("isPasswordProtected", (BValue)this.isPasswordProtectedBox);
        contentPane.add("passwordField", (BValue)this.passwordField);
        pane.setCenter((BWidget)contentPane);
        if (1 != BDialog.open((BWidget)owner, (String)LEX.getText("UpdateConfigurationFactory.dialogTitle"), (Object)pane, (int)3)) {
            return null;
        }
        return this.isPasswordProtectedBox.getSelected();
    }

    public BIcon getIcon() {
        return icon;
    }

    class SetSpreadsheetPasswordCommand
    extends ToggleCommand {
        public SetSpreadsheetPasswordCommand(BWidget owner) {
            super(owner, BStationStepFactory.LEX.getText("UpdateConfigurationFactory.passwordProtected"));
        }

        public CommandArtifact doInvoke() {
            BUpdateConfigurationFactory.this.passwordField.setEnabled(BUpdateConfigurationFactory.this.isPasswordProtectedBox.isSelected());
            return null;
        }
    }
}

