/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.provisioningNiagara.ui.station.BStationProxyOutputPane;
import com.tridium.provisioningNiagara.ui.station.ClearOutputCommand;
import com.tridium.provisioningNiagara.ui.station.DumpThreadCommand;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.ConnectException;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

@NiagaraType
public class BStationProxyOutputDialog
extends BFrame {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationProxyOutputDialog.class);
    private static Lexicon lex = TYPE.getModule().getLexicon();
    private BStationProxyOutputPane outputPane;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationProxyOutputDialog() {
        throw new UnsupportedOperationException();
    }

    public BStationProxyOutputDialog(BWidget owner, BStationProxy station) throws ConnectException, AuthenticationException {
        this(owner, station, null);
    }

    public BStationProxyOutputDialog(BWidget owner, BStationProxy station, FilePath captureTo) throws ConnectException, AuthenticationException {
        super(lex.getText("StationProxyOutputDialog.stationTitle", new Object[]{station.getDisplayName(null)}));
        BStationProxyOutputPane center;
        this.outputPane = new BStationProxyOutputPane();
        this.setIconImage(BImage.make((String)lex.getText("StationProxyOutputDialog.icon")));
        BButtonPane buttonPane = new BButtonPane();
        buttonPane.add((Command)new DumpThreadCommand(owner, station));
        BToggleButton pauseButton = new BToggleButton();
        buttonPane.add((BWidget)pauseButton);
        PauseOutputCommand pauseOutputCommand = new PauseOutputCommand((BAbstractButton)pauseButton);
        pauseButton.setCommand((Command)pauseOutputCommand, true, false);
        buttonPane.add((Command)new ClearOutputCommand(owner, this.outputPane));
        buttonPane.add((Command)new CloseCommand());
        if (captureTo == null) {
            center = this.outputPane;
        } else {
            BFlowPane flow = new BFlowPane(BHalign.left);
            flow.add("capture", (BValue)new BLabel(this.getLexicon().getText("StationProxyOutputDialog.capture", new Object[]{captureTo.getBody()})));
            center = new BEdgePane((BWidget)new BBorderPane((BWidget)flow, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)this.outputPane);
            this.outputPane.setCapturePath(captureTo);
        }
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)center, 10.0, 10.0, 10.0, 10.0)));
        this.loadBounds();
        this.outputPane.loadStation(station);
    }

    private void loadBounds() {
        try {
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BComponent bounds = (BComponent)options.get("bounds");
            if (bounds == null) {
                Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
                this.setPreferredSize((int)(0.9 * ss.getWidth()), (int)(0.9 * ss.getHeight()));
                this.setBoundsCenteredOnScreen();
            } else {
                this.setScreenBounds(bounds.getInt(bounds.getProperty("x")), bounds.getInt(bounds.getProperty("y")), bounds.getInt(bounds.getProperty("width")), bounds.getInt(bounds.getProperty("height")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBoundsCenteredOnScreen() {
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBoundsCenteredOn(new RectGeom(0.0, 0.0, (double)sd.width, (double)sd.height));
    }

    public void setBoundsCenteredOn(RectGeom screenRect) {
        this.computePreferredSize();
        double w = this.getPreferredWidth() + 8.0;
        double h = this.getPreferredHeight() + 27.0;
        double x = screenRect.x + (screenRect.width - w) / 2.0;
        double y = screenRect.y + (screenRect.height - h) / 2.0;
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        double sw = ss.width;
        double sh = ss.height;
        if (x + w > sw) {
            x = sw - w;
        }
        if (y + h > sh) {
            y = sh - h;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        this.setScreenBounds(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.outputPane.stop();
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BFolder bounds = new BFolder();
            IRectGeom screenBounds = this.getScreenBounds();
            bounds.add("x", (BValue)BInteger.make((int)((int)screenBounds.x())));
            bounds.add("y", (BValue)BInteger.make((int)((int)screenBounds.y())));
            bounds.add("width", (BValue)BInteger.make((int)((int)screenBounds.width())));
            bounds.add("height", (BValue)BInteger.make((int)((int)screenBounds.height())));
            if (options.get("bounds") == null) {
                options.add("bounds", (BValue)bounds);
            } else {
                options.set("bounds", (BValue)bounds);
            }
            options.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            super.close();
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    private class PauseOutputCommand
    extends ToggleCommand {
        public PauseOutputCommand(BAbstractButton owner) {
            super((BWidget)owner, TYPE.getModule(), "");
        }

        public String getLabel() {
            if (this.isSelected()) {
                return BStationProxyOutputDialog.this.getLexicon().getText("ProvisioningStationDirector.pauseOutputCommand.loadOutput.label");
            }
            return BStationProxyOutputDialog.this.getLexicon().getText("ProvisioningStationDirector.pauseOutputCommand.pauseOutput.label");
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BAbstractButton button = (BAbstractButton)this.getOwner();
                button.setText(this.getLabel());
                if (this.isSelected()) {
                    BStationProxyOutputDialog.this.outputPane.stopUpdates();
                } else {
                    BStationProxyOutputDialog.this.outputPane.load();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand() {
            super((BWidget)BStationProxyOutputDialog.this, TYPE.getModule(), "StationProxyOutputDialog.closeCommand");
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BStationProxyOutputDialog.this.outputPane.deactivated();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                BStationProxyOutputDialog.this.close();
            }
            return null;
        }
    }
}

