/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.station.BStationProxy;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

public class DumpThreadCommand
extends Command {
    private BStationProxy station;

    public DumpThreadCommand(BWidget owner, BStationProxy station) {
        this(owner);
        this.loadStation(station);
    }

    public DumpThreadCommand(BWidget owner) {
        super(owner, Lexicon.make((String)"provisioningNiagara"), "ProvisioningStationDirector.command.dumpThread");
        this.setEnabled(false);
    }

    public void loadStation(BStationProxy value) {
        this.station = value;
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.setEnabled(this.station.getStationStatus() == BStationStatus.running || this.station.getStationStatus() == BStationStatus.stopping || this.station.getStationStatus() == BStationStatus.starting);
    }

    public CommandArtifact doInvoke() {
        BWidgetShell shell = this.getOwner().getShell();
        try {
            if (shell != null) {
                shell.enterBusy();
            }
            this.station.dumpThreads();
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
        return null;
    }
}

