/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.station.BStationProxy;
import javax.baja.gx.BImage;
import javax.baja.platform.BStationStatus;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.util.Lexicon;

public class KillCommand
extends AsyncCommand {
    private BStationProxy station;
    private DaemonSessionTaskListener taskListener;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public KillCommand(BWidget owner, DaemonSessionTaskListener taskListener) {
        super(owner, lex, "ProvisioningStationDirector.command.killStation");
        this.setEnabled(false);
        this.taskListener = taskListener;
    }

    public void loadStation(BStationProxy value) {
        this.station = value;
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.setEnabled(this.station.getStationStatus() == BStationStatus.running || this.station.getStationStatus() == BStationStatus.starting || this.station.getStationStatus() == BStationStatus.stopping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        block7: {
            try {
                String title = lex.getText("ProvisioningStationDirector.command.killStation.dlgTitle", new Object[]{this.station.getStationDisplayName()});
                String message = lex.getText("ProvisioningStationDirector.command.killStation.dlgMessage", new Object[]{this.station.getStationDisplayName()});
                if (BDialog.open((BWidget)this.getOwner(), (String)title, (Object)message, (int)12, (BImage)BDialog.WARNING_ICON, (String)null) != 4) break block7;
                BWidgetShell shell = this.getOwner().getShell();
                try {
                    if (shell != null) {
                        shell.enterBusy();
                    }
                    this.station.killStation(null, this.taskListener);
                }
                finally {
                    if (shell != null) {
                        shell.exitBusy();
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }
}

