/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.provisioningNiagara.license;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDeleteFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.SubscriptionLicenseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BVendorLicenseSummary;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseModel;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.license.BLicenseInstallable;
import com.tridium.provisioningNiagara.license.BLicenseStationExt;
import com.tridium.provisioningNiagara.license.BLicenseStatus;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.util.ThrowableUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BIFile;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobState;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="changeBrand", type="boolean", defaultValue="false"), @NiagaraProperty(name="brandName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="restartRequired", type="boolean", defaultValue="true")})
public class BUpdateLicensesJobStep
extends BNetworkJobStep
implements ICancelHint,
NiagaraNetworkJobOp.InstallListener {
    @Generated
    public static final Property changeBrand = BUpdateLicensesJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property brandName = BUpdateLicensesJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property restartRequired = BUpdateLicensesJobStep.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUpdateLicensesJobStep.class);
    private static final BIcon icon = BIcon.std((String)"doc.png");
    protected static final Logger log = Logger.getLogger("provisioningNiagara");
    private static final String BOOTSTRAPPED_STATIONS_KEY = "bootstrappedStations";

    @Generated
    public boolean getChangeBrand() {
        return this.getBoolean(changeBrand);
    }

    @Generated
    public void setChangeBrand(boolean v) {
        this.setBoolean(changeBrand, v, null);
    }

    @Generated
    public String getBrandName() {
        return this.getString(brandName);
    }

    @Generated
    public void setBrandName(String v) {
        this.setString(brandName, v, null);
    }

    @Generated
    public boolean getRestartRequired() {
        return this.getBoolean(restartRequired);
    }

    @Generated
    public void setRestartRequired(boolean v) {
        this.setBoolean(restartRequired, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUpdateLicensesJobStep(boolean restart) {
        this.setRestartRequired(restart);
    }

    public BUpdateLicensesJobStep() {
    }

    protected void doRun(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp opIn) throws Exception {
        AccessController.doPrivileged(() -> {
            this.doRunPrivileged(svc, details, nw, devices, opIn);
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    protected final void doRunPrivileged(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp opIn) throws Exception {
        void var16_34;
        List<VendorLicense> hostLicenses;
        void var16_28;
        Map<String, BCertificateSummary> stationCertSummaryByVendor;
        BDaemonSession daemonSession;
        BPlatformConnection platformConn;
        NiagaraNetworkJobOp op = (NiagaraNetworkJobOp)opIn;
        HashMap<String, BEnvLicenseSummary> licenseSummaryByHostId = new HashMap<String, BEnvLicenseSummary>();
        HashMap certInfoByHostId = new HashMap();
        HashMap<Object, BCertificateSummary> latestCertSummaryByVendor = new HashMap<Object, BCertificateSummary>();
        Set<BNiagaraStation> stations = this.getBootstrappedStationList((BatchJobOp)op);
        BProvisioningNiagaraNetworkExt nwExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
        for (BDevice device : devices) {
            this.checkCanceled();
            BNiagaraStation bNiagaraStation = (BNiagaraStation)device;
            details.start("provisioningNiagara", "UpdateLicensesJobStep.getExisting", bNiagaraStation.getDisplayName(null));
            boolean bootstrapMode = stations.contains(bNiagaraStation);
            if (bootstrapMode) {
                details.message("provisioningNiagara", "UpdateLicensesJobStep.bootstrapMode", bNiagaraStation.getStationName());
                continue;
            }
            BLicenseStationExt ext = (BLicenseStationExt)bNiagaraStation.getMixIn(BLicenseStationExt.TYPE);
            if (ext.isUnoperational()) {
                details.endFailed("provisioningNiagara", "UpdateLicensesJobStep.licenseExtUnoperational", new String[]{bNiagaraStation.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)ext.getStatus())});
                continue;
            }
            platformConn = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
            if (platformConn.isUnoperational()) {
                details.endFailed("provisioningNiagara", "UpdateLicensesJobStep.platformConnUnoperational", new String[]{bNiagaraStation.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)platformConn.getStatus())});
                continue;
            }
            daemonSession = platformConn.getDaemonSession();
            if (daemonSession != null) continue;
            details.endFailed("provisioningNiagara", "UpdateLicensesJobStep.platformConnUnavailable", new String[]{bNiagaraStation.getDisplayName(null)});
        }
        for (BDevice device : devices) {
            this.checkCanceled();
            BNiagaraStation bNiagaraStation = (BNiagaraStation)device;
            BLicenseStationExt ext = (BLicenseStationExt)bNiagaraStation.getMixIn(BLicenseStationExt.TYPE);
            BPlatformConnection platformConn2 = (BPlatformConnection)bNiagaraStation.getMixIn(BPlatformConnection.TYPE);
            BDaemonSession daemonSession2 = platformConn2.getDaemonSession();
            if (daemonSession2.getHostProperties().getIsLicenseReadonly()) {
                details.endFailed("provisioningNiagara", "UpdateLicensesJobStep.licensesReadonly", new String[]{bNiagaraStation.getDisplayName(null)});
                continue;
            }
            this.checkCanceled();
            BEnvLicenseSummary licenses = ext.makeLicenseSummary();
            licenseSummaryByHostId.put(licenses.getHostId(), this.updateVendorsFromPortal(licenses));
            this.checkCanceled();
            stationCertSummaryByVendor = new HashMap<XElem[], BCertificateSummary>();
            BCertificateSummary[] bCertificateSummaryArray = ext.makeCertificateSummaries();
            this.checkCanceled();
            for (BCertificateSummary cert : bCertificateSummaryArray) {
                XElem[] vendor = cert.getVendor();
                stationCertSummaryByVendor.put((String)vendor, cert);
            }
            certInfoByHostId.put(licenses.getHostId(), stationCertSummaryByVendor);
        }
        HashMap licenseUpdateByHostId = new HashMap();
        boolean checkAgainstSupervisorLicenseDb = true;
        BDevice[] bDeviceArray = devices;
        int device = bDeviceArray.length;
        boolean bl = false;
        while (var16_28 < device) {
            BDevice device2 = bDeviceArray[var16_28];
            this.checkCanceled();
            BNiagaraStation station2 = (BNiagaraStation)device2;
            platformConn = (BPlatformConnection)station2.getMixIn(BPlatformConnection.TYPE);
            daemonSession = platformConn.getDaemonSession();
            BHostIdStatus hostIdStatus = daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus();
            this.checkCanceled();
            if (!hostIdStatus.isPerpetual()) {
                XElem mainElem;
                XElem[] errorElems;
                InputStream inputStream = daemonSession.getInputStream((DaemonMessage)new SubscriptionLicenseMessage());
                String responseText = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("License Update response: " + responseText);
                }
                if ((errorElems = (mainElem = XParser.make((InputStream)new ByteArrayInputStream(responseText.getBytes(StandardCharsets.UTF_8))).parse()).elems("error")) != null && errorElems.length > 0) {
                    if (log.isLoggable(Level.FINE)) {
                        StringBuilder errorMessage = new StringBuilder();
                        for (XElem errorElem : errorElems) {
                            errorMessage.append(": ").append(errorElem.string());
                        }
                        log.log(Level.WARNING, "Error response from the entitlement system during license update request" + errorMessage);
                    } else {
                        log.log(Level.WARNING, "Error response from the entitlement system during license update request.");
                    }
                }
                XElem[] licenseElems = mainElem.elems("license");
                XElem[] certElems = mainElem.elems("certificate");
                for (XElem licenseElem : licenseElems) {
                    VendorLicense updatedLicense = VendorLicense.make((String)"entitlement", (XElem)licenseElem);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Adding license to local database for vendor " + updatedLicense.getVendor());
                    }
                    LicenseDatabase.LOCAL_INSTANCE.add(updatedLicense);
                    hostLicenses = (ArrayList<VendorLicense>)licenseUpdateByHostId.get(updatedLicense.getHostId());
                    if (hostLicenses == null) {
                        hostLicenses = new ArrayList<VendorLicense>();
                        hostLicenses.add(updatedLicense);
                        licenseUpdateByHostId.put(updatedLicense.getHostId(), hostLicenses);
                    }
                    checkAgainstSupervisorLicenseDb = false;
                }
                for (XElem certElem : certElems) {
                    VendorCertificate updatedCert = VendorCertificate.make((String)"entitlement", (XElem)certElem);
                    String vendor = updatedCert.getVendor();
                    if (!latestCertSummaryByVendor.containsKey(vendor)) {
                        latestCertSummaryByVendor.put(vendor, BCertificateSummary.makeEmpty((String)vendor));
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Adding certificate to local database for vendor " + updatedCert.getVendor());
                    }
                    CertificateDatabase.LOCAL_INSTANCE.add(updatedCert);
                }
            }
            ++var16_28;
        }
        if (nwExt.getLicenses().getAllowLicenseServerAccess()) {
            try {
                BEnvLicenseSummary[] licenseSummaries = licenseSummaryByHostId.values().toArray(new BEnvLicenseSummary[0]);
                if (this.getChangeBrand()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Find branded licenses for brandId = " + this.getBrandName());
                    }
                    for (Map.Entry entry : licenseSummaryByHostId.entrySet()) {
                        void var22_60;
                        String existingLicenseBrand;
                        String hostId = (String)entry.getKey();
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Host ID = " + hostId + " Brand ID = " + this.getBrandName());
                        }
                        if ((existingLicenseBrand = ((BEnvLicenseSummary)entry.getValue()).getBrandIdString()) != null && existingLicenseBrand.equalsIgnoreCase(this.getBrandName())) {
                            details.message("provisioningNiagara", "UpdateLicensesJobStep.brandChangeRequestFailed", new String[]{hostId, this.getBrandName()});
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("Existing license for host id " + hostId + " matches the requested brand");
                            continue;
                        }
                        ArrayList<Object> existingVersions = new ArrayList<Object>();
                        String[] daemonSession2 = ((BEnvLicenseSummary)entry.getValue()).getVendors();
                        int hostIdStatus = daemonSession2.length;
                        boolean bl2 = false;
                        while (var22_60 < hostIdStatus) {
                            String vendor = daemonSession2[var22_60];
                            BVendorLicenseSummary licenseSummary = ((BEnvLicenseSummary)entry.getValue()).getVendorInfo(vendor);
                            if (licenseSummary != null) {
                                Version licenseVersion = new Version(licenseSummary.getLicenseVersionString());
                                existingVersions.add(licenseVersion);
                            }
                            ++var22_60;
                        }
                        existingVersions.sort(Comparator.reverseOrder());
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Existing versions = " + existingVersions);
                        }
                        boolean brandedLicenseFound = false;
                        for (Version version : existingVersions) {
                            List brandedModels = PortalLicenseUtil.getExistingLicenses((String)hostId, (String)this.getBrandName(), (Version)version);
                            block14: for (LicenseModel brandedModel : brandedModels) {
                                for (XElem licenseElem : brandedModel.getLicenseElements()) {
                                    VendorLicense brandedLicense = VendorLicense.make((String)"portal", (XElem)licenseElem);
                                    brandedLicense.load("portal", licenseElem);
                                    LicenseDatabase.LOCAL_INSTANCE.add(brandedLicense);
                                    Version vendorLicenseVersion = brandedLicense.getVersion();
                                    String vendorLicenseBrand = brandedLicense.getBrandId();
                                    if (vendorLicenseBrand == null || !vendorLicenseBrand.equalsIgnoreCase(this.getBrandName())) continue;
                                    if (log.isLoggable(Level.FINE)) {
                                        log.log(Level.FINE, "Portal license version = " + vendorLicenseVersion);
                                        log.log(Level.FINE, "Portal license brand = " + vendorLicenseBrand);
                                    }
                                    details.message("provisioningNiagara", "UpdateLicensesJobStep.brandedLicenseFound", new String[]{hostId, vendorLicenseBrand});
                                    hostLicenses = (List)licenseUpdateByHostId.get(hostId);
                                    if (hostLicenses == null) {
                                        hostLicenses = new ArrayList();
                                        licenseUpdateByHostId.put(hostId, hostLicenses);
                                    }
                                    hostLicenses.add(brandedLicense);
                                    checkAgainstSupervisorLicenseDb = false;
                                    brandedLicenseFound = true;
                                    continue block14;
                                }
                            }
                            if (!brandedLicenseFound) continue;
                            break;
                        }
                        if (!brandedLicenseFound) continue;
                        stationCertSummaryByVendor = (Map)certInfoByHostId.get(hostId);
                        for (VendorLicense hostLicense : (List)licenseUpdateByHostId.get(hostId)) {
                            String brandedLicenseVendor;
                            if (!hostLicense.getBrandId().equalsIgnoreCase(this.getBrandName()) || (brandedLicenseVendor = hostLicense.getVendor()) == null) continue;
                            if (!stationCertSummaryByVendor.containsKey(brandedLicenseVendor)) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "Existing certificate was not found for" + brandedLicenseVendor);
                                }
                                stationCertSummaryByVendor.put(brandedLicenseVendor, BCertificateSummary.makeEmpty((String)brandedLicenseVendor));
                            }
                            if (latestCertSummaryByVendor.containsKey(brandedLicenseVendor)) continue;
                            latestCertSummaryByVendor.put(brandedLicenseVendor, BCertificateSummary.makeEmpty((String)brandedLicenseVendor));
                        }
                    }
                } else {
                    for (VendorLicense updatedLicense : PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])licenseSummaries)) {
                        VendorLicense[] vendor = updatedLicense.getVendor();
                        LicenseDatabase.LOCAL_INSTANCE.add(updatedLicense);
                        ArrayList<Object> hostLicenses2 = (ArrayList<Object>)licenseUpdateByHostId.get(updatedLicense.getHostId());
                        if (hostLicenses2 == null) {
                            hostLicenses2 = new ArrayList<Object>();
                            licenseUpdateByHostId.put(updatedLicense.getHostId(), hostLicenses2);
                        }
                        hostLicenses2.add(updatedLicense);
                        stationCertSummaryByVendor = (Map)certInfoByHostId.get(updatedLicense.getHostId());
                        if (!stationCertSummaryByVendor.containsKey(vendor)) {
                            stationCertSummaryByVendor.put((String)vendor, BCertificateSummary.makeEmpty((String)vendor));
                        }
                        if (!latestCertSummaryByVendor.containsKey(vendor)) {
                            latestCertSummaryByVendor.put(vendor, BCertificateSummary.makeEmpty((String)vendor));
                        }
                        checkAgainstSupervisorLicenseDb = false;
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception getting license update information", e);
                details.message("provisioningNiagara", "UpdateLicensesJobStep.licenseSyncFailed", new String[]{ThrowableUtil.dumpToString((Throwable)e)});
            }
        }
        if (checkAgainstSupervisorLicenseDb) {
            for (BEnvLicenseSummary currentLicenseSummary : licenseSummaryByHostId.values()) {
                VendorLicense[] supLicenses;
                String string;
                String string2 = string = this.getChangeBrand() ? this.getBrandName() : currentLicenseSummary.getBrandId();
                if (string.length() == 0) {
                    details.message("provisioningNiagara", "UpdateLicensesJobStep.emptyBrandId", currentLicenseSummary.getHostId());
                }
                ArrayList<VendorLicense> hostLicenses3 = (ArrayList<VendorLicense>)licenseUpdateByHostId.get(currentLicenseSummary.getHostId());
                for (VendorLicense vendorLicense : supLicenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(currentLicenseSummary.getHostId(), string)) {
                    if (vendorLicense.getGenerated() <= currentLicenseSummary.getLicenseGenerated(vendorLicense.getVendor())) continue;
                    if (hostLicenses3 == null) {
                        hostLicenses3 = new ArrayList<VendorLicense>();
                        licenseUpdateByHostId.put(currentLicenseSummary.getHostId(), hostLicenses3);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Adding license from local database for host ID " + currentLicenseSummary.getHostId() + " and brand " + string);
                    }
                    hostLicenses3.add(vendorLicense);
                }
            }
        }
        if (nwExt.getLicenses().getAllowLicenseServerAccess()) {
            try {
                VendorCertificate[] updatedCerts;
                BCertificateSummary[] certSummaries = latestCertSummaryByVendor.values().toArray(new BCertificateSummary[0]);
                for (VendorCertificate aResult : updatedCerts = PortalLicenseUtil.getPortalUpdates((BCertificateSummary[])certSummaries)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Adding certificate to local database for vendor " + aResult.getVendor());
                    }
                    CertificateDatabase.LOCAL_INSTANCE.add(aResult);
                }
            }
            catch (Exception e) {
                details.message("provisioningNiagara", "UpdateLicensesJobStep.certSyncFailed", new String[]{ThrowableUtil.dumpToString((Throwable)e)});
            }
        }
        this.checkCanceled();
        bDeviceArray = devices;
        int n = bDeviceArray.length;
        boolean bl3 = false;
        while (var16_34 < n) {
            BDaemonSession daemonSession3;
            BPlatformConnection platformConn3;
            BDevice device3 = bDeviceArray[var16_34];
            this.checkCanceled();
            BNiagaraStation station3 = (BNiagaraStation)device3;
            BLicenseStationExt ext = (BLicenseStationExt)station3.getMixIn(BLicenseStationExt.TYPE);
            if (!ext.isUnoperational() && !(platformConn3 = (BPlatformConnection)station3.getMixIn(BPlatformConnection.TYPE)).isUnoperational() && (daemonSession3 = platformConn3.getDaemonSession()) != null) {
                boolean bl4 = daemonSession3.getHostProperties().isNiagara4();
                BLicenseInstallable installable = null;
                BEnvLicenseSummary newLicenseSummary = (BEnvLicenseSummary)ext.getLicenseSummary().newCopy();
                List hostLicenses4 = (List)licenseUpdateByHostId.get(ext.getLicenseSummary().getHostId());
                if (hostLicenses4 != null && hostLicenses4.size() > 0) {
                    for (VendorLicense license : hostLicenses4) {
                        if (license.getVersion().major() == 3 && bl4) continue;
                        List<LicenseInfo> existingLicenses = ext.getExistingLicenses();
                        VendorLicense[] vendorLicenseArray = new VendorLicense[]{license};
                        LicenseInfo[] toInstall = LicenseInfo.make((VendorLicense[])vendorLicenseArray);
                        LicenseSync sync = PortalLicenseUtil.syncLicenses((String)ext.getLicenseSummary().getHostId(), (LicenseInfo[])existingLicenses.toArray(new LicenseInfo[0]), (LicenseInfo[])toInstall);
                        if (!this.getChangeBrand() && this.licenseFileCapitalChange(sync.toRemove, license)) {
                            this.deleteExistingLicenseFile(sync.toRemove, details, daemonSession3);
                        }
                        if (this.getChangeBrand()) {
                            this.deleteExistingLicenseFile(existingLicenses, details, daemonSession3);
                        }
                        newLicenseSummary.updateVendorInfo(license);
                        if (installable == null) {
                            installable = new BLicenseInstallable();
                            op.install(station3, installable, this);
                        }
                        installable.addLicense(license);
                        if (!this.getRestartRequired()) {
                            installable.clearNoRunningAppFlag();
                        }
                        if (this.getChangeBrand()) {
                            installable.setRebootFlag();
                        }
                        details.message("provisioningNiagara", "UpdateLicensesJobStep.scheduleLicense", new String[]{license.getLicenseName(), station3.getDisplayName(null)});
                    }
                } else {
                    details.message("provisioningNiagara", "UpdateLicensesJobStep.noUpdatedLicenses", station3.getDisplayName(null));
                }
                BVector newCertificateSummaries = (BVector)ext.getCertificateSummaries().newCopy();
                Map stationCertSummaryByVendor2 = (Map)certInfoByHostId.get(newLicenseSummary.getHostId());
                boolean anyCertUpdates = false;
                for (String vendor : stationCertSummaryByVendor2.keySet()) {
                    VendorCertificate cert;
                    BCertificateSummary existingSummary = (BCertificateSummary)stationCertSummaryByVendor2.get(vendor);
                    if (existingSummary == null) {
                        existingSummary = BCertificateSummary.makeEmpty((String)vendor);
                    }
                    if ((cert = CertificateDatabase.LOCAL_INSTANCE.getCertificate(vendor)) == null) {
                        if (!existingSummary.isEmpty()) continue;
                        details.message("provisioningNiagara", "UpdateLicensesJobStep.vendorCertMissing", new String[]{vendor, station3.getDisplayName(null)});
                        continue;
                    }
                    if (existingSummary.getCertificateGenerated() >= cert.getGenerated()) continue;
                    this.updateCertSummaries(newCertificateSummaries, cert);
                    if (installable == null) {
                        installable = new BLicenseInstallable();
                        op.install(station3, installable, this);
                    }
                    installable.addCertificate(cert);
                    details.message("provisioningNiagara", "UpdateLicensesJobStep.scheduleCert", new String[]{cert.getVendor(), station3.getDisplayName(null)});
                    anyCertUpdates = true;
                }
                if (!anyCertUpdates) {
                    details.message("provisioningNiagara", "UpdateLicensesJobStep.noUpdatedCerts", station3.getDisplayName(null));
                }
            }
            ++var16_34;
        }
    }

    private Set<BNiagaraStation> getBootstrappedStationList(BatchJobOp op) {
        HashSet stations = (HashSet)op.getAttribute((Object)BOOTSTRAPPED_STATIONS_KEY);
        if (stations == null) {
            stations = new HashSet();
            op.setAttribute((Object)BOOTSTRAPPED_STATIONS_KEY, stations);
        }
        return stations;
    }

    private boolean licenseFileCapitalChange(List<LicenseInfo> toRemove, VendorLicense toInstall) {
        if (toRemove.isEmpty()) {
            return false;
        }
        try {
            BIFile removeFile = toRemove.get(0).getFile();
            String removeFileName = removeFile.getFileName();
            VendorLicense[] vendorLicenseArray = new VendorLicense[]{toInstall};
            LicenseInfo[] toInstallInfo = LicenseInfo.make((VendorLicense[])vendorLicenseArray);
            boolean fileMatch = removeFileName.contentEquals(toInstallInfo[0].getInstalledFileName());
            boolean capChange = TextUtil.capitalize((String)removeFileName).contentEquals(toInstallInfo[0].getInstalledFileName());
            return !fileMatch && capChange;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void deleteExistingLicenseFile(List<LicenseInfo> toDelete, BNetworkStepDetails details, BDaemonSession daemonSession) throws Exception {
        if (toDelete == null || toDelete.isEmpty()) {
            return;
        }
        ArrayList<BDeleteFileInstallable> deleteInstallables = new ArrayList<BDeleteFileInstallable>();
        for (LicenseInfo existingLicense : toDelete) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Deleting license " + existingLicense.file.getAbsoluteOrd().toString(null));
            }
            details.message("provisioningNiagara", "UpdateLicensesJobStep.deletingLicense", new String[]{existingLicense.file.getFileName(), existingLicense.vendorLicense.getHostId()});
            deleteInstallables.add(new BDeleteFileInstallable(existingLicense.file));
        }
        Listener listener = new Listener(details);
        InstallScenario removeLicenseScenario = new InstallScenario((BDaemonPlatform)BRemoteDaemonPlatform.make((BDaemonSession)daemonSession, null, (boolean)false), (DaemonSessionTaskListener)listener, new String[0], new BDependency[0], (BInstallable[])deleteInstallables.toArray(new BDeleteFileInstallable[0]), (InstallableRegistry)LocalInstallableRegistry.getInstance(), CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(daemonSession))).solve();
        if (removeLicenseScenario.canCommit()) {
            removeLicenseScenario.commit((DaemonSessionTaskListener)listener, (ICancelHint)this);
        }
    }

    private void updateCertSummaries(BVector summaries, VendorCertificate cert) {
        String propName = SlotPath.escape((String)cert.getVendor());
        Property prop = summaries.getProperty(propName);
        if (prop == null) {
            summaries.add(propName, (BValue)BCertificateSummary.make((VendorCertificate)cert));
        } else {
            summaries.set(prop, (BValue)BCertificateSummary.make((VendorCertificate)cert));
        }
    }

    private BEnvLicenseSummary updateVendorsFromPortal(BEnvLicenseSummary licenses) throws Exception {
        List portalLicenses = PortalLicenseUtil.getExistingLicenses((String)licenses.getHostId(), (String)licenses.getBrandId(), null);
        for (LicenseModel lic : portalLicenses) {
            if (lic.getLicenseInfos().size() <= licenses.getVendors().length) continue;
            HashSet existingVendors = new HashSet();
            Collections.addAll(existingVendors, licenses.getVendors());
            for (LicenseInfo licInfo : lic.getLicenseInfos()) {
                if (existingVendors.contains(licInfo.vendorLicense.getVendor())) continue;
                licenses.updateVendorInfo(licInfo.vendorLicense);
            }
        }
        return licenses;
    }

    @Override
    public void installComplete(BDeviceStepDetails details, BInstallable installable, NiagaraNetworkJobOp op) {
        if (details.getState() == BJobState.success) {
            BNiagaraStation station = (BNiagaraStation)details.getDevice();
            BLicenseStationExt ext = (BLicenseStationExt)station.getMixIn(BLicenseStationExt.TYPE);
            BLicenseInstallable licInst = (BLicenseInstallable)installable;
            BEnvLicenseSummary[] licenseSummaries = licInst.getLicenseSummaries();
            if (licenseSummaries.length > 0) {
                ext.setLicenseSummary(licenseSummaries[0]);
            }
            ext.setCertificateSummaries(licInst.getCertificateSummaries());
            ext.setLastUpdate(BAbsTime.now());
            ext.setLicenseStatus(BLicenseStatus.upToDate);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        private final BNetworkStepDetails details;
        private String lastTaskMessage = null;

        public Listener(BNetworkStepDetails details) {
            this.details = details;
        }

        public void taskStarted(DaemonSessionTask task) {
            this.taskUpdated(task);
        }

        public void taskUpdated(DaemonSessionTask task) {
            if (!task.getMessage().equals(this.lastTaskMessage)) {
                this.details.message(task.getMessage());
                this.lastTaskMessage = task.getMessage();
            }
        }

        public void taskFinished(DaemonSessionTask task) {
            this.taskUpdated(task);
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

