/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import com.tridium.driverUpgrade.wizard.BUpgradeWizardStep;
import com.tridium.driverUpgrade.wizard.UpgradeWizardModel;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.platform.ui.util.BFileChooserPane;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.util.TimeFormat;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;

@NiagaraType
public class BChooseBackupFilenameStep
extends BUpgradeWizardStep
implements BFileChooserPane.Listener {
    @Generated
    public static final Type TYPE = Sys.loadType(BChooseBackupFilenameStep.class);
    protected BFileChooserPane newPathChooser;
    protected boolean loading = false;
    protected int mode = 1;
    protected static IFileFilter DISPLAY_FILTER = new IFileFilter(){

        public boolean accept(BIFile file) {
            return file != null && (file instanceof BDirectory || "dist".equals(file.getExtension()));
        }

        public String getDescription(Context cx) {
            return "";
        }
    };
    protected static IFilePathFilter SELECTION_FILTER = new IFilePathFilter(){

        public boolean accept(FilePath path) {
            return path.getName().endsWith(".dist");
        }
    };
    protected static IFileFilter DIST_FILE_FILTER = new IFileFilter(){

        public boolean accept(BIFile file) {
            return file != null && file instanceof BDistributionFile;
        }

        public String getDescription(Context cx) {
            return "";
        }
    };

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BChooseBackupFilenameStep() {
        super(null);
    }

    public BChooseBackupFilenameStep(UpgradeWizardModel wizardModel) {
        super(wizardModel);
    }

    @Override
    public String getSectionName() {
        return "backup";
    }

    @Override
    public String getStepName() {
        return "backup";
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void enter() {
        this.loading = true;
        try {
            String initialFilename;
            Object initialDir = null;
            FilePath initialPath = this.getWizardModel().backupPath;
            initialDir = initialPath == null ? FavoriteDirectory.loadByPath((String)"UpgradeWizard", (String)"backupPath", (FilePath)new FilePath("!backups")) : BFileSystem.INSTANCE.findFile(initialPath.getParent());
            if (initialPath == null) {
                String stationName = this.getWizardModel().getDirToUpgrade().getFileName().toString();
                String timestamp = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYMMDD_HHmm");
                initialFilename = "backup_" + stationName + "_" + timestamp + ".dist";
            } else {
                initialFilename = initialPath.getName();
            }
            this.newPathChooser = new BFileChooserPane(initialDir, DISPLAY_FILTER, null, SELECTION_FILTER, null, false, true, initialFilename);
            this.newPathChooser.addListener((BFileChooserPane.Listener)this);
            BIndentPane indent = new BIndentPane();
            indent.add(LEX.getText("UpgradeWizard.backup.chooseFile"));
            this.setContent((BWidget)new BEdgePane((BWidget)indent, null, null, null, (BWidget)this.newPathChooser));
            this.checkMode();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            this.loading = false;
        }
    }

    @Override
    public boolean exit(int direction) {
        this.getWizardModel().backupPath = this.newPathChooser.getSelectedFilePath();
        FavoriteDirectory.savePath((String)"UpgradeWizard", (String)"backupPath", (FilePath)this.getWizardModel().backupPath.getParent());
        return true;
    }

    public void fileSelected(boolean isValid) {
        if (isValid) {
            this.checkMode();
        } else {
            this.mode = 1;
            this.getWizardModel().update(this.mode);
        }
    }

    @Override
    public void checkMode() {
        this.mode = this.newPathChooser.getSelectedFilePath() == null ? 1 : (this.newPathChooser.getSelectedFilePath().getName().endsWith(".dist") ? 3 : 1);
        this.getWizardModel().update(this.mode);
    }
}

