/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk.impl;

import com.tridium.silk.impl.Soap11Envelope;
import javax.baja.silk.SoapEnvelope;
import javax.baja.silk.SoapFault;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;

public class Soap11Fault
extends Soap11Envelope
implements SoapFault {
    public static String CODE_VERSIONMISMATCH = "VersionMismatch";
    public static String CODE_MUSTUNDERSTAND = "MustUnderstand";
    public static String CODE_CLIENT = "Client";
    public static String CODE_SERVER = "Server";

    public Soap11Fault() {
        this.elemFault(true);
        this.elemCode(true);
        this.elemReason(true);
    }

    public Soap11Fault(String code, String subcode, String reason, XContent detail) {
        if (code == null) {
            throw new NullPointerException("Fault code can not be null.");
        }
        if (reason == null) {
            throw new NullPointerException("Fault reason can not be null.");
        }
        XNs ns = this.getEnvelopeNs();
        this.elemFault(true);
        String str = code;
        if (subcode != null) {
            str = str + '.' + subcode;
        }
        str = ns.prefix() + ':' + str;
        this.elemCode(true).addText(str);
        this.elemReason(true).addText(reason);
        if (detail != null) {
            this.elemDetail(true).addContent(detail);
        }
    }

    public Soap11Fault(XElem env) {
        super(env);
    }

    @Override
    public SoapFault asFault() {
        return this;
    }

    @Override
    public XElem getCode() {
        return this.elemCode(false);
    }

    @Override
    public XElem getDetail(boolean create) {
        return this.elemDetail(create);
    }

    @Override
    public SoapEnvelope getEnvelope() {
        return this;
    }

    @Override
    public XElem getFault() {
        return this.elemFault(false);
    }

    @Override
    public XElem getReason() {
        return this.elemReason(false);
    }

    @Override
    public XElem getRole(boolean create) {
        return this.elemRole(create);
    }

    @Override
    public boolean isMustUnderstand() {
        XElem e = this.elemCode(false);
        if (e == null) {
            return false;
        }
        String reason = e.string();
        if (reason == null) {
            return false;
        }
        return reason.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_VERSIONMISMATCH);
    }

    @Override
    public boolean isReceiver() {
        XElem e = this.elemCode(false);
        if (e == null) {
            return false;
        }
        String reason = e.string();
        if (reason == null) {
            return false;
        }
        return reason.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_SERVER);
    }

    @Override
    public boolean isSender() {
        XElem e = this.elemCode(false);
        if (e == null) {
            return false;
        }
        String reason = e.string();
        if (reason == null) {
            return false;
        }
        return reason.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_CLIENT);
    }

    @Override
    public boolean isVersionMismatch() {
        XElem e = this.elemCode(false);
        if (e == null) {
            return false;
        }
        String reason = e.string();
        if (reason == null) {
            return false;
        }
        return reason.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_VERSIONMISMATCH);
    }

    protected XElem elemCode(boolean create) {
        XElem fault = this.elemFault(create);
        if (fault == null) {
            return null;
        }
        XElem ret = fault.elem(this.getCodeTag());
        if (ret == null && create) {
            ret = new XElem(this.getCodeTag());
            fault.addContent((XContent)ret);
        }
        return ret;
    }

    protected XElem elemDetail(boolean create) {
        XElem fault = this.elemFault(create);
        if (fault == null) {
            return null;
        }
        XElem ret = fault.elem(this.getDetailTag());
        if (ret == null && create) {
            ret = new XElem(this.getDetailTag());
            fault.addContent((XContent)ret);
        }
        return ret;
    }

    protected XElem elemReason(boolean create) {
        XElem fault = this.elemFault(create);
        if (fault == null) {
            return null;
        }
        XElem ret = fault.elem(this.getReasonTag());
        if (ret == null && create) {
            ret = new XElem(this.getReasonTag());
            fault.addContent((XContent)ret);
        }
        return ret;
    }

    protected XElem elemRole(boolean create) {
        XElem fault = this.elemFault(create);
        if (fault == null) {
            return null;
        }
        XElem ret = fault.elem(this.getRoleTag());
        if (ret == null && create) {
            ret = new XElem(this.getRoleTag());
            fault.addContent((XContent)ret);
        }
        return ret;
    }

    public String getCodeTag() {
        return "faultcode";
    }

    public String getDetailTag() {
        return "detail";
    }

    public String getReasonTag() {
        return "faultstring";
    }

    public String getRoleTag() {
        return "faultactor";
    }
}

