/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk.impl;

import com.tridium.silk.impl.Soap12Envelope;
import javax.baja.silk.SoapEnvelope;
import javax.baja.silk.SoapFault;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;

public class Soap12Fault
extends Soap12Envelope
implements SoapFault {
    public static String CODE_VERSIONMISMATCH = "VersionMismatch";
    public static String CODE_MUSTUNDERSTAND = "MustUnderstand";
    public static String CODE_SENDER = "Sender";
    public static String CODE_RECEIVER = "Receiver";

    public Soap12Fault() {
        this.elemFault(true);
        this.elemCode(true);
        this.elemReason(true);
    }

    public Soap12Fault(String code, String subcode, String reason, XContent detail) {
        if (code == null) {
            throw new NullPointerException("Fault code can not be null.");
        }
        if (reason == null) {
            throw new NullPointerException("Fault reason can not be null.");
        }
        XNs ns = this.getEnvelopeNs();
        this.elemFault(true);
        XElem value = new XElem(ns, this.getCodeValueTag());
        value.addText(ns.prefix() + ':' + code);
        this.elemCode(true).addContent((XContent)value);
        if (subcode != null) {
            this.addSubcode(subcode);
        }
        this.addReason(reason);
        if (detail != null) {
            this.elemDetail(true).addContent(detail);
        }
    }

    public Soap12Fault(XElem env) {
        super(env);
    }

    public void addSubcode(String subcode) {
        XElem parent = this.elemCode(true);
        XElem scode = parent.elem(this.getSubcodeTag());
        while (scode != null) {
            parent = scode;
            scode = parent.elem(this.getSubcodeTag());
        }
        scode = new XElem(this.getEnvelopeNs(), this.getSubcodeTag());
        XElem value = new XElem(this.getEnvelopeNs(), this.getCodeValueTag());
        value.addText(subcode);
        parent.addContent((XContent)scode);
    }

    public void addReason(String reason) {
        this.addReason(reason, "en-US");
    }

    public void addReason(String reason, String lang) {
        XElem text = new XElem(this.getEnvelopeNs(), this.getReasonTextTag());
        text.addAttr(this.getTextLangTag(), lang);
        text.addText(reason);
        this.elemReason(true).addContent((XContent)text);
    }

    @Override
    public SoapFault asFault() {
        return this;
    }

    @Override
    public XElem getCode() {
        return this.elemCode(false);
    }

    @Override
    public XElem getDetail(boolean create) {
        return this.elemDetail(create);
    }

    @Override
    public SoapEnvelope getEnvelope() {
        return this;
    }

    @Override
    public XElem getFault() {
        return this.elemFault(false);
    }

    @Override
    public XElem getReason() {
        return this.elemReason(false);
    }

    @Override
    public XElem getRole(boolean create) {
        return this.elemRole(create);
    }

    @Override
    public boolean isMustUnderstand() {
        XElem code = this.elemCode(false);
        if (code == null) {
            return false;
        }
        XElem value = code.elem(this.getCodeValueTag());
        if (value == null) {
            return false;
        }
        String reason = value.string();
        if (reason == null) {
            return false;
        }
        return reason.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_MUSTUNDERSTAND);
    }

    @Override
    public boolean isReceiver() {
        XElem code = this.elemCode(false);
        if (code == null) {
            return false;
        }
        XElem value = code.elem(this.getCodeValueTag());
        if (value == null) {
            return false;
        }
        String reason = value.string();
        if (reason == null) {
            return false;
        }
        return reason.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_RECEIVER);
    }

    @Override
    public boolean isSender() {
        XElem code = this.elemCode(false);
        if (code == null) {
            return false;
        }
        XElem value = code.elem(this.getCodeValueTag());
        if (value == null) {
            return false;
        }
        String reason = value.string();
        if (reason == null) {
            return false;
        }
        return reason.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_SENDER);
    }

    @Override
    public boolean isVersionMismatch() {
        XElem code = this.elemCode(false);
        if (code == null) {
            return false;
        }
        XElem value = code.elem(this.getCodeValueTag());
        if (value == null) {
            return false;
        }
        String reason = value.string();
        if (reason == null) {
            return false;
        }
        return reason.trim().startsWith(this.envelope.ns().prefix() + ':' + CODE_VERSIONMISMATCH);
    }

    protected XElem elemCode(boolean create) {
        XElem fault = this.elemFault(create);
        if (fault == null) {
            return null;
        }
        XElem ret = fault.elem(this.getCodeTag());
        if (ret == null && create) {
            ret = new XElem(this.getCodeTag());
            fault.addContent((XContent)ret);
        }
        return ret;
    }

    protected XElem elemDetail(boolean create) {
        XElem fault = this.elemFault(create);
        if (fault == null) {
            return null;
        }
        XElem ret = fault.elem(this.getDetailTag());
        if (ret == null && create) {
            ret = new XElem(this.getDetailTag());
            fault.addContent((XContent)ret);
        }
        return ret;
    }

    protected XElem elemReason(boolean create) {
        XElem fault = this.elemFault(create);
        if (fault == null) {
            return null;
        }
        XElem ret = fault.elem(this.getReasonTag());
        if (ret == null && create) {
            ret = new XElem(this.getReasonTag());
            fault.addContent((XContent)ret);
        }
        return ret;
    }

    protected XElem elemRole(boolean create) {
        XElem fault = this.elemFault(create);
        if (fault == null) {
            return null;
        }
        XElem ret = fault.elem(this.getRoleTag());
        if (ret == null && create) {
            ret = new XElem(this.getRoleTag());
            fault.addContent((XContent)ret);
        }
        return ret;
    }

    public String getCodeTag() {
        return "Code";
    }

    public String getCodeValueTag() {
        return "Value";
    }

    public String getDetailTag() {
        return "Detail";
    }

    public String getReasonTag() {
        return "Reason";
    }

    public String getReasonTextTag() {
        return "Text";
    }

    public String getRoleTag() {
        return "Role";
    }

    public String getSubcodeTag() {
        return "Subcode";
    }

    public String getTextLangTag() {
        return "xml:lang";
    }
}

