/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program;

import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"nss:SecurityService"})})
public class BProgramObjectsSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BProgramObjectsSecurityDashboardProviderAgent.class);
    private static final String SIGNING_NOT_REQUIRED_SUMMARY = "securityDashboard.programObjects.signingNotRequired.summary";
    private static final String SIGNING_REQUIRED_SUMMARY = "securityDashboard.programObjects.signingRequired.summary";
    private static final String SIGNING_DESCRIPTION = "securityDashboard.programObjects.signing.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.programObjects.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return null;
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        SecurityDashboardItemBuilder builder = new SecurityDashboardItemBuilder((BIObject)this);
        boolean signingRequired = AccessController.doPrivileged(() -> Boolean.getBoolean("program.requireSigning"));
        if (signingRequired) {
            return Collections.singletonList(builder.makeOk(SIGNING_REQUIRED_SUMMARY, SIGNING_DESCRIPTION));
        }
        return Collections.singletonList(builder.makeWarning(SIGNING_NOT_REQUIRED_SUMMARY, SIGNING_DESCRIPTION));
    }
}

