/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml;

import com.tridium.saml.BAuthnContextClassRefType;
import com.tridium.saml.BSAMLAuthenticationSchemeRankInfo;
import com.tridium.saml.SAMLAuthnRequestException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.authnScheme.BRequestedAuthenticationTypeComparisonMode;
import com.tridium.saml.rp.AuthnRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"baja:AuthenticationScheme"})})
@NiagaraProperties(value={@NiagaraProperty(name="withTls", type="BSAMLAuthenticationSchemeRankInfo", defaultValue="new BSAMLAuthenticationSchemeRankInfo()"), @NiagaraProperty(name="withoutTls", type="BSAMLAuthenticationSchemeRankInfo", defaultValue="new BSAMLAuthenticationSchemeRankInfo()")})
public class BSAMLAuthenticationSchemeRankMixIn
extends BComponent
implements BIMixIn {
    @Generated
    public static final Property withTls = BSAMLAuthenticationSchemeRankMixIn.newProperty((int)0, (BValue)new BSAMLAuthenticationSchemeRankInfo(), null);
    @Generated
    public static final Property withoutTls = BSAMLAuthenticationSchemeRankMixIn.newProperty((int)0, (BValue)new BSAMLAuthenticationSchemeRankInfo(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSAMLAuthenticationSchemeRankMixIn.class);
    private static final LexiconModule SAML_LEX = LexiconModule.make((String)"saml");
    private static final String GAUTH_SCHEME_TYPE = "gauth:GoogleAuthenticationScheme";
    private static final String KERBEROS_SCHEME_TYPE = "ldap:KerberosAuthenticationScheme";
    private static final String CLIENT_CERT_AUTH_SCHEME_TYPE = "clientCertAuth:ClientCertAuthScheme";
    private static final String DIGEST_AUTH_SCHEME_TYPE = "baja:DigestAuthenticationScheme";
    private static final String LEGACY_DIGEST_AUTH_SCHEME_TYPE = "baja:LegacyDigestAuthenticationScheme";
    private static final String LDAP_SCHEME_TYPE = "ldap:LdapAuthenticationScheme";
    private static final BSAMLAuthenticationSchemeRankInfo GAUTH_MAPPING_WITHTLS = new BSAMLAuthenticationSchemeRankInfo("gauth:GoogleAuthenticationScheme", true, "TimeSyncToken", 1);
    private static final BSAMLAuthenticationSchemeRankInfo GAUTH_MAPPING_WITHOUTTLS = new BSAMLAuthenticationSchemeRankInfo("gauth:GoogleAuthenticationScheme", false, "TimeSyncToken", 1);
    private static final BSAMLAuthenticationSchemeRankInfo KERBEROS_MAPPING_WITHTLS = new BSAMLAuthenticationSchemeRankInfo("ldap:KerberosAuthenticationScheme", true, "Kerberos", 2);
    private static final BSAMLAuthenticationSchemeRankInfo KERBEROS_MAPPING_WITHOUTTLS = new BSAMLAuthenticationSchemeRankInfo("ldap:KerberosAuthenticationScheme", false, "Kerberos", 2);
    private static final BSAMLAuthenticationSchemeRankInfo CLIENTCERT_AUTH_MAPPING_WITHTLS = new BSAMLAuthenticationSchemeRankInfo("clientCertAuth:ClientCertAuthScheme", true, "TLSClient", 2);
    private static final BSAMLAuthenticationSchemeRankInfo CLIENTCERT_AUTH_MAPPING_WITHOUTTLS = new BSAMLAuthenticationSchemeRankInfo("clientCertAuth:ClientCertAuthScheme", false, "TLSClient", 2);
    private static final BSAMLAuthenticationSchemeRankInfo DIGEST_AUTH_PASSWORD_PROTECTED_TRANSPORT_MAPPING = new BSAMLAuthenticationSchemeRankInfo("baja:DigestAuthenticationScheme", true, "PasswordProtectedTransport", 3);
    private static final BSAMLAuthenticationSchemeRankInfo DIGEST_AUTH_PASSWORD_MAPPING = new BSAMLAuthenticationSchemeRankInfo("baja:DigestAuthenticationScheme", false, "Password", 4);
    private static final BSAMLAuthenticationSchemeRankInfo LEGACY_DIGEST_AUTH_PASSWORD_PROTECTED_TRANSPORT_MAPPING = new BSAMLAuthenticationSchemeRankInfo("baja:LegacyDigestAuthenticationScheme", true, "PasswordProtectedTransport", 3);
    private static final BSAMLAuthenticationSchemeRankInfo LEGACY_DIGEST_AUTH_PASSWORD_MAPPING = new BSAMLAuthenticationSchemeRankInfo("baja:LegacyDigestAuthenticationScheme", false, "Password", 4);
    private static final BSAMLAuthenticationSchemeRankInfo LDAP_PASSWORD_PROTECTED_TRANSPORT_MAPPING = new BSAMLAuthenticationSchemeRankInfo("ldap:LdapAuthenticationScheme", true, "PasswordProtectedTransport", 4);
    private static final BSAMLAuthenticationSchemeRankInfo LDAP_PASSWORD_MAPPING = new BSAMLAuthenticationSchemeRankInfo("ldap:LdapAuthenticationScheme", false, "Password", 5);
    static final BasicContext INIT_RANK_SET_CX = new BasicContext();
    private static final Object AUTH_SCHEME_RANKINGS_LOCK = new Object();
    private static final List<BSAMLAuthenticationSchemeRankInfo> authSchemeRankings = BSAMLAuthenticationSchemeRankMixIn.defaultRankingList();

    @Generated
    public BSAMLAuthenticationSchemeRankInfo getWithTls() {
        return (BSAMLAuthenticationSchemeRankInfo)this.get(withTls);
    }

    @Generated
    public void setWithTls(BSAMLAuthenticationSchemeRankInfo v) {
        this.set(withTls, (BValue)v, null);
    }

    @Generated
    public BSAMLAuthenticationSchemeRankInfo getWithoutTls() {
        return (BSAMLAuthenticationSchemeRankInfo)this.get(withoutTls);
    }

    @Generated
    public void setWithoutTls(BSAMLAuthenticationSchemeRankInfo v) {
        this.set(withoutTls, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void stationStarted() throws Exception {
        this.init();
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.init();
        }
    }

    public String getDisplayNameInParent(Context cx) {
        return SAML_LEX.getText("samlAuthenticationSchemeRank", cx);
    }

    public static boolean schemeRankMeetsRequirements(BSAMLAuthenticationSchemeRankInfo schemeRankInfo, AuthnRequest authnRequest) throws SAMLException {
        Objects.requireNonNull(schemeRankInfo, "parameter 'schemeRankInfo' must not be null");
        Objects.requireNonNull(authnRequest, "parameter 'authnRequest' must not be null");
        BRequestedAuthenticationTypeComparisonMode comparisonMode = authnRequest.getComparisonMode();
        if (comparisonMode == null) {
            return true;
        }
        switch (comparisonMode.getOrdinal()) {
            case 1: {
                return BSAMLAuthenticationSchemeRankMixIn.meetsExactRequirements(schemeRankInfo, authnRequest.getRequestedAuthnContextClassRefs());
            }
            case 2: {
                return BSAMLAuthenticationSchemeRankMixIn.meetsMinimumRequirements(schemeRankInfo, authnRequest.getRequestedAuthnContextClassRefs());
            }
            case 3: {
                return BSAMLAuthenticationSchemeRankMixIn.meetsBetterRequirements(schemeRankInfo, authnRequest.getRequestedAuthnContextClassRefs());
            }
            case 4: {
                throw new SAMLAuthnRequestException("Unsupported Comparison mode 'maximum'");
            }
        }
        throw new SAMLAuthnRequestException("Unknown Comparison mode '" + (Object)((Object)authnRequest.getComparisonMode()) + '\'');
    }

    private static boolean meetsExactRequirements(BSAMLAuthenticationSchemeRankInfo actualSchemeRankInfo, Set<String> requestedAuthnRefs) {
        return requestedAuthnRefs.contains("urn:oasis:names:tc:SAML:2.0:ac:classes:" + actualSchemeRankInfo.getAuthnContextClassRef()) || requestedAuthnRefs.contains(BAuthnContextClassRefType.unspecified.getAuthnContextClassRefSamlString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean meetsMinimumRequirements(BSAMLAuthenticationSchemeRankInfo actualSchemeRankInfo, Set<String> requestedAuthnRefs) {
        if (requestedAuthnRefs.contains("urn:oasis:names:tc:SAML:2.0:ac:classes:" + actualSchemeRankInfo.getAuthnContextClassRef()) || requestedAuthnRefs.contains(BAuthnContextClassRefType.unspecified.getAuthnContextClassRefSamlString())) {
            return true;
        }
        Object object = AUTH_SCHEME_RANKINGS_LOCK;
        synchronized (object) {
            for (int i = authSchemeRankings.size() - 1; i >= 0; --i) {
                BSAMLAuthenticationSchemeRankInfo schemeRankInfo = authSchemeRankings.get(i);
                if (!requestedAuthnRefs.contains("urn:oasis:names:tc:SAML:2.0:ac:classes:" + schemeRankInfo.getAuthnContextClassRef()) || actualSchemeRankInfo.getRank() > schemeRankInfo.getRank()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean meetsBetterRequirements(BSAMLAuthenticationSchemeRankInfo actualSchemeRankInfo, Set<String> requestedAuthnRefs) {
        Object object = AUTH_SCHEME_RANKINGS_LOCK;
        synchronized (object) {
            for (int i = authSchemeRankings.size() - 1; i >= 0; --i) {
                BSAMLAuthenticationSchemeRankInfo schemeRankInfo = authSchemeRankings.get(i);
                if (!requestedAuthnRefs.contains("urn:oasis:names:tc:SAML:2.0:ac:classes:" + schemeRankInfo.getAuthnContextClassRef()) || actualSchemeRankInfo.getRank() >= schemeRankInfo.getRank()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateAuthenticationSchemeRankList(BSAMLAuthenticationSchemeRankInfo newSchemeRankInfo) {
        Object object = AUTH_SCHEME_RANKINGS_LOCK;
        synchronized (object) {
            for (BSAMLAuthenticationSchemeRankInfo schemeRankInfo : authSchemeRankings) {
                if (!schemeRankInfo.matches(newSchemeRankInfo)) continue;
                BSAMLAuthenticationSchemeRankMixIn.removeAuthenticationSchemeRankInfo(newSchemeRankInfo);
                break;
            }
            BSAMLAuthenticationSchemeRankMixIn.insertAuthenticationSchemeRankInfo(newSchemeRankInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertAuthenticationSchemeRankInfo(BSAMLAuthenticationSchemeRankInfo schemeRankInfo) {
        Object object = AUTH_SCHEME_RANKINGS_LOCK;
        synchronized (object) {
            for (int i = 0; i < authSchemeRankings.size(); ++i) {
                if (authSchemeRankings.get(i).getRank() <= schemeRankInfo.getRank()) continue;
                authSchemeRankings.add(i, schemeRankInfo);
                BSAMLAuthenticationSchemeRankMixIn.removeDefaultRanking(schemeRankInfo);
                return;
            }
            authSchemeRankings.add(schemeRankInfo);
            BSAMLAuthenticationSchemeRankMixIn.removeDefaultRanking(schemeRankInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeAuthenticationSchemeRankInfo(BSAMLAuthenticationSchemeRankInfo schemeRankInfoToRemove) {
        Object object = AUTH_SCHEME_RANKINGS_LOCK;
        synchronized (object) {
            for (BSAMLAuthenticationSchemeRankInfo schemeRankInfo : authSchemeRankings) {
                if (schemeRankInfo != schemeRankInfoToRemove) continue;
                authSchemeRankings.remove((Object)schemeRankInfo);
                BSAMLAuthenticationSchemeRankMixIn.addDefaultRanking(schemeRankInfo);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDefaultRanking(BSAMLAuthenticationSchemeRankInfo schemeRankInfoToMatch) {
        if (schemeRankInfoToMatch.isDefaultRanking()) {
            return;
        }
        Object object = AUTH_SCHEME_RANKINGS_LOCK;
        synchronized (object) {
            authSchemeRankings.removeIf(schemeRankInfo -> schemeRankInfo.isDefaultRanking() && schemeRankInfo.getAuthSchemeType().equals(schemeRankInfoToMatch.getAuthSchemeType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDefaultRanking(BSAMLAuthenticationSchemeRankInfo baseSchemeRankInfo) {
        Object object = AUTH_SCHEME_RANKINGS_LOCK;
        synchronized (object) {
            for (BSAMLAuthenticationSchemeRankInfo schemeRankInfo : authSchemeRankings) {
                if (!schemeRankInfo.matches(baseSchemeRankInfo)) continue;
                return;
            }
            BSAMLAuthenticationSchemeRankMixIn.insertAuthenticationSchemeRankInfo(BSAMLAuthenticationSchemeRankMixIn.getDefaultRankInfo(baseSchemeRankInfo.getAuthSchemeType(), baseSchemeRankInfo.getIsTlsRequired()));
        }
    }

    private void init() {
        String authenticationSchemeType = null;
        if (this.getParent() instanceof BAuthenticationScheme) {
            authenticationSchemeType = this.getParent().getType().toString();
        }
        if (this.getWithTls().getAuthnContextClassRef().isEmpty()) {
            BSAMLAuthenticationSchemeRankInfo objWithTls = BSAMLAuthenticationSchemeRankMixIn.getDefaultRankInfo(authenticationSchemeType, true);
            this.set(withTls, (BValue)objWithTls, (Context)INIT_RANK_SET_CX);
        }
        if (this.getWithoutTls().getAuthnContextClassRef().isEmpty()) {
            BSAMLAuthenticationSchemeRankInfo objWithoutTls = BSAMLAuthenticationSchemeRankMixIn.getDefaultRankInfo(authenticationSchemeType, false);
            this.set(withoutTls, (BValue)objWithoutTls, (Context)INIT_RANK_SET_CX);
        }
        this.getWithTls().setDefaultRanking(false);
        this.getWithoutTls().setDefaultRanking(false);
        BSAMLAuthenticationSchemeRankMixIn.insertAuthenticationSchemeRankInfo(this.getWithTls());
        BSAMLAuthenticationSchemeRankMixIn.insertAuthenticationSchemeRankInfo(this.getWithoutTls());
    }

    private static List<BSAMLAuthenticationSchemeRankInfo> defaultRankingList() {
        List<BSAMLAuthenticationSchemeRankInfo> authSchemeRankings = Collections.synchronizedList(new ArrayList());
        authSchemeRankings.add(GAUTH_MAPPING_WITHTLS);
        authSchemeRankings.add(GAUTH_MAPPING_WITHOUTTLS);
        authSchemeRankings.add(CLIENTCERT_AUTH_MAPPING_WITHTLS);
        authSchemeRankings.add(CLIENTCERT_AUTH_MAPPING_WITHOUTTLS);
        authSchemeRankings.add(KERBEROS_MAPPING_WITHTLS);
        authSchemeRankings.add(KERBEROS_MAPPING_WITHOUTTLS);
        authSchemeRankings.add(DIGEST_AUTH_PASSWORD_PROTECTED_TRANSPORT_MAPPING);
        authSchemeRankings.add(DIGEST_AUTH_PASSWORD_MAPPING);
        authSchemeRankings.add(LEGACY_DIGEST_AUTH_PASSWORD_PROTECTED_TRANSPORT_MAPPING);
        authSchemeRankings.add(LEGACY_DIGEST_AUTH_PASSWORD_MAPPING);
        authSchemeRankings.add(LDAP_PASSWORD_PROTECTED_TRANSPORT_MAPPING);
        authSchemeRankings.add(LDAP_PASSWORD_MAPPING);
        return authSchemeRankings;
    }

    private static BSAMLAuthenticationSchemeRankInfo getDefaultRankInfo(String authenticationScheme, boolean isTLSRequired) {
        BSAMLAuthenticationSchemeRankInfo schemeRankInfo;
        switch (authenticationScheme) {
            case "gauth:GoogleAuthenticationScheme": {
                schemeRankInfo = isTLSRequired ? GAUTH_MAPPING_WITHTLS : GAUTH_MAPPING_WITHOUTTLS;
                break;
            }
            case "clientCertAuth:ClientCertAuthScheme": {
                schemeRankInfo = isTLSRequired ? CLIENTCERT_AUTH_MAPPING_WITHTLS : CLIENTCERT_AUTH_MAPPING_WITHOUTTLS;
                break;
            }
            case "ldap:KerberosAuthenticationScheme": {
                schemeRankInfo = isTLSRequired ? KERBEROS_MAPPING_WITHTLS : KERBEROS_MAPPING_WITHOUTTLS;
                break;
            }
            case "baja:DigestAuthenticationScheme": {
                schemeRankInfo = isTLSRequired ? DIGEST_AUTH_PASSWORD_PROTECTED_TRANSPORT_MAPPING : DIGEST_AUTH_PASSWORD_MAPPING;
                break;
            }
            case "baja:LegacyDigestAuthenticationScheme": {
                schemeRankInfo = isTLSRequired ? LEGACY_DIGEST_AUTH_PASSWORD_PROTECTED_TRANSPORT_MAPPING : LEGACY_DIGEST_AUTH_PASSWORD_MAPPING;
                break;
            }
            case "ldap:LdapAuthenticationScheme": {
                schemeRankInfo = isTLSRequired ? LDAP_PASSWORD_PROTECTED_TRANSPORT_MAPPING : LDAP_PASSWORD_MAPPING;
                break;
            }
            default: {
                return BSAMLAuthenticationSchemeRankMixIn.getUnknownSchemeRankInfo(authenticationScheme, isTLSRequired);
            }
        }
        schemeRankInfo = (BSAMLAuthenticationSchemeRankInfo)schemeRankInfo.newCopy();
        schemeRankInfo.setFlags((Slot)BSAMLAuthenticationSchemeRankInfo.authnContextClassRef, schemeRankInfo.getFlags((Slot)BSAMLAuthenticationSchemeRankInfo.authnContextClassRef) | 1);
        return schemeRankInfo;
    }

    private static BSAMLAuthenticationSchemeRankInfo getUnknownSchemeRankInfo(String authSchemeType, boolean tlsRequired) {
        return new BSAMLAuthenticationSchemeRankInfo(authSchemeType, tlsRequired, "unspecified", 5);
    }
}

