/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.authnScheme;

import com.tridium.saml.authnScheme.SAMLCallback;
import com.tridium.saml.rp.servlet.SAMLAuthenticationInfo;
import com.tridium.saml.rp.servlet.SAMLAuthenticationInfoHandler;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.security.AccessController;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"saml:SAMLAuthenticationScheme"})})
public class BWebSAMLCallbackHandler
extends BWebCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BWebSAMLCallbackHandler.class);
    private SAMLAuthenticationInfo authenticationInfo = null;
    private String username = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public int handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestedSessionId = WebSessionUtil.getId((String)req.getRequestedSessionId());
        SAMLAuthenticationInfo authenticationInfo = SAMLAuthenticationInfoHandler.getAuthenticationInfo(requestedSessionId);
        if (authenticationInfo != null) {
            this.authenticationInfo = authenticationInfo;
            AccessController.doPrivileged(() -> {
                SAMLAuthenticationInfoHandler.removeAuthenticationInfo(requestedSessionId);
                return null;
            });
            this.username = authenticationInfo.getUsername();
            return 0;
        }
        resp.sendRedirect("saml/samlrp/");
        return 1;
    }

    public String getUsername() {
        return this.username;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof SAMLCallback)) {
                throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
            }
            ((SAMLCallback)callback).setAuthenticationInfo(this.authenticationInfo);
        }
    }
}

