/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.rp;

import com.onelogin.saml.Utils;
import com.tridium.saml.SAMLConfigurationException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLLoginException;
import com.tridium.saml.SAMLResponseException;
import com.tridium.saml.authnScheme.BISamlXmlDecrypter;
import com.tridium.saml.authnScheme.BSAMLAuthenticationScheme;
import com.tridium.saml.rp.servlet.SAMLUuidMap;
import com.tridium.saml.utils.SAMLUtils;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.util.Lexicon;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Response {
    private final String entityId;
    private final String assertionConsumerServiceUri;
    private Document document;
    private Document decryptedDocument;
    private BSAMLAuthenticationScheme samlScheme;
    private boolean encrypted = false;
    private String audienceURL = null;
    private static DatatypeFactory datatypeFactory;

    public Response(HttpServletRequest request, String response) throws SAMLException {
        this.loadXmlFromBase64(response);
        this.entityId = SAMLUtils.getEntityId(this.samlScheme, request);
        this.assertionConsumerServiceUri = SAMLUtils.getAssertionConsumerURL(this.entityId);
    }

    private void loadXmlFromBase64(String responseString) throws SAMLException {
        block13: {
            this.document = Utils.loadXML(responseString);
            if (this.document == null) {
                throw new SAMLException(Lexicon.make((String)"saml").get("saml.exception.couldNotProcess"));
            }
            String inResponseToAttr = this.document.getDocumentElement().getAttribute("InResponseTo").substring(1);
            UUID inResponseTo = UUID.fromString(inResponseToAttr);
            this.samlScheme = AccessController.doPrivileged(() -> SAMLUuidMap.IN_RESPONSE_TO_SCHEME_MAP.get(inResponseTo));
            if (this.samlScheme == null) {
                throw new SAMLException(Lexicon.make((String)"saml").get("saml.exception.noSSOScheme"));
            }
            NodeList encryptedAssertionNodes = this.document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
            if (encryptedAssertionNodes.getLength() != 0) {
                if (encryptedAssertionNodes.getLength() > 1) {
                    SAMLUtils.log(Level.WARNING, "encryptedAssertionNodes.length = " + encryptedAssertionNodes.getLength());
                    SAMLUtils.log(Level.WARNING, "encryptedAssertionNodes.length > 1 not supported");
                } else if (SAMLUtils.isLoggable(Level.FINEST)) {
                    SAMLUtils.log(Level.FINEST, "encryptedAssertionNodes.length = " + encryptedAssertionNodes.getLength());
                }
                try {
                    BISamlXmlDecrypter[] decrypters = (BISamlXmlDecrypter[])this.samlScheme.getChildren(BISamlXmlDecrypter.class);
                    if (decrypters == null || decrypters.length == 0) {
                        throw new SAMLConfigurationException(Lexicon.make((String)"saml").getText("saml.exception.noDecrypter", new Object[]{this.samlScheme.getName()}));
                    }
                    this.decryptedDocument = Utils.copyDocument(this.document);
                    this.encrypted = true;
                    this.decryptedDocument = decrypters[0].decryptAssertion(this.decryptedDocument);
                    if (!SAMLUtils.isLoggable(Level.FINEST)) break block13;
                    try {
                        TransformerFactory transfac = TransformerFactory.newInstance();
                        transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                        transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                        transfac.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        Transformer trans = transfac.newTransformer();
                        trans.setOutputProperty("omit-xml-declaration", "yes");
                        trans.setOutputProperty("indent", "yes");
                        StringWriter sw = new StringWriter();
                        StreamResult result = new StreamResult(sw);
                        DOMSource source = new DOMSource(this.decryptedDocument);
                        trans.transform(source, result);
                        String xmlString = sw.toString();
                        if (SAMLUtils.isLoggable(Level.FINEST)) {
                            SAMLUtils.log(Level.FINEST, "decryptedDocument:\n" + xmlString);
                        }
                    }
                    catch (TransformerException e) {
                        if (SAMLUtils.isLoggable(Level.FINEST)) {
                            SAMLUtils.log(Level.FINEST, "unable to read document content", e);
                        }
                    }
                }
                catch (ParserConfigurationException e) {
                    throw new SAMLException(Lexicon.make((String)"saml").get("saml.exception.couldNotCopyDocument"));
                }
            }
        }
    }

    public BSAMLAuthenticationScheme getSsoScheme() {
        return this.samlScheme;
    }

    public void checkValidity(String requestId) throws SAMLException {
        Element rootElement = this.document.getDocumentElement();
        rootElement.normalize();
        this.initDatatypeFactory();
        if (!"2.0".equals(rootElement.getAttribute("Version"))) {
            throw new SAMLConfigurationException(Lexicon.make((String)"saml").getText("saml.exception.samlVersion", new Object[]{"Version"}));
        }
        if (!rootElement.hasAttribute("ID")) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.noId"));
        }
        this.validateStatus();
        this.validateNumAssertions();
        this.validateSignatures();
        try {
            Utils.validateXML(this.document, "saml-schema-protocol-2.0.xsd");
        }
        catch (Throwable t) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.schema"), t);
        }
        try {
            if (this.encrypted) {
                Utils.validateXML(this.decryptedDocument, "saml-schema-protocol-2.0.xsd");
            }
        }
        catch (Exception e) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.schema.decrypted"), e);
        }
        if (rootElement.hasAttribute("InResponseTo")) {
            String inResponseToAttr = this.document.getDocumentElement().getAttribute("InResponseTo");
            if (requestId != null && !inResponseToAttr.equals(requestId)) {
                throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.inResponseTo"));
            }
        }
        this.validateTimestamps();
        NodeList encryptedAttributeNodes = this.queryAssertion("/saml:AttributeStatement/saml:EncryptedAttribute");
        if (encryptedAttributeNodes.getLength() > 0) {
            throw new SAMLException(Lexicon.make((String)"saml").get("saml.exception.encryptedAttribute"));
        }
        this.validateAudiences();
        this.validateDestination(rootElement);
        Set<String> issuers = this.getIssuers();
        for (String issuer : issuers) {
            if (!issuer.isEmpty()) continue;
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.issuer"));
        }
        this.validateSessionExpiration();
        this.validateSubjectConfirmation();
    }

    private void initDatatypeFactory() throws SAMLException {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new SAMLException(Lexicon.make((String)"saml").get("saml.exception.datatypeFactory"));
            }
        }
    }

    private Document getDocument() {
        if (this.encrypted) {
            return this.decryptedDocument;
        }
        return this.document;
    }

    private void validateStatus() throws SAMLException {
        Map<String, String> statusMap = Utils.getStatus(this.document);
        if (statusMap.containsKey("code") && !"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusMap.get("code"))) {
            throw new SAMLLoginException(String.format("Non-success status code: %s%s; ", statusMap.get("code"), statusMap.containsKey("msg") ? ". Cause is: " + statusMap.get("msg") : ""));
        }
    }

    private void validateNumAssertions() throws SAMLException {
        NodeList decryptedAssertionNodes;
        NodeList encryptedAssertionNodes = this.document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
        NodeList assertionNodes = this.document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (encryptedAssertionNodes.getLength() + assertionNodes.getLength() != 1) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").getText("saml.exception.numAssertions", new Object[]{assertionNodes.getLength(), encryptedAssertionNodes.getLength()}));
        }
        if (this.encrypted && (decryptedAssertionNodes = this.decryptedDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion")).getLength() != 1) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").getText("saml.exception.numAssertions.encrypted", new Object[]{decryptedAssertionNodes.getLength()}));
        }
    }

    private void validateSignatures() throws SAMLException {
        X509Certificate cert;
        int assertionCount;
        NodeList assertionSignatures;
        NodeList responseSignatures;
        String responseSignatureQuery = "/samlp:Response/ds:Signature";
        String assertionSignatureQuery = "/samlp:Response/saml:Assertion/ds:Signature";
        try {
            responseSignatures = Utils.query(this.document, responseSignatureQuery, null);
            assertionSignatures = Utils.query(this.getDocument(), assertionSignatureQuery, null);
        }
        catch (XPathExpressionException e) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.queryFailure"), e);
        }
        int responseCount = responseSignatures == null ? 0 : responseSignatures.getLength();
        int n = assertionCount = assertionSignatures == null ? 0 : assertionSignatures.getLength();
        if (assertionCount > 1 || responseCount > 1) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").getText("saml.exception.unexpectedSignature", new Object[]{assertionCount, responseCount}));
        }
        if (responseCount == 0 && assertionCount == 0) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.noSignature"));
        }
        try {
            String idpCertName = this.samlScheme.getIdpCert();
            cert = CertManagerFactory.getInstance().getUserTrustStore().getCertificate(idpCertName);
        }
        catch (Exception e) {
            throw new SAMLConfigurationException(Lexicon.make((String)"saml").get("saml.exception.idpCert"), e);
        }
        if (cert == null) {
            throw new SAMLConfigurationException(Lexicon.make((String)"saml").get("saml.exception.idpCert"));
        }
        try {
            if (responseCount > 0 && !Utils.validateSign(responseSignatures.item(0), cert)) {
                throw new SAMLConfigurationException(Lexicon.make((String)"saml").get("saml.exception.invalidSignature"));
            }
            if (assertionCount > 0 && !Utils.validateSign(assertionSignatures.item(0), cert)) {
                throw new SAMLConfigurationException(Lexicon.make((String)"saml").get("saml.exception.invalidSignature"));
            }
        }
        catch (SAMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAMLException(Lexicon.make((String)"saml").get("saml.exception.signature"), e);
        }
    }

    private void validateTimestamps() throws SAMLException {
        NodeList timestampNodes = this.getDocument().getElementsByTagNameNS("*", "Conditions");
        if (timestampNodes.getLength() != 0) {
            for (int i = 0; i < timestampNodes.getLength(); ++i) {
                Instant notBeforeTime;
                Instant notOnOrAfterTime;
                NamedNodeMap attrName = timestampNodes.item(i).getAttributes();
                Node notBeforeAttribute = attrName.getNamedItem("NotBefore");
                Node notOnOrAfterAttribute = attrName.getNamedItem("NotOnOrAfter");
                Instant now = Instant.now();
                long timeSkew = this.samlScheme.getTimeSkew().getMillis();
                if (notOnOrAfterAttribute != null && (now.equals(notOnOrAfterTime = Instant.parse(notOnOrAfterAttribute.getNodeValue()).plus(timeSkew, ChronoUnit.MILLIS)) || now.isAfter(notOnOrAfterTime))) {
                    throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.notOnOrAfter"));
                }
                if (notBeforeAttribute == null || !now.isBefore(notBeforeTime = Instant.parse(notBeforeAttribute.getNodeValue()).minus(timeSkew, ChronoUnit.MILLIS))) continue;
                throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.notBefore"));
            }
        }
    }

    private void validateAudiences() throws SAMLException {
        Set<String> validAudiences = this.getAudiences();
        if (!validAudiences.isEmpty() && !this.audienceURL.equals(this.entityId)) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").getText("saml.exception.audience", new Object[]{this.audienceURL}));
        }
    }

    private void validateDestination(Element rootElement) throws SAMLException {
        String destinationURL;
        if (rootElement.hasAttribute("Destination") && (destinationURL = rootElement.getAttribute("Destination")) != null && !destinationURL.isEmpty() && !destinationURL.equals(this.assertionConsumerServiceUri)) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").getText("saml.exception.destination", new Object[]{this.assertionConsumerServiceUri, destinationURL}));
        }
    }

    private void validateSessionExpiration() throws SAMLException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        GregorianCalendar sessionExpiration = this.getSessionNotOnOrAfter();
        if (sessionExpiration != null && (now.equals(sessionExpiration) || now.after(sessionExpiration))) {
            throw new SAMLException(Lexicon.make((String)"saml").get("saml.exception.expired"));
        }
    }

    private void validateSubjectConfirmation() throws SAMLException {
        Instant now = Instant.now();
        long timeSkew = this.samlScheme.getTimeSkew().getMillis();
        boolean validSubjectConfirmation = true;
        NodeList subjectConfirmationNodes = this.queryAssertion("/saml:Subject/saml:SubjectConfirmation");
        for (int i = 0; i < subjectConfirmationNodes.getLength(); ++i) {
            Node scn = subjectConfirmationNodes.item(i);
            Node method = scn.getAttributes().getNamedItem("Method");
            if (method != null && !method.getNodeValue().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer")) continue;
            NodeList subjectConfirmationDataNodes = scn.getChildNodes();
            for (int c = 0; c < subjectConfirmationDataNodes.getLength(); ++c) {
                Instant notBeforeTime;
                Node notBeforeAttribute;
                Instant notOnOrAfterTime;
                Node notOnOrAfterAttribute;
                if (subjectConfirmationDataNodes.item(c).getLocalName() == null || !subjectConfirmationDataNodes.item(c).getLocalName().equals("SubjectConfirmationData")) continue;
                Node recipient = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("Recipient");
                if (recipient != null && !recipient.getNodeValue().isEmpty() && !recipient.getNodeValue().equals(this.assertionConsumerServiceUri)) {
                    SAMLUtils.log(Level.FINEST, String.format("unrecognized recipient url, found '%s', expected '%s'", recipient.getNodeValue(), this.assertionConsumerServiceUri));
                    validSubjectConfirmation = false;
                }
                if ((notOnOrAfterAttribute = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("NotOnOrAfter")) != null && (now.equals(notOnOrAfterTime = Instant.parse(notOnOrAfterAttribute.getNodeValue()).plus(timeSkew, ChronoUnit.MILLIS)) || now.isAfter(notOnOrAfterTime))) {
                    if (SAMLUtils.isLoggable(Level.FINEST)) {
                        SAMLUtils.log(Level.FINEST, "recipient not on or after " + notOnOrAfterAttribute.getNodeValue());
                    }
                    validSubjectConfirmation = false;
                }
                if ((notBeforeAttribute = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("NotBefore")) == null || !now.isBefore(notBeforeTime = Instant.parse(notBeforeAttribute.getNodeValue()).minus(timeSkew, ChronoUnit.MILLIS))) continue;
                if (SAMLUtils.isLoggable(Level.FINEST)) {
                    SAMLUtils.log(Level.FINEST, "recipient not before " + notBeforeAttribute.getNodeValue());
                }
                validSubjectConfirmation = false;
            }
        }
        if (!validSubjectConfirmation) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.subjectConfirmation"));
        }
    }

    private NodeList queryAssertion(String assertionXpath) throws SAMLException {
        try {
            String nameQuery;
            String signatureQuery = "/samlp:Response/saml:Assertion/ds:Signature/ds:SignedInfo/ds:Reference";
            NodeList nodeList = this.query(signatureQuery, null);
            if (nodeList.getLength() > 0) {
                Node assertionReferenceNode = nodeList.item(0);
                String id = assertionReferenceNode.getAttributes().getNamedItem("URI").getNodeValue().substring(1);
                nameQuery = "/samlp:Response/saml:Assertion[@ID='" + id + "']" + assertionXpath;
            } else {
                signatureQuery = "/samlp:Response/ds:Signature/ds:SignedInfo/ds:Reference";
                nodeList = this.query(signatureQuery, null);
                if (nodeList.getLength() > 0) {
                    Node assertionReferenceNode = nodeList.item(0);
                    String id = assertionReferenceNode.getAttributes().getNamedItem("URI").getNodeValue().substring(1);
                    nameQuery = "/samlp:Response[@ID='" + id + "']/saml:Assertion" + assertionXpath;
                } else {
                    nameQuery = "/samlp:Response/saml:Assertion" + assertionXpath;
                }
            }
            return this.query(nameQuery, null);
        }
        catch (XPathExpressionException e) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.query"), e);
        }
    }

    private NodeList query(String nameQuery, Node context) throws XPathExpressionException {
        Document doc = this.encrypted ? this.decryptedDocument : this.document;
        return Utils.query(doc, nameQuery, context);
    }

    public Set<String> getAudiences() throws SAMLException {
        LinkedHashSet<String> audiences = new LinkedHashSet<String>();
        NodeList entries = this.queryAssertion("/saml:Conditions/saml:AudienceRestriction/saml:Audience");
        if (entries.getLength() > 0 && entries.item(0) != null && entries.item(0).getChildNodes().getLength() > 0) {
            this.audienceURL = entries.item(0).getChildNodes().item(0).getNodeValue();
        }
        for (int i = 0; i < entries.getLength(); ++i) {
            String value;
            if (entries.item(i) == null || (value = entries.item(i).getTextContent()) == null || value.trim().isEmpty()) continue;
            audiences.add(value.trim());
        }
        return audiences;
    }

    public Set<String> getIssuers() throws SAMLException {
        NodeList assertionIssuer;
        LinkedHashSet<String> issuers = new LinkedHashSet<String>();
        NodeList responseIssuer = this.queryAssertion("/samlp:Response/saml:Issuer");
        if (responseIssuer.getLength() == 1) {
            issuers.add(responseIssuer.item(0).getTextContent());
        }
        if ((assertionIssuer = this.queryAssertion("/saml:Issuer")).getLength() == 1) {
            issuers.add(assertionIssuer.item(0).getTextContent());
        }
        return issuers;
    }

    public GregorianCalendar getSessionNotOnOrAfter() throws SAMLException {
        NodeList entries = this.queryAssertion("/saml:AuthnStatement[@SessionNotOnOrAfter]");
        if (entries.getLength() > 0) {
            String notOnOrAfter = entries.item(0).getAttributes().getNamedItem("SessionNotOnOrAfter").getNodeValue();
            return datatypeFactory.newXMLGregorianCalendar(notOnOrAfter).toGregorianCalendar();
        }
        return null;
    }

    public Map<String, List<String>> getUserAttributes() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        NodeList attributeNodes = this.getDocument().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node attributeNode = attributeNodes.item(i);
            String attributeName = attributeNode.getAttributes().getNamedItem("Name").getNodeValue();
            NodeList valueNodes = attributeNode.getChildNodes();
            ArrayList<String> values = new ArrayList<String>();
            for (int j = 0; j < valueNodes.getLength(); ++j) {
                values.add(valueNodes.item(j).getTextContent());
            }
            SAMLUtils.log(Level.FINER, () -> String.format("Found raw attribute <%s> with values <%s>", attributeName, String.join((CharSequence)";", values)));
            attributes.put(attributeName, values);
        }
        return attributes;
    }

    public String getNameId() throws SAMLException {
        NodeList nodes = this.getDocument().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
        if (nodes.getLength() == 0) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.nameId"));
        }
        return nodes.item(0).getTextContent();
    }

    public String getAuthnContextClassRef() {
        NodeList nodes = this.getDocument().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef");
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return null;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }
}

