/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.rp.servlet;

import com.tridium.saml.rp.servlet.SAMLAuthenticationInfo;
import com.tridium.security.SAMLPermission;
import java.security.Permission;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class SAMLAuthenticationInfoHandler {
    private static final Map<String, SAMLAuthenticationInfo> authenticationInfoMap = Collections.synchronizedMap(new WeakHashMap());

    static void addAuthenticationInfo(String sessionId, SAMLAuthenticationInfo authInfo) {
        if (sessionId != null) {
            authenticationInfoMap.put(sessionId, authInfo);
        }
    }

    public static void removeAuthenticationInfo(String sessionId) {
        SAMLPermission samlPermission = new SAMLPermission("removeAuthnInfo");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)samlPermission);
        }
        if (sessionId != null) {
            authenticationInfoMap.remove(sessionId);
        }
    }

    public static SAMLAuthenticationInfo getAuthenticationInfo(String sessionId) {
        if (sessionId != null) {
            return authenticationInfoMap.get(sessionId);
        }
        return null;
    }
}

