/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsh;

import com.tridium.nsh.Expr;
import com.tridium.nsh.NShell;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Main {
    public static void usage(PrintWriter out) {
        out.println("usage: nsh [file] [options]");
        out.println("  Execute the specified nsh file; if no file");
        out.println("  specified then enter interactive console.");
        out.println("options:");
        out.println("  /?      Display this usage");
        out.println("  /debug  Turn on debug tracing");
        out.flush();
    }

    public static void runFile(NShell nsh, String[] args) throws Exception {
        String line = "";
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                line = line + " ";
            }
            line = line + args[0];
        }
        Expr expr = Expr.parse(nsh, line);
        nsh.run(expr);
    }

    public static void runConsole(NShell nsh, InputStream in) {
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        while (true) {
            try {
                while (true) {
                    nsh.out.print("nsh|" + nsh.cd + ">");
                    nsh.out.flush();
                    String cmd = bin.readLine().trim();
                    if (cmd.length() == 0) continue;
                    if (cmd.equals("quit")) {
                        return;
                    }
                    if (cmd.equals("exit")) {
                        return;
                    }
                    nsh.exec(cmd);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(nsh.out);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        NShell nsh = new NShell(System.out);
        String filename = null;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i].intern();
            if (a.equals("/?") || a.equals("/help")) {
                Main.usage(new PrintWriter(System.out));
                return;
            }
            if (a.equals("/debug")) {
                nsh.setDebug(true);
                continue;
            }
            filename = a;
        }
        if (filename == null) {
            Main.runConsole(nsh, System.in);
        } else {
            try {
                Main.runFile(nsh, args);
            }
            catch (Throwable e) {
                e.printStackTrace(nsh.out);
            }
        }
    }
}

