/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSync.job;

import com.tridium.fcModelSync.job.BModelDiscoveryJob;
import com.tridium.fcModelSync.service.BModelSyncService;
import com.tridium.json.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BModelSyncJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BModelSyncJob.class);
    private BModelSyncService mService;

    public Type getType() {
        return TYPE;
    }

    public BModelSyncJob() {
    }

    public BModelSyncJob(BModelSyncService service) {
        this.mService = service;
    }

    public void run(Context cx) throws Exception {
        if (this.mService == null) {
            this.log().failed("No Model Sync Service configured");
        }
        try {
            this.log().message("Starting model sync");
            if (this.mService.getUseDriverDiscoveryJobs()) {
                this.log().message("Discovering additional device properties with driver discovery jobs");
                BModelDiscoveryJob job = new BModelDiscoveryJob(this.mService);
                job.setModelSyncLog(this.log());
                try {
                    job.run(cx);
                }
                catch (Exception e) {
                    this.log().message("fcModelSync", "modelSync.modelDiscovery.failed", e.toString());
                }
            }
            this.mService.getModelExtractor().setModelJob((BJob)this);
            File modelFile = this.mService.getModelExtractor().getModelFile(this.mService.getSiteName());
            if (!this.isAlive()) {
                this.log().endFailed("fcModelSync", "modelSync.jobCanceled", null);
                throw new Exception(this.getLexicon().getText("modelSync.jobCanceled"));
            }
            this.setProgress(50);
            this.log().message("Model Extraction completed.");
            File contextFile = this.createContextDiscoveryProperties(this.mService.getSiteName() + "_context");
            StringBuilder zipFilePathBuilder = new StringBuilder().append(Sys.getNiagaraSharedUserHome()).append(File.separator).append(this.mService.getSiteName()).append("_CD_Model").append(".zip");
            this.log().message("Context files created.");
            this.setProgress(75);
            File[] files = new File[]{modelFile, contextFile};
            this.addFilesToZipFile(files, zipFilePathBuilder.toString());
            if (this.mService.getDeleteFilesAfterSync()) {
                this.log().message("Deleting model file after upload :" + modelFile.delete());
                this.log().message("Deleting context file after upload :" + contextFile.delete());
            } else {
                this.log().message("Model file not deleted due to service configuration; manual cleanup recommended: " + modelFile);
                this.log().message("Context file not deleted due to service configuration; manual cleanup recommended: " + contextFile);
            }
            this.log().message("Uploading file to cloud.");
            this.mService.getModelWriter().uploadFileToSentience(BString.make((String)zipFilePathBuilder.toString()));
            this.mService.setModelSyncStatus("MODEL UPLOADED WAITING FOR UPDATES..");
            this.log().message("Model file pushed to cloud. Waiting for cloud updates.");
        }
        catch (Exception exp) {
            Throwable cause = exp.getCause();
            if (cause != null) {
                this.log().failed("Sync failed; cause is " + cause);
            } else {
                this.log().failed("Sync failed; message is " + exp.getMessage());
            }
            throw exp;
        }
    }

    private File createContextDiscoveryProperties(String fileName) throws Exception {
        String filePathBuilder = Sys.getNiagaraSharedUserHome() + File.separator + fileName + ".json";
        File jsonContextFile = new File(filePathBuilder);
        try (FileWriter writer = new FileWriter(jsonContextFile);){
            JSONObject contextDiscoveryPropertiesJson = new JSONObject();
            contextDiscoveryPropertiesJson.put("isContextDiscoveryRequired", true);
            contextDiscoveryPropertiesJson.put("unit", (Object)this.mService.getUnit().toString());
            contextDiscoveryPropertiesJson.put("isCacheRequired", this.mService.getModelCacheRequired());
            contextDiscoveryPropertiesJson.put("fastStoreRententionInDays", this.mService.getFastStoreRetentionPolicyInDays());
            contextDiscoveryPropertiesJson.put("siteId", (Object)SlotPath.escape((String)this.mService.getSiteName()));
            writer.write(contextDiscoveryPropertiesJson.toString(4));
        }
        catch (Exception ex) {
            this.log().message("Error on context creation:" + ex.getCause());
            throw ex;
        }
        return jsonContextFile;
    }

    private void addFilesToZipFile(File[] files, String zipFilePath) throws Exception {
        File zipFile = new File(zipFilePath);
        FileInputStream fileInputStream = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            for (File file : files) {
                int length;
                fileInputStream = new FileInputStream(file);
                zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
                byte[] bytes = new byte[1024];
                while ((length = fileInputStream.read(bytes)) >= 0) {
                    zipOutputStream.write(bytes, 0, length);
                }
                zipOutputStream.closeEntry();
                fileInputStream.close();
            }
        }
        catch (Exception ex) {
            this.log().message("Error on creating zip:" + ex.getCause());
            throw ex;
        }
        finally {
            if (null != fileInputStream) {
                fileInputStream.close();
            }
        }
    }
}

