/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSync.writer;

import com.tridium.cloud.client.BCloudConnector;
import com.tridium.cloud.client.BICloudConnector;
import com.tridium.cloud.client.iothub.BAbstractIotHubConnectorImpl;
import com.tridium.fcModelSync.writer.FileUploadStatusHandler;
import com.tridium.forge.cloud.platform.IotHubConnectionPropertyNames;
import com.tridium.forge.fileuploadclient.FileConfig;
import com.tridium.forge.fileuploadclient.FileUploader;
import com.tridium.forge.fileuploadclient.IFileUploadStatusHandler;
import com.tridium.forge.javafileuploader.FileUploadHandler;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="uploadFileToSentience", parameterType="BString", defaultValue="BString.make(\"\")")
public class BModelWriterImpl
extends BComponent {
    public static final Action uploadFileToSentience = BModelWriterImpl.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BModelWriterImpl.class);
    private final Logger logger = Logger.getLogger("FileUpload");

    public void uploadFileToSentience(BString parameter) {
        this.invoke(uploadFileToSentience, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doUploadFileToSentience(BString filePath) {
        final File toUploadFile = new File(filePath.toString());
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    BModelWriterImpl.this.logger.log(Level.INFO, "File upload process started");
                    BModelWriterImpl.this.uploadFile(toUploadFile);
                    BModelWriterImpl.this.logger.log(Level.INFO, "File uploader engaged");
                }
                catch (Exception exc) {
                    BModelWriterImpl.this.logger.log(Level.SEVERE, BModelWriterImpl.this.logger.isLoggable(Level.FINE) ? exc : null, () -> String.format("Exception in uploadFile:%s", exc));
                }
                return null;
            }
        });
    }

    public boolean connectorIsHealthy() {
        BICloudConnector cloudConnector = this.getCloudConnector();
        if (null != cloudConnector) {
            return cloudConnector.isConnected();
        }
        return false;
    }

    private BICloudConnector getCloudConnector() {
        BCloudConnector cloudConnector = null;
        try {
            cloudConnector = (BCloudConnector)Sys.getService((Type)BCloudConnector.TYPE);
        }
        catch (ServiceNotFoundException se) {
            this.logger.log(Level.INFO, "cloud connector service not found: " + (Object)((Object)se));
        }
        return cloudConnector;
    }

    private void uploadFile(File zippedFile) {
        Map connectionInfoMap = ((BAbstractIotHubConnectorImpl)this.getCloudConnector().getConnectorImpl()).getConnectionInfo("FileUploadService");
        if (null != connectionInfoMap) {
            FileConfig config = new FileConfig();
            config.setFileName(zippedFile.getPath());
            config.setFileDisplayName(zippedFile.getName());
            config.setMimeType("text/html");
            FileUploadHandler fileUploadHandler = new FileUploadHandler(this.logger);
            final FileUploadStatusHandler uploadStatusHandler = new FileUploadStatusHandler(this.logger);
            Callable<IFileUploadStatusHandler> fileUploadStatusHandlerCallable = new Callable<IFileUploadStatusHandler>(){

                @Override
                public IFileUploadStatusHandler call() throws Exception {
                    return uploadStatusHandler;
                }
            };
            FileUploader<FileConfig> fileUploader = new FileUploader<FileConfig>(fileUploadHandler, this.logger, fileUploadStatusHandlerCallable);
            try {
                if (fileUploader.isFileValid(config)) {
                    this.logger.info("Retrived connection info, calling uploadFileToConnection");
                    fileUploader.uploadFileToConnection(config, BModelWriterImpl.getConnectionDetails(connectionInfoMap));
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error checking the validity of the file to be uploaded", e);
            }
        } else {
            this.logger.log(Level.SEVERE, "File upload is not permitted for this system type");
        }
    }

    private static Map<String, String> getConnectionDetails(Map<String, String> connectionInfoMap) {
        HashMap<String, String> connectionDetails = new HashMap<String, String>();
        connectionDetails.put(IotHubConnectionPropertyNames.getBasePath(), connectionInfoMap.get("hostName"));
        connectionDetails.put(IotHubConnectionPropertyNames.getUserName(), connectionInfoMap.get("id"));
        connectionDetails.put(IotHubConnectionPropertyNames.getPassword(), connectionInfoMap.get("token"));
        return connectionDetails;
    }
}

