/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.archive;

import com.tridium.alarmOrion.archive.BOrionAlarmArchiveDatabase;
import com.tridium.alarmOrion.archive.BOrionArchiveAlarmProvider;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import java.io.IOException;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.AlarmSpaceConnection;
import javax.baja.alarm.BAlarmArchive;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.alarm.BArchiveAlarmProvider;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.security.BIProtected;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BOrionAlarmArchive
extends BAlarmArchive {
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionAlarmArchive.class);
    private BArchiveAlarmProvider provider;
    private BOrionAlarmDatabase db;
    private static final Lexicon LEX = Lexicon.make((String)"alarmOrion");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOrionAlarmArchive(BArchiveAlarmProvider provider, BOrionAlarmArchiveDatabase db) {
        this.provider = provider;
        this.db = db;
    }

    public BOrionAlarmDatabase getOrionAlarmDb() {
        return this.db;
    }

    public BArchiveAlarmProvider getProvider() {
        return this.provider;
    }

    public void doOpen() throws IOException {
        this.db.open();
    }

    public void doClose() {
        this.db.close();
    }

    public void doFlush() throws IOException {
        this.db.flush();
    }

    public void doSave() throws IOException {
        this.db.save();
    }

    public void updateConfig(BAlarmDbConfig config, Property p) throws AlarmException {
    }

    public AlarmSpaceConnection getConnection(Context cx) {
        return this.getDbConnection(cx);
    }

    public AlarmDbConnection getDbConnection(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissionsFor((BIProtected)this).hasOperatorRead()) {
            throw new AlarmException("user needs alarm archive space permissions");
        }
        return new OrionAlarmDbConnection(this.db, this.getOrionSession(cx));
    }

    private OrionSession getOrionSession(Context cx) {
        return this.getOrionDatabase().createSession(cx);
    }

    private BOrionDatabase getOrionDatabase() {
        if (!this.provider.isOperational()) {
            throw new OrionException(LEX.getText("orionAlarmArchive.archiveNotFound"));
        }
        try {
            BRdbms rdbms = (BRdbms)((BOrionArchiveAlarmProvider)this.provider).getRdbOrd().get((BObject)this.provider);
            BOrionService orionService = (BOrionService)BOrd.make((String)"service:orion:OrionService").get((BObject)this.provider);
            return orionService.getOrionDatabase(rdbms);
        }
        catch (UnresolvedException e) {
            throw new OrionException(LEX.getText("orionAlarmArchive.orionServiceNotFound"));
        }
    }
}

