/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.ICoalesceable;

public class ToNormal
extends AlarmRecordTransaction
implements ICoalesceable {
    protected BAlarmRecord normalRecord;

    public ToNormal(BAlarmRecord alarmRecord) {
        this.normalRecord = alarmRecord;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    public Object getCoalesceKey() {
        return this.normalRecord.getUuid();
    }

    @Override
    public void doRun() {
        BAlarmRecord last = null;
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        StringBuilder queryStr = new StringBuilder("alarm:|bql:select * where ");
        queryStr.append("source = OrdList '");
        queryStr.append(SlotPath.escape((String)this.normalRecord.getSource().encodeToString()));
        queryStr.append("' and sourceState != alarm:SourceState.normal");
        BOrd query = BOrd.make((String)queryStr.toString());
        try (TableCursor result = ((BITable)query.resolve((BObject)alarmService).get()).cursor();){
            if (result.next()) {
                do {
                    BAlarmRecord record;
                    if ((record = (BAlarmRecord)((BValue)result.get()).newCopy(true)).getSourceState() == BSourceState.alert) continue;
                    record.setSource(this.normalRecord.getSource());
                    record.setAlarmClass(this.normalRecord.getAlarmClass());
                    record.setNormalTime(Clock.time());
                    record.setSourceState(BSourceState.normal);
                    record.setAckRequired(record.getAckRequired() || this.normalRecord.getAckRequired());
                    record.setAlarmData(BFacets.make((BFacets)record.getAlarmData(), (BFacets)this.normalRecord.getAlarmData()));
                    if (this.normalRecord.getAckRequired()) {
                        record.setAckState(BAckState.unacked);
                    }
                    alarmService.routeAlarm(record);
                    last = record;
                } while (result.next());
            }
        }
        if (last == null) {
            BAlarmRecord record = new BAlarmRecord(BUuid.make());
            if (this.normalRecord.getAckRequired()) {
                record.setAckState(BAckState.unacked);
            }
            record.setSource(this.normalRecord.getSource());
            record.setAlarmClass(this.normalRecord.getAlarmClass());
            record.setNormalTime(Clock.time());
            record.setSourceState(BSourceState.normal);
            record.setAckRequired(this.normalRecord.getAckRequired());
            record.setAlarmData(this.normalRecord.getAlarmData());
            alarmService.routeAlarm(record);
            last = record;
        }
        BOrdList list = this.normalRecord.getSource();
        try {
            BObject obj = list.get(0).resolve().get();
            if (obj instanceof BAlarmSourceExt) {
                BAlarmSourceExt ext = (BAlarmSourceExt)obj;
                ext.fireToNormal(last);
            }
        }
        catch (UnresolvedException unresolvedException) {
            // empty catch block
        }
    }
}

