/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.alarmOrion.OrionObjectCache;
import com.tridium.alarmOrion.SkipLocalAlarmClassUpdates;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraOrionType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="int", defaultValue="-1", flags=9, facets={@Facet(value="ID_KEY")}), @NiagaraProperty(name="alarmClass", type="String", defaultValue="", flags=8, facets={@Facet(name="UNIQUE", value="true"), @Facet(name="WIDTH", value="64")}), @NiagaraProperty(name="unackedAlarmCount", type="int", defaultValue="0", flags=8), @NiagaraProperty(name="openAlarmCount", type="int", defaultValue="0", flags=8), @NiagaraProperty(name="inAlarmCount", type="int", defaultValue="0", flags=8), @NiagaraProperty(name="totalAlarmCount", type="int", defaultValue="0", flags=8), @NiagaraProperty(name="timeOfLastAlarm", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=8)})
public class BOrionAlarmClass
extends BOrionObject {
    @Generated
    public static final Property id = BOrionAlarmClass.newProperty((int)9, (int)-1, (BFacets)ID_KEY);
    @Generated
    public static final Property alarmClass = BOrionAlarmClass.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"unique", (boolean)true), (BFacets)BFacets.make((String)"width", (int)64)));
    @Generated
    public static final Property unackedAlarmCount = BOrionAlarmClass.newProperty((int)8, (int)0, null);
    @Generated
    public static final Property openAlarmCount = BOrionAlarmClass.newProperty((int)8, (int)0, null);
    @Generated
    public static final Property inAlarmCount = BOrionAlarmClass.newProperty((int)8, (int)0, null);
    @Generated
    public static final Property totalAlarmCount = BOrionAlarmClass.newProperty((int)8, (int)0, null);
    @Generated
    public static final Property timeOfLastAlarm = BOrionAlarmClass.newProperty((int)8, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionAlarmClass.class);
    @Generated
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    private static final OrionObjectCache ORION_ALARM_CLASS_CACHE = new OrionObjectCache(100);

    @Generated
    public int getId() {
        return this.getInt(id);
    }

    @Generated
    public void setId(int v) {
        this.setInt(id, v, null);
    }

    @Generated
    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    @Generated
    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    @Generated
    public int getUnackedAlarmCount() {
        return this.getInt(unackedAlarmCount);
    }

    @Generated
    public void setUnackedAlarmCount(int v) {
        this.setInt(unackedAlarmCount, v, null);
    }

    @Generated
    public int getOpenAlarmCount() {
        return this.getInt(openAlarmCount);
    }

    @Generated
    public void setOpenAlarmCount(int v) {
        this.setInt(openAlarmCount, v, null);
    }

    @Generated
    public int getInAlarmCount() {
        return this.getInt(inAlarmCount);
    }

    @Generated
    public void setInAlarmCount(int v) {
        this.setInt(inAlarmCount, v, null);
    }

    @Generated
    public int getTotalAlarmCount() {
        return this.getInt(totalAlarmCount);
    }

    @Generated
    public void setTotalAlarmCount(int v) {
        this.setInt(totalAlarmCount, v, null);
    }

    @Generated
    public BAbsTime getTimeOfLastAlarm() {
        return (BAbsTime)this.get(timeOfLastAlarm);
    }

    @Generated
    public void setTimeOfLastAlarm(BAbsTime v) {
        this.set(timeOfLastAlarm, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public static BOrionAlarmClass get(String alarmClassName, OrionSession session) {
        BOrionAlarmClass alarmClass;
        if (ORION_ALARM_CLASS_CACHE.contains(alarmClassName)) {
            return (BOrionAlarmClass)ORION_ALARM_CLASS_CACHE.get(alarmClassName);
        }
        OrionCursor cursor = session.select(ORION_TYPE, new PropertyValue(BOrionAlarmClass.alarmClass, (BValue)BString.make((String)alarmClassName)));
        if (cursor.next()) {
            alarmClass = (BOrionAlarmClass)((Object)cursor.get());
            cursor.close();
        } else {
            alarmClass = new BOrionAlarmClass();
            alarmClass.setAlarmClass(alarmClassName);
            session.insert((BIOrionObject)alarmClass);
        }
        ORION_ALARM_CLASS_CACHE.put(alarmClassName, (BIOrionObject)alarmClass);
        return alarmClass;
    }

    public void afterDelete(OrionSession session) {
        ORION_ALARM_CLASS_CACHE.remove(this.getAlarmClass());
    }

    public void afterInsert(OrionSession session) {
        ORION_ALARM_CLASS_CACHE.put(this.getAlarmClass(), (BIOrionObject)this);
        this.updateAlarmClass(session);
    }

    public void afterUpdate(OrionSession session) {
        ORION_ALARM_CLASS_CACHE.update(this.getAlarmClass(), (BIOrionObject)this);
        this.updateAlarmClass(session);
    }

    @Deprecated
    public void updateAlarmClass() {
        this.updateAlarmClass(null);
    }

    public void updateAlarmClass(OrionSession session) {
        BAlarmClass[] alarmClasses;
        if (session != null && session.getBase() instanceof SkipLocalAlarmClassUpdates) {
            return;
        }
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        for (BAlarmClass aClass : alarmClasses = service.getAlarmClasses()) {
            if (!aClass.getName().equals(this.getAlarmClass())) continue;
            aClass.setUnackedAlarmCount(this.getUnackedAlarmCount());
            aClass.setOpenAlarmCount(this.getOpenAlarmCount());
            aClass.setInAlarmCount(this.getInAlarmCount());
            aClass.setTotalAlarmCount(this.getTotalAlarmCount());
            aClass.setTimeOfLastAlarm(this.getTimeOfLastAlarm());
            break;
        }
    }
}

