/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.alarmOrion.transactions.BOrionAlarmTransactionStatistics;
import com.tridium.alarmOrion.transactions.ToNormal;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BSqlCase;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.SqlColumns;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.alarmOrion.OrionAlarmDbConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BGroupByColumn;
import javax.baja.query.BGrouping;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.rdb.BRdbms;
import javax.baja.security.BIProtected;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

@NiagaraType
public class BOrionAlarmDatabase
extends BAlarmDatabase {
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionAlarmDatabase.class);
    public final Object exclusiveAccessMutex = new Object();
    public boolean open = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isOpen() {
        try {
            BOrionService orionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            return this.open && super.isOpen() && orionService.isOrionReady() && this.getStatus().isValid();
        }
        catch (OrionException | ServiceNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpen() throws IOException {
        BOrionService orionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        if (orionService.isOrionReady()) {
            BAbsTime startTimestamp = BAbsTime.now();
            int totalDatabaseAlarms = 0;
            try (OrionSession session = this.getOrionSession(null);
                 OrionCursor cursor = session.scan(BOrionAlarmClass.ORION_TYPE);){
                while (cursor.next()) {
                    BOrionAlarmClass alarmClass = (BOrionAlarmClass)((Object)cursor.get());
                    alarmClass.updateAlarmClass(session);
                    totalDatabaseAlarms += alarmClass.getTotalAlarmCount();
                }
            }
            finally {
                log.info("Loaded " + totalDatabaseAlarms + " alarms (" + startTimestamp.delta(BAbsTime.now()) + ")");
            }
        }
        this.open = true;
    }

    protected void doClose() {
        this.open = false;
        Queue queue = this.getQueue();
        if (log.isLoggable(Level.FINE)) {
            log.info("Flushing queued transactions.");
        }
        while (!queue.isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public AlarmDbConnection getDbConnection(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissionsFor((BIProtected)this).hasOperatorRead()) {
            throw new AlarmException("user needs alarm space permissions");
        }
        return new OrionAlarmDbConnection(this, this.getOrionSession(cx));
    }

    public void updateConfig(BAlarmDbConfig config, Property p) throws AlarmException {
    }

    public void recalculateAlarmClassStatistics() {
        try (OrionSession session = this.getOrionSession(null);){
            BAlarmClass[] alarmClasses;
            BAbsTime lastAlarm;
            BInteger totalAlarms;
            BInteger inAlarm;
            BInteger openAlarms;
            BInteger unackedAlarms;
            BDynamicOrionObject result;
            BOrionAlarmService service = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
            BSqlQuery alarmStatisticsQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
            BSqlExtent alarmClassExt = new BSqlExtent(BOrionAlarmClass.ORION_TYPE).alias("alarmClass");
            BProjection projection = new BProjection();
            BSqlCase unackedCase = new BSqlCase();
            unackedCase.whenThen(Exprs.builder((BExpression)Exprs.binary((BExpression)Exprs.field((Property)BOrionAlarmRecord.ackState), (String)"!=", (BExpression)Exprs.simple((BSimple)BAckState.acked))).and((BExpression)Exprs.binary((BExpression)Exprs.binary((BExpression)Exprs.field((Property)BOrionAlarmRecord.sourceState), (String)"!=", (BExpression)Exprs.simple((BSimple)BSourceState.normal)), (String)"OR", (BExpression)Exprs.binary((BExpression)Exprs.field((Property)BOrionAlarmRecord.ackRequired), (String)"=", (BExpression)Exprs.simple((BSimple)BBoolean.TRUE)))).getExpression(), (BExpression)Exprs.simple((BSimple)BInteger.make((int)1)));
            unackedCase.setElse(Exprs.Null());
            projection.add(SqlColumns.make((BExpression)Funcs.count((BExpression)unackedCase)).as("unackedAlarms"));
            BSqlCase openCase = new BSqlCase((BExpression)new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.isOpen));
            openCase.whenThen((BExpression)Exprs.simple((BSimple)BBoolean.TRUE), (BExpression)Exprs.simple((BSimple)BInteger.make((int)1)));
            openCase.setElse(Exprs.Null());
            projection.add(SqlColumns.make((BExpression)Funcs.count((BExpression)openCase)).as("openAlarms"));
            Object alarmCase = new BSqlCase((BExpression)new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.sourceState));
            alarmCase.whenThen((BExpression)Exprs.simple((BSimple)BSourceState.normal), Exprs.Null());
            alarmCase.setElse((BExpression)Exprs.simple((BSimple)BInteger.make((int)1)));
            projection.add(SqlColumns.make((BExpression)Funcs.count((BExpression)alarmCase)).as("inAlarm"));
            projection.add(SqlColumns.make((BExpression)Funcs.count((BExpression)Exprs.simple((BSimple)BInteger.make((int)1)))).as("totalAlarms"));
            projection.add(SqlColumns.make((BExpression)Funcs.make((String)"MAX", (Type)BAbsTime.TYPE, (String)BOrionAlarmRecord.timestamp.getName())).as("lastAlarm"));
            projection.add(SqlColumns.make((BSqlField)new BSqlField(alarmClassExt, BOrionAlarmClass.alarmClass)));
            alarmStatisticsQuery.select(projection);
            alarmStatisticsQuery.join(new BSqlJoin(new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.alarmClass), new BSqlField(alarmClassExt, BOrionAlarmClass.id)));
            BGrouping group = new BGrouping();
            group.add(new BGroupByColumn((BExpression)new BSqlField(alarmClassExt, BOrionAlarmClass.id)));
            group.add(new BGroupByColumn((BExpression)new BSqlField(alarmClassExt, BOrionAlarmClass.alarmClass)));
            alarmStatisticsQuery.groupBy(group);
            HashMap<String, BDynamicOrionObject> alarmClassMap = new HashMap<String, BDynamicOrionObject>();
            OrionCursor cursor = session.select((BQuery)alarmStatisticsQuery);
            alarmCase = null;
            try {
                while (cursor.next()) {
                    BDynamicOrionObject result2 = (BDynamicOrionObject)cursor.get();
                    BString alarmClassName = (BString)result2.get(BOrionAlarmRecord.alarmClass);
                    alarmClassMap.put(alarmClassName.toString(), result2);
                }
            }
            catch (Throwable result2) {
                alarmCase = result2;
                throw result2;
            }
            finally {
                if (cursor != null) {
                    if (alarmCase != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable result2) {
                            ((Throwable)alarmCase).addSuppressed(result2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            BatchStatement alarmClassUpdater = session.batchUpdate(BOrionAlarmClass.ORION_TYPE);
            BatchStatement alarmClassDeleter = session.batchDelete(BOrionAlarmClass.ORION_TYPE);
            try (OrionCursor c = session.scan(BOrionAlarmClass.ORION_TYPE);){
                while (c.next()) {
                    BOrionAlarmClass bOrionAlarmClass = (BOrionAlarmClass)((Object)c.get());
                    result = (BDynamicOrionObject)alarmClassMap.get(bOrionAlarmClass.getAlarmClass());
                    if (result == null) {
                        alarmClassDeleter.add((BIOrionObject)bOrionAlarmClass);
                        continue;
                    }
                    unackedAlarms = (BInteger)result.get("unackedAlarms");
                    openAlarms = (BInteger)result.get("openAlarms");
                    inAlarm = (BInteger)result.get("inAlarm");
                    totalAlarms = (BInteger)result.get("totalAlarms");
                    lastAlarm = (BAbsTime)result.get("lastAlarm");
                    bOrionAlarmClass.setUnackedAlarmCount(unackedAlarms.getInt());
                    bOrionAlarmClass.setOpenAlarmCount(openAlarms.getInt());
                    bOrionAlarmClass.setInAlarmCount(inAlarm.getInt());
                    bOrionAlarmClass.setTotalAlarmCount(totalAlarms.getInt());
                    bOrionAlarmClass.setTimeOfLastAlarm(lastAlarm);
                    alarmClassUpdater.add((BIOrionObject)bOrionAlarmClass);
                }
            }
            alarmClassUpdater.execute();
            alarmClassDeleter.execute();
            for (BAlarmClass bAlarmClass : alarmClasses = service.getAlarmClasses()) {
                result = (BDynamicOrionObject)alarmClassMap.get(bAlarmClass.getName());
                if (result == null) {
                    bAlarmClass.setUnackedAlarmCount(0);
                    bAlarmClass.setOpenAlarmCount(0);
                    bAlarmClass.setInAlarmCount(0);
                    bAlarmClass.setTotalAlarmCount(0);
                    continue;
                }
                unackedAlarms = (BInteger)result.get("unackedAlarms");
                openAlarms = (BInteger)result.get("openAlarms");
                inAlarm = (BInteger)result.get("inAlarm");
                totalAlarms = (BInteger)result.get("totalAlarms");
                lastAlarm = (BAbsTime)result.get("lastAlarm");
                bAlarmClass.setUnackedAlarmCount(unackedAlarms.getInt());
                bAlarmClass.setOpenAlarmCount(openAlarms.getInt());
                bAlarmClass.setInAlarmCount(inAlarm.getInt());
                bAlarmClass.setTotalAlarmCount(totalAlarms.getInt());
                bAlarmClass.setTimeOfLastAlarm(lastAlarm);
            }
        }
    }

    private Queue getQueue() {
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        return (Queue)service.fw(601);
    }

    public void toNormal(BAlarmRecord alarmRecord) {
        if (log.isLoggable(Level.FINE) && alarmRecord.getSource().size() > 0) {
            log.fine("Returning to normal " + alarmRecord.getSource().get(0));
        }
        if (!this.isOpen()) {
            throw new AlarmException("Unable to append, database unavailable.");
        }
        this.enqueue(new ToNormal(alarmRecord));
    }

    private void enqueue(AlarmRecordTransaction transaction) {
        Queue queue = this.getQueue();
        if (queue.isFull()) {
            throw new AlarmException("Alarm queue is full, unable to enqueue " + transaction);
        }
        BOrionAlarmService service = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        Object[] stats = service.getChildren(BOrionAlarmTransactionStatistics.class);
        if (stats.length > 0) {
            ((BOrionAlarmTransactionStatistics)((Object)stats[0])).transactionEnqueued();
        }
        queue.enqueue((Object)transaction);
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        return super.fw(x, a, b, c, d);
    }

    public BStatus getStatus() {
        BOrionAlarmService alarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        if (alarmService.getDatabase().isNull()) {
            throw new OrionException("Database not configured.");
        }
        BRdbms rdbms = (BRdbms)alarmService.getDatabase().resolve((BObject)alarmService).get();
        return rdbms.getStatus();
    }

    public BOrionDatabase getOrionDatabase() {
        BOrionAlarmService alarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        if (alarmService.getDatabase().isNull()) {
            throw new OrionException("Database not configured.");
        }
        BRdbms rdbms = (BRdbms)alarmService.getDatabase().resolve((BObject)alarmService).get();
        BOrionSpace orionSpace = (BOrionSpace)BOrd.make((String)"orion:").resolve((BObject)alarmService).get();
        return orionSpace.getOrionDatabase(rdbms);
    }

    private OrionSession getOrionSession(Context cx) {
        return this.getOrionDatabase().createSession(cx);
    }
}

