/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rtsp;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.util.Base64;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rtsp.RtpPacket;
import javax.baja.rtsp.RtpStream;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.util.Queue;

public class RtspConnection {
    protected Socket controlSocket;
    protected OutputStream controlOut;
    protected InputStream controlInput;
    protected int state = 0;
    protected int CSeq = 0;
    protected int present_session = 0;
    protected String trackid = "0";
    static final int init = 0;
    static final int describe = 1;
    static final int initsetup = 2;
    static final int setup = 3;
    static final int ready = 4;
    static final int play = 5;
    static final int paused = 6;
    static final int WAIT_MEDIA_VIDEO = 0;
    static final int WAIT_VIDEO_TRACKID = 1;
    static final int GOT_VIDEO_TRACKID = 2;
    protected int lastError = 0;
    protected String lastCcommand = "";
    private boolean is_describe;
    private boolean is_setup;
    private boolean is_play;
    private boolean is_pause;
    private boolean is_teardown;
    private boolean is_get_parameter;
    private boolean is_set_parameter;
    private boolean is_announce;
    private boolean is_record;
    private boolean is_redirect;
    protected String hostname = "";
    protected String username = "";
    protected String iPhrase = "";
    protected int controlPort = 554;
    protected int dataPort = 9000;
    protected String rtspUri = "";
    public int chunksize = 1500;
    protected int timeout = 1000;
    String videoParams = "";
    boolean useBasic = true;
    String nonce = "";
    String realm = "";
    String authorization = "";
    protected SessionObject session;
    static int MAX_WAIT_TIME = 5000;
    protected UdpDataReader udpReader;
    protected UdpDataReader rtcpReader;
    boolean useTcp = false;
    protected KeepAliveTask keepAliveTask;
    protected TcpInputStreamReader tcpReader;
    private static final int MAX_READ_RETRIES = 20;
    private static final int PACKET_DEQUEUE_TIMEOUT = 3000;
    private String keepAliveCommandString;
    boolean useQueue;
    int rtpPacketQueueSize;
    BufferedInputStream buffIn;
    BufferedReader bufferedReader;
    Queue tcpRtpPacketQueue;
    Queue tcpRtspPacketQueue;
    Queue udpRtspPacketQueue;
    private Object readMonitor = new Object();
    private RtspResponsePacket currentRtspResponsePacket;
    DataInputStream din;
    RtpStream pipein;
    Timer keepAliveTimer;
    byte[] tcpRtpPayloadBuffer;
    private static final Logger logger = Logger.getLogger("RtspConnection.file");

    public RtspConnection(String hostname, int controlPort, int dataPort, boolean useTcp) throws Exception {
        this.hostname = hostname;
        this.controlPort = controlPort;
        this.dataPort = dataPort;
        this.state = 0;
        this.rtspUri = "rtsp://" + this.bsplit(this.hostname, "/")[0].trim() + ':' + controlPort + "/" + this.bsplit(this.hostname, "/", 2)[1];
        this.pipein = new RtpStream();
        this.useTcp = useTcp;
        this.pipein.session = this.session = new SessionObject();
        if (useTcp) {
            if (this.tcpRtspPacketQueue == null) {
                this.tcpRtspPacketQueue = new Queue();
            }
        } else if (this.udpRtspPacketQueue == null) {
            this.udpRtspPacketQueue = new Queue();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("rtspUri = " + this.rtspUri);
        }
    }

    public void setAuthorization(String uname, String pwd) {
        this.username = uname;
        this.iPhrase = pwd;
    }

    public void setupControlSocket() {
        block14: {
            try {
                if (this.hostname != null) {
                    if (this.controlSocket == null) {
                        this.controlSocket = new Socket(this.bsplit(this.hostname, "/")[0], this.controlPort);
                        this.controlSocket.setSoTimeout(100);
                    } else {
                        this.controlSocket.close();
                        this.controlInput = null;
                        this.controlOut = null;
                        this.controlSocket = new Socket(this.bsplit(this.hostname, "/")[0], this.controlPort);
                        this.controlSocket.setSoTimeout(100);
                    }
                } else {
                    throw new Exception("Unknown / Invalid Host");
                }
                this.controlOut = this.controlSocket.getOutputStream();
                this.controlInput = this.controlSocket.getInputStream();
                if (this.useTcp) {
                    this.buffIn = new BufferedInputStream(this.controlInput);
                    this.bufferedReader = new BufferedReader(new InputStreamReader(this.buffIn));
                    this.din = new DataInputStream(this.buffIn);
                    if (this.tcpReader == null) {
                        this.tcpReader = new TcpInputStreamReader();
                        this.tcpReader.start();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("***** TCP STREAM READER STARTED *****");
                        }
                        this.tcpReader.setPriority(10);
                    }
                } else {
                    while (this.udpReader == null) {
                        try {
                            this.udpReader = new UdpDataReader("RtspUdpReader", this.dataPort, this.pipein, true);
                            this.udpReader.setPriority(10);
                        }
                        catch (Exception e) {
                            if (this.udpReader != null && this.udpReader.isAlive()) {
                                this.udpReader.done = true;
                            }
                            this.udpReader = null;
                            this.dataPort += 2;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block14;
                logger.log(Level.SEVERE, "Error while setting up control socket", e);
            }
        }
    }

    protected int getOptions() {
        int ret;
        while (true) {
            int stat = this.sendRtspCommand(this.getOptionsString());
            ret = -1;
            if (stat != 1) break;
            ret = this.readOptions();
            if (ret >= 0) {
                return ret;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    protected String getOptionsString() {
        if (this.useBasic) {
            return "OPTIONS " + this.rtspUri + "?" + this.videoParams + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
        }
        return "OPTIONS " + this.rtspUri + "?" + this.videoParams + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAuthorization: " + this.authorization + "\r\n";
    }

    protected int readOptions() {
        int status = this.readStatus();
        if (this.useTcp) {
            String[] optionsBody = this.currentRtspResponsePacket.body();
            if (status == 200) {
                String optionsLine = null;
                for (int i = 0; i < optionsBody.length; ++i) {
                    if (!optionsBody[i].startsWith("Public:")) continue;
                    optionsLine = optionsBody[i];
                    break;
                }
                if (optionsLine != null) {
                    this.is_describe = optionsLine.indexOf("DESCRIBE") > -1;
                    this.is_get_parameter = optionsLine.indexOf("GET_PARAMETER") > -1;
                    this.is_announce = optionsLine.indexOf("ANNOUNCE") > -1;
                    this.is_setup = optionsLine.indexOf("SETUP") > -1;
                    this.is_play = optionsLine.indexOf("PLAY") > -1;
                    this.is_pause = optionsLine.indexOf("PAUSE") > -1;
                    this.is_teardown = optionsLine.indexOf("TEARDOWN") > -1;
                    this.is_set_parameter = optionsLine.indexOf("SET_PARAMETER") > -1;
                    this.is_record = optionsLine.indexOf("RECORD") > -1;
                    this.is_redirect = optionsLine.indexOf("REDIRECT") > -1;
                }
            } else {
                this.createAuthorizationStringFromResponse("OPTIONS", this.currentRtspResponsePacket.body());
            }
            return status;
        }
        if (status == 200) {
            String readLine;
            while (!(readLine = this.readResponseLine(MAX_WAIT_TIME)).trim().startsWith("CSeq:")) {
            }
            if (Integer.parseInt(this.bsplit(readLine, ":")[1].trim()) == this.CSeq) {
                while (!(readLine = this.readResponseLine(MAX_WAIT_TIME).trim()).startsWith("Public:")) {
                }
                String[] commands = this.bsplit(this.bsplit(readLine, ":")[1], ",");
                for (int i = 0; i < commands.length; ++i) {
                    if (commands[i].trim().indexOf("DESCRIBE") >= 0) {
                        this.is_describe = true;
                        continue;
                    }
                    if (commands[i].indexOf("GET_PARAMETER") >= 0) {
                        this.is_get_parameter = true;
                        continue;
                    }
                    if (commands[i].indexOf("ANNOUNCE") >= 0) {
                        this.is_announce = true;
                        continue;
                    }
                    if (commands[i].indexOf("SETUP") >= 0) {
                        this.is_setup = true;
                        continue;
                    }
                    if (commands[i].indexOf("PLAY") >= 0) {
                        this.is_play = true;
                        continue;
                    }
                    if (commands[i].indexOf("PAUSE") >= 0) {
                        this.is_pause = true;
                        continue;
                    }
                    if (commands[i].indexOf("TEARDOWN") >= 0) {
                        this.is_teardown = true;
                        continue;
                    }
                    if (commands[i].indexOf("SET_PARAMETER") >= 0) {
                        this.is_set_parameter = true;
                        continue;
                    }
                    if (commands[i].indexOf("RECORD") >= 0) {
                        this.is_record = true;
                        continue;
                    }
                    if (commands[i].indexOf("REDIRECT") < 0) continue;
                    this.is_redirect = true;
                }
            }
            while (!this.readResponseLine(MAX_WAIT_TIME).equals("")) {
            }
            return status;
        }
        this.createAuthorizationStringFromResponse("OPTIONS", this.currentRtspResponsePacket.body());
        this.lastError = status;
        this.lastCcommand = "OPTIONS";
        return status;
    }

    protected int getDescribe() {
        int ret = 0;
        int stat = this.sendRtspCommand(this.getDescribeString());
        if (stat > 0) {
            ret = this.readDescribe();
        }
        if (ret != 200 && (stat = this.sendRtspCommand(this.getDescribeString())) > 0) {
            ret = this.readDescribe();
        }
        return ret;
    }

    protected String getDescribeString() {
        if (this.useBasic) {
            if (!this.videoParams.equals("")) {
                return "DESCRIBE " + this.rtspUri + "?" + this.videoParams + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAccept: application/sdp\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
            }
            return "DESCRIBE " + this.rtspUri + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAccept: application/sdp\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
        }
        if (!this.videoParams.equals("")) {
            return "DESCRIBE " + this.rtspUri + "?" + this.videoParams + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAccept: application/sdp\r\nAuthorization: " + this.authorization + "\r\n";
        }
        return "DESCRIBE " + this.rtspUri + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nAccept: application/sdp\r\nAuthorization: " + this.authorization + "\r\n";
    }

    protected int readDescribe() {
        int status = this.readStatus();
        if (this.useTcp) {
            String[] describeBody = this.currentRtspResponsePacket.body();
            if (status == 200) {
                int state = 0;
                block8: for (int i = 0; i < describeBody.length; ++i) {
                    String describeLine = describeBody[i];
                    this.session.parseLine(describeLine.trim());
                    switch (state) {
                        case 0: {
                            if (!describeLine.startsWith("m=video") && !describeLine.startsWith("m=application")) continue block8;
                            state = 1;
                            continue block8;
                        }
                        case 1: {
                            state = this.getState(describeLine, state);
                            continue block8;
                        }
                    }
                }
            } else {
                this.createAuthorizationStringFromResponse("DESCRIBE", this.currentRtspResponsePacket.body());
                this.lastError = status;
                this.lastCcommand = "DESCRIBE";
            }
            ++this.CSeq;
            return status;
        }
        if (status == 200) {
            String readLine;
            while (!(readLine = this.readResponseLine(MAX_WAIT_TIME)).equals("")) {
            }
            readLine = this.readResponseLine(MAX_WAIT_TIME);
            int state = 0;
            while (!readLine.equals("")) {
                this.session.parseLine(readLine.trim());
                switch (state) {
                    case 0: {
                        if (!readLine.startsWith("m=video") && !readLine.startsWith("m=application")) break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        state = this.getState(readLine, state);
                        break;
                    }
                }
                readLine = this.readResponseLine(MAX_WAIT_TIME);
            }
            ++this.CSeq;
            return status;
        }
        this.createAuthorizationStringFromResponse("DESCRIBE", this.currentRtspResponsePacket.body());
        this.lastError = status;
        this.lastCcommand = "DESCRIBE";
        return status;
    }

    private int getState(String readLine, int state) {
        if (readLine.startsWith("a=control")) {
            int index = readLine.indexOf(":");
            if (index > 0) {
                String controlUrl = readLine.substring(index + 1);
                if (controlUrl.startsWith("rtsp:")) {
                    if ((controlUrl = this.bsplit(controlUrl, "?", 2)[0]).indexOf(this.currentRtspResponsePacket.contentBase) > -1) {
                        this.trackid = controlUrl.substring(this.currentRtspResponsePacket.contentBase.length());
                        state = 2;
                    }
                } else {
                    this.trackid = readLine.substring(index + 1);
                    state = 2;
                }
            }
        } else if (readLine.startsWith("m=")) {
            state = 0;
        }
        return state;
    }

    protected int getSetup() {
        int ret = 0;
        int stat = this.sendRtspCommand(this.getSetupString(this.videoParams));
        if (stat > 0) {
            ret = this.readSetup();
        }
        while (ret == 401 || ret == 404) {
            stat = this.sendRtspCommand(this.getSetupString(this.videoParams));
            if (stat <= 0) continue;
            ret = this.readSetup();
        }
        return ret;
    }

    protected String getSetupString(String vid) {
        String udpTransportParams = "RTP/AVP/UDP;unicast;client_port=" + this.dataPort + "-" + (this.dataPort + 1);
        String tcpTransportParams = "RTP/AVP/TCP;unicast";
        String transport = this.useTcp ? tcpTransportParams : udpTransportParams;
        int queryIndex = -1;
        queryIndex = this.trackid.indexOf("?");
        if (queryIndex != -1 && !vid.equals("")) {
            this.trackid = this.trackid.substring(0, queryIndex);
        }
        if (this.useBasic) {
            if (!vid.equals("")) {
                return "SETUP " + this.rtspUri + "/" + this.trackid + "?" + vid + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nBlocksize: " + this.chunksize + "\r\nTransport: " + transport + "\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
            }
            return "SETUP " + this.rtspUri + "/" + this.trackid + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nBlocksize: " + this.chunksize + "\r\nTransport: " + transport + "\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
        }
        if (!vid.equals("")) {
            return "SETUP " + this.rtspUri + "/" + this.trackid + "?" + vid + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nBlocksize: " + this.chunksize + "\r\nTransport: " + transport + "\r\nAuthorization: " + this.authorization + "\r\n";
        }
        return "SETUP " + this.rtspUri + "/" + this.trackid + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nBlocksize: " + this.chunksize + "\r\nTransport: " + transport + "\r\nAuthorization: " + this.authorization + "\r\n";
    }

    protected int readSetup() {
        int status = this.readStatus();
        if (this.useTcp) {
            String[] setupBody = this.currentRtspResponsePacket.body();
            if (status == 200) {
                for (int i = 0; i < setupBody.length; ++i) {
                    String setupLine = setupBody[i];
                    if (setupLine.startsWith("Session:")) {
                        String sesId = this.bsplit(setupLine, ":", 2)[1];
                        sesId = this.bsplit(sesId, ";", 2)[0].trim();
                        this.session.setSessionId(sesId);
                        this.session.setSessionTimeout(Integer.parseInt(this.bsplit(setupLine, "timeout=", 2)[1]));
                        continue;
                    }
                    if (!setupLine.startsWith("Transport:")) continue;
                    String[] transportTokens = this.bsplit(setupLine, ";");
                    for (int j = 0; j < transportTokens.length; ++j) {
                        if (!transportTokens[j].startsWith("ssrc")) continue;
                        this.session.SSRC = this.bsplit(transportTokens[j], "=")[1];
                    }
                }
            } else {
                this.createAuthorizationStringFromResponse("SETUP", this.currentRtspResponsePacket.body());
                this.lastError = status;
                this.lastCcommand = "SETUP";
            }
            ++this.CSeq;
            return status;
        }
        if (status == 200) {
            String readLine = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(readLine, ":")[1].trim()) == this.CSeq) {
                readLine = this.readResponseLine(MAX_WAIT_TIME);
                if (readLine.indexOf("Date:") >= 0) {
                    String i = readLine;
                }
                while (readLine != "") {
                    if (readLine.startsWith("Session")) {
                        String sesId = this.bsplit(readLine, ":", 2)[1];
                        sesId = this.bsplit(sesId, ";", 2)[0].trim();
                        this.session.setSessionId(sesId);
                        this.session.setSessionTimeout(Integer.parseInt(this.bsplit(readLine, "timeout=", 2)[1]));
                    }
                    if (readLine.startsWith("Transport")) {
                        String[] spliStr = this.bsplit(readLine, ";");
                        for (int i = 0; i < spliStr.length; ++i) {
                            if (spliStr[i].startsWith("server_port=")) {
                                String[] ports = this.bsplit(this.bsplit(spliStr[i], "=")[1], "-");
                                this.session.server_port_rtp = Integer.parseInt(ports[0]);
                                this.session.server_port_rtcp = Integer.parseInt(ports[1]);
                            }
                            if (!spliStr[i].startsWith("ssrc")) continue;
                            this.session.SSRC = this.bsplit(spliStr[i], "=")[1];
                        }
                    }
                    readLine = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return status;
        }
        this.createAuthorizationStringFromResponse("SETUP", this.currentRtspResponsePacket.body());
        this.lastError = status;
        this.lastCcommand = "SETUP";
        return status;
    }

    protected int getPlay() {
        int ret = 0;
        int stat = this.sendRtspCommand(this.getPlayString(this.videoParams));
        if (stat > 0) {
            ret = this.readPlay();
        }
        if (ret != 200 && (stat = this.sendRtspCommand(this.getPlayString(this.videoParams))) > 0) {
            ret = this.readPlay();
        }
        return ret;
    }

    protected String getPlayString(String vid) {
        if (this.useBasic) {
            if (!vid.equals("")) {
                return "PLAY " + this.rtspUri + "?" + vid + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
            }
            return "PLAY /" + this.bsplit(this.hostname, "/", 2)[1] + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
        }
        if (!vid.equals("")) {
            return "PLAY " + this.rtspUri + "?" + vid + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nRange: npt=0.000-\r\nAuthorization: " + this.authorization + "\r\n";
        }
        return "PLAY " + this.rtspUri + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nRange: npt=0.000-\r\nAuthorization: " + this.authorization + "\r\n";
    }

    protected int readPlay() {
        int status = this.readStatus();
        if (this.useTcp) {
            if (status != 200) {
                this.createAuthorizationStringFromResponse("PLAY", this.currentRtspResponsePacket.body());
                this.lastError = status;
                this.lastCcommand = "PLAY";
            }
            ++this.CSeq;
            return status;
        }
        if (status == 200) {
            String readLine = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(readLine, ":")[1].trim()) == this.CSeq) {
                readLine = this.readResponseLine(MAX_WAIT_TIME);
                if (readLine.indexOf("Date:") >= 0) {
                    String string = readLine;
                }
                while (readLine != "") {
                    readLine = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return status;
        }
        this.createAuthorizationStringFromResponse("PLAY", this.currentRtspResponsePacket.body());
        this.lastError = status;
        this.lastCcommand = "PLAY";
        return status;
    }

    public String createAuthorizationStringFromResponse(String methodString, String[] responseBody) {
        block3: {
            StringBuilder sb = new StringBuilder();
            for (int i = responseBody.length - 1; i >= 0; --i) {
                sb.append(responseBody[i]);
            }
            this.realm = this.parseValue(sb, "realm");
            this.nonce = this.parseValue(sb, "nonce");
            this.authorization = "";
            try {
                String response;
                this.authorization = response = this.getAuthorization(this.realm, this.nonce, this.rtspUri, this.username, this.iPhrase, methodString);
                this.useBasic = false;
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block3;
                logger.log(Level.SEVERE, "Could not create the authorization string from the response", e);
            }
        }
        return this.authorization;
    }

    protected int doStop() {
        int ret = 0;
        int stat = this.sendRtspCommand(this.getTearDownString());
        if (stat > 0) {
            int stopResult = 200;
            return stopResult;
        }
        return ret;
    }

    protected String getTearDownString() {
        if (this.useBasic) {
            return "TEARDOWN /" + this.bsplit(this.hostname, "/", 2)[1] + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
        }
        return "TEARDOWN " + this.rtspUri + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\n\r\n";
    }

    protected int readStop() {
        String readLine;
        int status = this.readStatus();
        if (this.useTcp && status == 200) {
            ++this.CSeq;
            return status;
        }
        if (status == 200) {
            String readLine2 = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(readLine2, ":")[1].trim()) == this.CSeq) {
                readLine2 = this.readResponseLine(MAX_WAIT_TIME);
                if (readLine2.indexOf("Date:") >= 0) {
                    String string = readLine2;
                }
                while (readLine2 != "") {
                    readLine2 = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return status;
        }
        while ((readLine = this.readResponseLine(MAX_WAIT_TIME)) != "") {
        }
        this.lastError = status;
        this.lastCcommand = "TEARDOWN";
        return 0;
    }

    protected int doPause() {
        int ret = 0;
        int stat = this.sendRtspCommand(this.getPauseString());
        if (stat > 0) {
            return this.readPause();
        }
        return ret;
    }

    protected String getPauseString() {
        if (this.useBasic) {
            return "PAUSE /" + this.bsplit(this.hostname, "/", 2)[1] + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\n\r\n";
        }
        return "PAUSE " + this.rtspUri + " RTSP/1.0\r\nCSeq: " + this.CSeq + "\r\nSession: " + this.session.sessionId + "\r\n\r\n";
    }

    protected int readPause() {
        String readLine;
        int status = this.readStatus();
        if (status == 200) {
            String readLine2 = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(readLine2, ":")[1].trim()) == this.CSeq) {
                readLine2 = this.readResponseLine(MAX_WAIT_TIME);
                if (readLine2.indexOf("Date:") >= 0) {
                    String string = readLine2;
                }
                while (readLine2 != "") {
                    readLine2 = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return status;
        }
        while ((readLine = this.readResponseLine(MAX_WAIT_TIME)) != "") {
        }
        this.lastError = status;
        this.lastCcommand = "PAUSE";
        return 0;
    }

    public int setParameter(String parameter) {
        int ret = 0;
        int stat = this.sendRtspCommand(this.getSetParameterString(parameter));
        if (stat > 0) {
            ret = this.readSetParameter();
        }
        return ret;
    }

    protected String getSetParameterString(String parameter) {
        String transport;
        String udpTransportParams = "RTP/AVP/UDP;unicast;client_port=" + this.dataPort + "-" + (this.dataPort + 1);
        String tcpTransportParams = "RTP/AVP/TCP;interleaved=0-1";
        String string = transport = this.useTcp ? tcpTransportParams : udpTransportParams;
        if (this.useBasic) {
            return "SET_PARAMETER rtsp://" + this.hostname + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nTransport: " + transport + "\r\nAuthorization: Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.iPhrase).getBytes()) + "\r\nContent-Type: text/parameters\r\nContent-Length:" + parameter.length() + "\r\n\r\n" + parameter + "\r\n\r\n";
        }
        return "SET_PARAMETER " + this.rtspUri + " RTSP/1.0\r\nCSeq:" + this.CSeq + "\r\nTransport: " + transport + "\r\nContent-Type: text/parameters\r\nContent-Length:" + parameter.length() + "\r\n\r\n" + parameter + "\r\n\r\n";
    }

    protected int readSetParameter() {
        String readLine;
        int status = this.readStatus();
        if (status == 200) {
            String readLine2 = this.readResponseLine(MAX_WAIT_TIME);
            if (Integer.parseInt(this.bsplit(readLine2, ":")[1].trim()) == this.CSeq) {
                readLine2 = this.readResponseLine(MAX_WAIT_TIME);
                if (readLine2.indexOf("Date:") >= 0) {
                    String string = readLine2;
                }
                while (readLine2 != "") {
                    if (readLine2.startsWith("Session")) {
                        this.session.setSessionId(this.bsplit(readLine2, ":", 2)[1]);
                    }
                    if (readLine2.startsWith("Transport")) {
                        // empty if block
                    }
                    readLine2 = this.readResponseLine(MAX_WAIT_TIME);
                }
            }
            ++this.CSeq;
            return status;
        }
        while ((readLine = this.readResponseLine(MAX_WAIT_TIME)) != "") {
        }
        this.lastError = status;
        this.lastCcommand = "SET_PARAMETER";
        return 0;
    }

    protected int sendKeepAlive() {
        return this.sendRtspCommand(this.getAliveString());
    }

    protected String getAliveString() {
        if (this.keepAliveCommandString == null) {
            this.keepAliveCommandString = "OPTIONS " + this.rtspUri + "?" + this.videoParams + " RTSP/1.0\r\nUser-Agent: Niagara\r\nCSeq:" + this.CSeq + "\r\nSession :" + this.session.sessionId + "\r\n\r\n";
        }
        return this.keepAliveCommandString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connect(String vid) throws Exception {
        this.setupControlSocket();
        this.videoParams = vid;
        int returned = this.getOptions();
        if (returned != 200) throw new Exception("Unable to get a proper response to OPTIONS");
        this.state = 1;
        if (!this.is_describe) return;
        returned = this.getDescribe();
        if (returned != 200) throw new Exception("Unable to get a proper response to DESCRIBE");
        this.state = 2;
    }

    public boolean isConnected() {
        return this.state == 2;
    }

    public void play() throws Exception {
        block10: {
            int status = 0;
            if (this.isConnected() && this.is_play) {
                status = this.getSetup();
                if (status == 200) {
                    this.state = 3;
                    status = this.getPlay();
                    if (status == 200) {
                        this.state = 5;
                        try {
                            if (this.keepAliveTask == null) {
                                this.keepAliveTask = new KeepAliveTask();
                            }
                            if (this.keepAliveTimer == null) {
                                this.keepAliveTimer = new Timer();
                            }
                            long keepAlivePeriod = (long)this.session.timeout * 500L;
                            this.keepAliveTimer.scheduleAtFixedRate((TimerTask)this.keepAliveTask, keepAlivePeriod, keepAlivePeriod);
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer("***** KEEP ALIVE TIMER THREAD STARTED ******");
                            }
                            if (this.useTcp) break block10;
                            this.udpReader.start();
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer("***** RTP PACKET READER STARTED ******");
                            }
                            break block10;
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(Level.SEVERE)) {
                                logger.log(Level.SEVERE, "There was an error starting the data readers", e);
                            }
                            break block10;
                        }
                    }
                    throw new Exception("Cannot PLAY");
                }
                throw new Exception("Cannot SETUP");
            }
        }
    }

    public boolean isPlaying() {
        return this.state == 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws Exception {
        if (this.isPlaying() && this.is_pause) {
            int ret = this.doPause();
            if (ret != 200) {
                throw new Exception("Cannot Pause");
            }
            if (!this.useTcp) {
                RtspConnection rtspConnection = this;
                synchronized (rtspConnection) {
                    this.wait();
                }
            }
            this.state = 6;
        }
    }

    public boolean isPaused() {
        return this.state == 6;
    }

    public void stop() throws Exception {
        if ((this.isPlaying() || this.isPaused()) && this.is_teardown) {
            this.state = 0;
            logger.log(Level.FINE, "TEARDOWN command sent on calling stop()");
            this.doStop();
            if (this.useTcp && this.tcpReader != null) {
                this.tcpReader.done = true;
            } else if (this.udpReader != null) {
                this.udpReader.done = true;
            }
            if (this.controlSocket != null) {
                this.controlSocket.close();
            }
        }
    }

    public void cleanUp() {
        block2: {
            try {
                this.controlSocket.close();
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(Level.SEVERE, "Socket has been closed on Cleanup()...", e);
            }
        }
    }

    public boolean isStopped() {
        return this.state == 0;
    }

    public InputStream getInputStream() throws IOException {
        if (this.pipein != null) {
            return this.pipein;
        }
        throw new IOException("Null Stream");
    }

    protected int readStatus() {
        if (!this.useTcp) {
            String statusLine;
            while ((statusLine = this.readResponseLine(MAX_WAIT_TIME)).indexOf("RTSP/1.0") == -1) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("Finished waiting for RTSP response status code...");
            }
            String[] tokens = TextUtil.split((String)statusLine, (char)' ');
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].indexOf("RTSP/1.0") == -1) continue;
                return Integer.parseInt(tokens[i + 1]);
            }
        } else if (this.currentRtspResponsePacket != null && this.currentRtspResponsePacket.cseq == this.CSeq) {
            return this.currentRtspResponsePacket.status;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readResponseLine(int timeout) {
        String line;
        block14: {
            line = "";
            try {
                this.controlSocket.setSoTimeout(2000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                long maxWaitTicks = Clock.ticks() + (long)timeout;
                while (!this.controlSocket.isClosed()) {
                    if (Clock.ticks() > maxWaitTicks) {
                        line = " ";
                        break;
                    }
                    Object object = this.readMonitor;
                    synchronized (object) {
                        int readByte = this.controlInput.read();
                        if (readByte == 13) {
                            int nextByte = this.controlInput.read();
                            if (nextByte == 10) {
                                break;
                            }
                            line = line + (char)readByte;
                            line = line + (char)nextByte;
                        } else {
                            if (readByte == 10) {
                                break;
                            }
                            if (readByte != -1) {
                                line = line + (char)readByte;
                                maxWaitTicks = Clock.ticks() + (long)timeout;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block14;
                logger.log(Level.SEVERE, "Could not read bytes from the response stream...", e);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("received = " + line);
        }
        return line.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRtspCommand(String command) {
        int ret;
        block10: {
            ret = 1;
            try {
                if (this.controlSocket == null || this.controlSocket.isClosed()) break block10;
                this.controlOut.write(command.getBytes());
                this.controlOut.flush();
                if (this.useTcp && this.tcpReader.isAlive()) {
                    Queue queue = this.tcpRtspPacketQueue;
                    synchronized (queue) {
                        this.tcpRtspPacketQueue.wait(1000L);
                        this.currentRtspResponsePacket = (RtspResponsePacket)this.tcpRtspPacketQueue.dequeue(1000);
                        break block10;
                    }
                }
                if (null == this.udpReader || !this.udpReader.isAlive()) break block10;
                Queue queue = this.udpRtspPacketQueue;
                synchronized (queue) {
                    this.currentRtspResponsePacket = (RtspResponsePacket)this.udpRtspPacketQueue.dequeue(1000);
                }
            }
            catch (Exception ex) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "Exception while sending RTSP command", ex);
                }
                ret = -1;
            }
        }
        return ret;
    }

    public String getAuthorization(String realm, String nonce, String uri, String user, String psw, String method) throws IOException {
        ++this.CSeq;
        StringBuilder response = new StringBuilder();
        response.append("Digest username=").append("\"").append(user).append("\"").append(", ");
        response.append("realm=").append("\"").append(realm).append("\"").append(", ");
        response.append("nonce=").append("\"").append(nonce).append("\"").append(", ");
        response.append("uri=").append("\"").append(uri).append("\"").append(", ");
        response.append("response=\"");
        String A1 = user + ':' + realm + ':' + this.iPhrase;
        String hA1 = this.hexMD5(A1);
        String A2 = method + ':' + uri;
        String hA2 = this.hexMD5(A2);
        response.append(this.hexMD5(hA1 + ':' + nonce + ':' + hA2));
        response.append("\"\r\n");
        return response.toString();
    }

    protected String hexMD5(String in) {
        StringBuilder result;
        block3: {
            result = new StringBuilder();
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                byte[] toHash = md5.digest(in.getBytes());
                for (int i = 0; i < toHash.length; ++i) {
                    result.append(TextUtil.toLowerCase((String)TextUtil.byteToHexString((int)toHash[i])));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block3;
                logger.log(Level.SEVERE, "Error in generating hexMD5 for digest authentication...", e);
            }
        }
        return result.toString();
    }

    public String[] bsplit(String splitStr, String delimiter) {
        return this.bsplit(splitStr, delimiter, 0);
    }

    public String[] bsplit(String splitStr, String delimiter, int limit) {
        if (null != delimiter && delimiter.length() == 0) {
            char[] chars = splitStr.toCharArray();
            StringBuilder tk = new StringBuilder();
            Vector<String> nulldelimString = new Vector<String>();
            for (int i = 0; i < chars.length; ++i) {
                tk.append(chars[i]);
                nulldelimString.addElement(tk.toString());
                tk.setLength(0);
            }
            String[] splitArray = new String[nulldelimString.size()];
            for (int i = 0; i < splitArray.length; ++i) {
                splitArray[i] = (String)nulldelimString.elementAt(i);
            }
            return splitArray;
        }
        if (delimiter == null) {
            throw new NullPointerException("Delimiter cannot be null");
        }
        if (splitStr == null) {
            throw new NullPointerException("String source cannot be null");
        }
        int maximumSplits = Integer.MAX_VALUE;
        boolean dropTailingDelimiters = true;
        if (limit <= 0) {
            dropTailingDelimiters = false;
        } else {
            dropTailingDelimiters = true;
            maximumSplits = limit - 1;
        }
        StringBuilder token = new StringBuilder();
        Vector<String> tokens = new Vector<String>();
        char[] stringChars = splitStr.toCharArray();
        int splicounter = 0;
        boolean lastWasDelimiter = false;
        for (int i = 0; i < stringChars.length; ++i) {
            String candidate;
            if (i + delimiter.length() <= stringChars.length && splicounter < maximumSplits && (candidate = new String(stringChars, i, delimiter.length())).equals(delimiter)) {
                tokens.addElement(token.toString());
                token.setLength(0);
                lastWasDelimiter = true;
                ++splicounter;
                i = i + delimiter.length() - 1;
                continue;
            }
            token.append(stringChars[i]);
            lastWasDelimiter = false;
        }
        if (token.length() > 0 || lastWasDelimiter && !dropTailingDelimiters) {
            tokens.addElement(token.toString());
        }
        String[] splitArray = new String[tokens.size()];
        for (int i = 0; i < splitArray.length; ++i) {
            splitArray[i] = (String)tokens.elementAt(i);
        }
        return splitArray;
    }

    private String parseValue(StringBuilder sb, String key) {
        int index = sb.indexOf(key);
        if (index < 0) {
            return "";
        }
        int start = sb.indexOf("\"", index);
        int end = sb.indexOf("\"", start + 1);
        if (start < 0 || end < 0) {
            return "";
        }
        return sb.substring(start + 1, end);
    }

    public static class SessionObject {
        public long currentTime = 0L;
        public long updated = 0L;
        public int timeout = 0;
        public int server_port_rtp;
        public int server_port_rtcp;
        public String sdpString = "";
        public String sessionId = "";
        public String SSRC = "";

        public void setSessionId(String id) {
            this.sessionId = id;
        }

        public void setSessionTimeout(int time) {
            this.timeout = time;
            this.updated = BAbsTime.now().getMillis();
        }

        public void parseLine(String str) {
            this.sdpString = this.sdpString + str + "\n";
        }

        public long getCurrentTime() {
            return this.currentTime;
        }
    }

    public class RtspResponsePacket {
        public int status;
        public int cseq;
        public String contentBase = "";
        public Array<String> body = new Array(String.class);

        public String[] body() {
            return (String[])this.body.trim();
        }
    }

    public class TcpInputStreamReader
    extends Thread {
        private boolean done = false;
        private int numRetries = 0;

        public TcpInputStreamReader() {
            this.setName("RtspTcpReader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                while (!this.done && !RtspConnection.this.controlSocket.isClosed()) {
                    try {
                        byte[] prefixBytes = new byte[8];
                        RtspConnection.this.buffIn.read(prefixBytes, 0, 2);
                        if (prefixBytes[0] == 36 && prefixBytes[1] == 0) {
                            int rtpPayloadSize = RtspConnection.this.din.readUnsignedShort();
                            if (RtspConnection.this.tcpRtpPayloadBuffer == null || RtspConnection.this.tcpRtpPayloadBuffer.length != rtpPayloadSize) {
                                RtspConnection.this.tcpRtpPayloadBuffer = new byte[rtpPayloadSize];
                            }
                            RtspConnection.this.din.readFully(RtspConnection.this.tcpRtpPayloadBuffer);
                            RtpPacket rtpPacket = new RtpPacket(RtspConnection.this.tcpRtpPayloadBuffer, true);
                            rtpPacket.read(RtspConnection.this.tcpRtpPayloadBuffer, rtpPayloadSize);
                            RtspConnection.this.pipein.addPacket(rtpPacket, true);
                            this.numRetries = 0;
                            RtpStream rtpStream = RtspConnection.this.pipein;
                            synchronized (rtpStream) {
                                long startTime = Clock.ticks();
                                RtspConnection.this.pipein.wait(3000L);
                                long waitTime = Clock.ticks() - startTime;
                                if (waitTime >= 3000L) {
                                    break;
                                }
                                continue;
                            }
                        }
                        RtspConnection.this.buffIn.read(prefixBytes, 2, 6);
                        String rtspPrefix = new String(prefixBytes);
                        if (!rtspPrefix.equals("RTSP/1.0")) continue;
                        RtspResponsePacket rtspResponsePacket = new RtspResponsePacket();
                        String line = rtspPrefix + RtspConnection.this.bufferedReader.readLine();
                        boolean isSdp = false;
                        int sdpContentLength = 0;
                        while (!line.equals("")) {
                            rtspResponsePacket.body.add((Object)line);
                            String[] lineTokens = TextUtil.split((String)line, (char)' ');
                            if (lineTokens[0].equals("RTSP/1.0")) {
                                rtspResponsePacket.status = Integer.parseInt(lineTokens[1]);
                            } else if (lineTokens[0].equals("CSeq:")) {
                                rtspResponsePacket.cseq = Integer.parseInt(lineTokens[1]);
                            } else if (lineTokens[0].equals("Content-Length:")) {
                                sdpContentLength = Integer.parseInt(lineTokens[1]);
                            } else if (lineTokens[0].equals("Content-Base:")) {
                                rtspResponsePacket.contentBase = lineTokens[1];
                            } else if (line.startsWith("Content-Type: application/sdp")) {
                                isSdp = true;
                            }
                            line = RtspConnection.this.bufferedReader.readLine();
                        }
                        if (isSdp) {
                            while (sdpContentLength > 0) {
                                line = RtspConnection.this.bufferedReader.readLine();
                                rtspResponsePacket.body.add((Object)line);
                                sdpContentLength -= line.getBytes().length + 2;
                            }
                        }
                        Queue queue = RtspConnection.this.tcpRtspPacketQueue;
                        synchronized (queue) {
                            RtspConnection.this.tcpRtspPacketQueue.enqueue((Object)rtspResponsePacket);
                            RtspConnection.this.tcpRtspPacketQueue.notifyAll();
                        }
                    }
                    catch (Exception ex) {
                        if (ex instanceof SocketTimeoutException && this.numRetries++ >= 20) continue;
                    }
                }
                logger.log(Level.FINE, "TEARDOWN command sent on TCPStreamReader thread...");
                RtspConnection.this.doStop();
                if (RtspConnection.this.keepAliveTimer != null) {
                    RtspConnection.this.keepAliveTimer.cancel();
                }
                try {
                    RtspConnection.this.tcpRtspPacketQueue.clear();
                    RtspConnection.this.pipein.close();
                    RtspConnection.this.controlSocket.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block27;
                    logger.log(Level.SEVERE, "Could not close tcp stream or sockets", e);
                }
            }
        }
    }

    public class KeepAliveTask
    extends TimerTask {
        @Override
        public void run() {
            RtspConnection.this.sendKeepAlive();
        }
    }

    public class UdpDataReader
    extends Thread {
        boolean done = false;
        int dataport;
        DatagramSocket udpSocket;
        RtpStream rtpStream;
        boolean RTP;
        byte[] buf = new byte[1600];
        byte[] rtpData = new byte[1600];
        DatagramPacket udpPacket = new DatagramPacket(this.buf, this.buf.length);
        int numRetries = 0;

        public UdpDataReader(String threadName, int dataport, RtpStream rts, boolean rtp) throws Exception {
            this.setName(threadName);
            this.dataport = dataport;
            this.rtpStream = rts;
            this.RTP = rtp;
            this.udpSocket = new DatagramSocket(dataport);
            this.udpSocket.setReceiveBufferSize(0x7D0000);
            this.udpSocket.setSoTimeout(1000);
            this.rtpStream.setPortandBuffer(dataport, this.udpSocket.getReceiveBufferSize());
            this.done = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                while (!this.done && !RtspConnection.this.controlSocket.isClosed()) {
                    try {
                        if (this.udpSocket != null && !this.udpSocket.isClosed()) {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    try {
                                        UdpDataReader.this.udpSocket.receive(UdpDataReader.this.udpPacket);
                                    }
                                    catch (IOException ex) {
                                        logger.log(Level.SEVERE, "UDP Reader receive timeout", ex);
                                    }
                                    return null;
                                }
                            });
                        }
                        System.arraycopy(this.udpPacket.getData(), 0, this.rtpData, 0, this.udpPacket.getLength());
                        RtpPacket rtpPacket = new RtpPacket();
                        rtpPacket.read(this.rtpData, this.udpPacket.getLength());
                        this.numRetries = 0;
                        this.rtpStream.addPacket(rtpPacket, true);
                        RtpStream rtpStream = this.rtpStream;
                        synchronized (rtpStream) {
                            long startTime = Clock.ticks();
                            this.rtpStream.wait(3000L);
                            long waitTime = Clock.ticks() - startTime;
                            if (waitTime >= 3000L) {
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (ex instanceof SocketTimeoutException && this.numRetries++ < 20) continue;
                        if (!logger.isLoggable(Level.SEVERE)) break;
                        logger.log(Level.SEVERE, "UDP Reader read timeout", ex);
                        break;
                    }
                }
                logger.log(Level.FINE, "TEARDOWN command sent from UDPDataReader thread...");
                RtspConnection.this.doStop();
                if (RtspConnection.this.keepAliveTimer != null) {
                    RtspConnection.this.keepAliveTimer.cancel();
                }
                try {
                    this.udpSocket.close();
                    this.rtpStream.close();
                    RtspConnection.this.controlSocket.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block11;
                    logger.log(Level.SEVERE, "Could not close UDP sockets and streams", e);
                }
            }
        }
    }
}

