/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.ui.point;

import com.tridium.nc.point.BCloudPointDeviceExt;
import com.tridium.nc.ui.point.BCloudPointManager;
import com.tridium.ndriver.ui.point.BNPointManager;
import com.tridium.ndriver.ui.point.NPointController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;

public class CloudPointController
extends NPointController {
    private static final Logger log = Logger.getLogger("ncloud.point");
    private static final Lexicon lex = Lexicon.make(CloudPointController.class);
    private final BCloudPointManager cloudPointManager;
    public final MgrController.MgrCommand pointLearn;

    public CloudPointController(BCloudPointManager cloudPointManager) {
        super((BNPointManager)cloudPointManager);
        this.cloudPointManager = cloudPointManager;
        this.pointLearn = new PointLearn((BWidget)cloudPointManager);
        this.pointLearn.setFlags(7);
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return CloudPointController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])this.makeCloudPointsCommands());
    }

    private MgrController.IMgrCommand[] makeCloudPointsCommands() {
        return new MgrController.IMgrCommand[]{this.pointLearn};
    }

    public BWidget makeActionBar() {
        MgrController.IMgrCommand[] cmds1 = super.makeCommands();
        MgrController.IMgrCommand[] cmds2 = this.makeCloudPointsCommands();
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.makeActionPane(cmds1));
        pane.setCenter((BWidget)new BBorderPane(this.makeActionPane(cmds2)));
        return pane;
    }

    class PointLearn
    extends MgrController.MgrCommand {
        PointLearn(BWidget owner) {
            super(owner, lex, "pointLearn");
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BComponent component = CloudPointController.this.cloudPointManager.getTarget();
                if (component instanceof BIPointFolder) {
                    BIPointFolder folder = (BIPointFolder)component;
                    BCloudPointDeviceExt deviceExt = (BCloudPointDeviceExt)folder.getDeviceExt();
                    Action action = deviceExt.getAction("learnPoints");
                    InvokeActionCommand invokeActionCommand = new InvokeActionCommand((BWidget)CloudPointController.this.cloudPointManager, (BComponent)deviceExt, action);
                    invokeActionCommand.doInvoke();
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception invoking Cloud Point Learn:" + e, log.isLoggable(Level.FINE) ? e : null);
            }
            return null;
        }
    }
}

