/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.inbound.routing.ext.BRouterExt;
import com.tridiumx.jsonToolkit.inbound.routing.ext.RouterExtException;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.util.JsonKeyExtractUtil;
import com.tridiumx.jsonToolkit.util.LicenseLimit;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="lastResult", type="BString", defaultValue="BString.DEFAULT", flags=3), @NiagaraProperty(name="lastResultTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="lastInput", type="BString", defaultValue="BString.DEFAULT", flags=65539, facets={@Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=65539), @NiagaraProperty(name="clearOutputOnFault", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="route", parameterType="BString", defaultValue="BString.make(\"\")", flags=2072), @NiagaraAction(name="runLastInput", flags=2048), @NiagaraAction(name="clearOutputs", flags=2048)})
public abstract class BJsonInbound
extends BComponent
implements JsonKeyExtractUtil {
    @Generated
    public static final Property enabled = BJsonInbound.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property lastResult = BJsonInbound.newProperty((int)3, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property lastResultTime = BJsonInbound.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastInput = BJsonInbound.newProperty((int)65539, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    @Generated
    public static final Property status = BJsonInbound.newProperty((int)65539, (BValue)BStatus.ok, null);
    @Generated
    public static final Property clearOutputOnFault = BJsonInbound.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action route = BJsonInbound.newAction((int)2072, (BValue)BString.make((String)""), null);
    @Generated
    public static final Action runLastInput = BJsonInbound.newAction((int)2048, null);
    @Generated
    public static final Action clearOutputs = BJsonInbound.newAction((int)2048, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonInbound.class);
    public static final String MESSAGE_ROUTED = "Routed";
    public static final Logger LOG = BJsonSchemaService.childLogger("routing");
    protected static final Property[] NO_PROPERTIES = new Property[0];
    private static final List<Property> outputPropertiesToClear = Arrays.asList(lastResult, lastResultTime);

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getLastResult() {
        return this.getString(lastResult);
    }

    @Generated
    public void setLastResult(String v) {
        this.setString(lastResult, v, null);
    }

    @Generated
    public BAbsTime getLastResultTime() {
        return (BAbsTime)this.get(lastResultTime);
    }

    @Generated
    public void setLastResultTime(BAbsTime v) {
        this.set(lastResultTime, (BValue)v, null);
    }

    @Generated
    public String getLastInput() {
        return this.getString(lastInput);
    }

    @Generated
    public void setLastInput(String v) {
        this.setString(lastInput, v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getClearOutputOnFault() {
        return this.getBoolean(clearOutputOnFault);
    }

    @Generated
    public void setClearOutputOnFault(boolean v) {
        this.setBoolean(clearOutputOnFault, v, null);
    }

    @Generated
    public void route(BString parameter) {
        this.invoke(route, (BValue)parameter, null);
    }

    @Generated
    public void runLastInput() {
        this.invoke(runLastInput, null, null);
    }

    @Generated
    public void clearOutputs() {
        this.invoke(clearOutputs, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected Property[] getRerunTriggers() {
        return NO_PROPERTIES;
    }

    public void changed(Property property, Context context) {
        Property[] rerunOnChange = this.getRerunTriggers();
        if (this.isRunning() && Arrays.asList(rerunOnChange).contains(property) && !this.getLastInput().isEmpty()) {
            this.doRoute((BString)this.get(lastInput), context);
        }
    }

    public void doRoute(BString string, Context cx) {
        if (!this.isRunning() || !this.getEnabled()) {
            return;
        }
        try {
            this.process(string, cx);
        }
        catch (RoutingFailedException e) {
            this.routingFailed(e.getPayload(), this.getLexicon().get("failedRoute") + ": " + e.getMessage(), log.isLoggable(Level.FINE) ? e : null);
        }
        catch (Exception e) {
            this.routingFailed(string.getString(), this.getLexicon().get("cannotRoute") + " - " + e.getMessage(), log.isLoggable(Level.FINE) ? e : null);
        }
    }

    private void process(BString string, Context cx) throws RoutingFailedException {
        LicenseLimit.checkImportLicensed();
        this.setLastInput(string.getString());
        this.sanityCheck(string.toString());
        this.routeValue(string, cx);
        this.setLastResult(MESSAGE_ROUTED);
        this.setLastResultTime(BAbsTime.now());
        if (this.getStatus().isNull()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2, (boolean)false));
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    protected abstract void routeValue(BString var1, Context var2) throws RoutingFailedException;

    public void doRunLastInput(Context cx) {
        this.doRoute((BString)this.get(lastInput), cx);
    }

    public void doClearOutputs() {
        ArrayList<Property> toClear = new ArrayList<Property>(outputPropertiesToClear);
        toClear.addAll(this.implOutputsToClear());
        toClear.forEach(property -> this.set((Property)property, JsonSchemaUtil.getPropertyResetValue(property)));
        this.setStatus(BStatus.ok);
    }

    protected abstract List<Property> implOutputsToClear();

    protected void processRouterExt(BString message) {
        BRouterExt[] utils;
        for (BRouterExt u : utils = (BRouterExt[])this.getChildren(BRouterExt.class)) {
            try {
                u.route(message);
            }
            catch (RouterExtException re) {
                LOG.log(Level.WARNING, u.getName(), re);
                return;
            }
        }
    }

    protected void routingFailed(String payload, String reason, Exception e) {
        StringBuilder message = new StringBuilder(String.format("Routing failed in [%s] because [%s]", this.getName(), reason));
        if (!payload.isEmpty()) {
            message.append(String.format(" for message [%s]", this.loggableJson(payload)));
        }
        if (e != null && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.WARNING, message.toString(), e);
        } else {
            LOG.log(Level.WARNING, message.toString());
        }
        if (this.getClearOutputOnFault()) {
            this.doClearOutputs();
        }
        this.setLastResult(message.toString());
        this.setLastResultTime(BAbsTime.now());
        this.setStatus(BStatus.fault);
    }

    protected <T> T runJsonPathQuery(String message, String query, Class<T> type) throws RoutingFailedException {
        try {
            return (T)AccessController.doPrivileged(() -> {
                DocumentContext jsonContext = JsonPath.parse(message);
                return jsonContext.read(query, type, new Predicate[0]);
            });
        }
        catch (InvalidJsonException ije) {
            throw new RoutingFailedException(message, "JSON Path error: Invalid JSON input", ije);
        }
        catch (Exception e) {
            throw new RoutingFailedException(message, "JSON Path error: " + e.getMessage(), e);
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return BJsonSchemaService.post(this, action, argument, cx);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"connections.png");
    }
}

