/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.handler;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridiumx.jsonToolkit.inbound.handler.BJsonHandler;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.outbound.schema.alarm.property.BIJsonAlarmDataResolver;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaSecurity;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperty(name="ackSource", type="BString", defaultValue="BString.make(\"alarmUuidAck\")")
public class BAlarmUuidAckHandler
extends BJsonHandler {
    @Generated
    public static final Property ackSource = BAlarmUuidAckHandler.newProperty((int)0, (BValue)BString.make((String)"alarmUuidAck"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmUuidAckHandler.class);
    private BAlarmService alarmService;
    private static final Logger log = BIJsonAlarmDataResolver.log;
    private static final String FALLBACK_USERNAME = "AlarmUuidAckUser";
    private static final String EXAMPLE_INPUT = "{user: \"shaun\",alarms: [ \"5cf9c8b2-1542-42ba-a1fd-5f753c777bc0\"]}";

    @Generated
    public String getAckSource() {
        return this.getString(ackSource);
    }

    @Generated
    public void setAckSource(String v) {
        this.setString(ackSource, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void routeValue(BString alarmAckInput, Context cx) throws RoutingFailedException {
        if (!this.isRunning()) {
            return;
        }
        JSONTokener tokener = new JSONTokener(alarmAckInput.toString());
        Object candidateJson = tokener.nextValue();
        if (candidateJson instanceof JSONObject) {
            JSONArray alarms;
            JSONObject ob = (JSONObject)candidateJson;
            String ackUserName = JSONUtil.getString((JSONObject)ob, (String)"user");
            if (ackUserName == null || ackUserName.isEmpty()) {
                ackUserName = FALLBACK_USERNAME;
            }
            if ((alarms = ob.getJSONArray("alarms")).length() < 1) {
                this.fail("No alarms to ack in " + alarmAckInput + " for " + ackUserName, null);
            } else {
                this.ackAlarms(ackUserName, alarms);
            }
        } else {
            log.warning("Expected outer object eg: {user: \"shaun\",alarms: [ \"5cf9c8b2-1542-42ba-a1fd-5f753c777bc0\"]}, not: " + alarmAckInput);
        }
    }

    private void ackAlarms(String ackUserName, JSONArray uuidArray) throws RoutingFailedException {
        if (uuidArray.length() > 0) {
            if (this.getAlarmService() != null) {
                try (AlarmDbConnection conn = this.getAlarmService().getAlarmDb().getDbConnection(null);){
                    for (int i = 0; i < uuidArray.length(); ++i) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Attempting Ack On: " + JSONUtil.getString((JSONArray)uuidArray, (int)i));
                        }
                        this.ackUuid(conn, ackUserName, JSONUtil.getString((JSONArray)uuidArray, (int)i));
                    }
                }
            } else {
                log.warning("Could not find alarm service to ack alarms for alarms " + uuidArray);
            }
        }
    }

    private void ackUuid(AlarmDbConnection conn, String ackUserName, String uuid) throws RoutingFailedException {
        if (uuid == null || uuid.isEmpty()) {
            return;
        }
        try {
            BUuid u = BUuid.make((String)uuid);
            BAlarmRecord record = conn.getRecord(u);
            if (record == null) {
                this.fail("Could not find alarm with uuid " + uuid, null);
                return;
            }
            this.checkAlarmClassPermissions(record);
            if (!record.isAcknowledged()) {
                record.setAckState(BAckState.ackPending);
                record.addAlarmFacet("ackSource", (BIDataValue)this.get(ackSource.getName()));
                record.setUser(ackUserName);
                this.alarmService.ackAlarm(record);
                this.getAlarmService().routeAlarm(record);
                this.result("Ack-ed alarm " + record, null);
            } else {
                this.result("Already ack-ed in alarmDb " + record, null);
            }
        }
        catch (IOException ioe) {
            this.fail("Could not connect to alarmDb", ioe);
        }
        catch (PermissionException pe) {
            this.fail(String.format("Rejected ack for alarm %s based on lack of permissions for service user", uuid), (Exception)((Object)pe));
        }
        catch (BajaRuntimeException be) {
            this.fail("Could not create BUuid from " + uuid + ' ' + be.getMessage(), null);
        }
        catch (RoutingFailedException e) {
            throw e;
        }
        catch (Exception e) {
            this.fail("Could not create BUuid from " + uuid, e);
        }
    }

    private void fail(String reason, Exception e) throws RoutingFailedException {
        this.result(reason, e);
        throw new RoutingFailedException(reason);
    }

    private BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    private void checkAlarmClassPermissions(BAlarmRecord record) {
        Context serviceContext = JsonSchemaSecurity.createServiceContext();
        if (serviceContext == null) {
            throw new PermissionException("Service user required for remote alarm ack");
        }
        BAlarmClass alarmClass = this.getAlarmService().lookupAlarmClass(record.getAlarmClass());
        if (alarmClass == null) {
            alarmClass = this.getAlarmService().getDefaultAlarmClass();
        }
        serviceContext.getUser().check((BIProtected)alarmClass, BPermissions.adminWrite);
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)"module://icons/x16/alarm/alarmAck.png");
    }
}

