/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.handler.exportMarker;

import com.tridium.json.JSONException;
import com.tridiumx.jsonToolkit.exportMarker.BJsonExportMarker;
import com.tridiumx.jsonToolkit.exportMarker.filter.ExportMarkerNotFoundException;
import com.tridiumx.jsonToolkit.inbound.handler.BJsonHandler;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.util.MissingJsonValueException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="remoteKey", type="BString", defaultValue="platformId")
public class BJsonExportDeregistrationHandler
extends BJsonHandler {
    @Generated
    public static final Property remoteKey = BJsonExportDeregistrationHandler.newProperty((int)0, (String)"platformId", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonExportDeregistrationHandler.class);
    protected static final Logger log = BJsonSchemaService.childLogger("exportRegistration");

    @Generated
    public String getRemoteKey() {
        return this.getString(remoteKey);
    }

    @Generated
    public void setRemoteKey(String v) {
        this.setString(remoteKey, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void routeValue(BString message, Context cx) {
        try {
            String id = this.lookupKey(message.toString(), log, false, this.getRemoteKey()).toString();
            if (id != null) {
                BJsonExportMarker marker = BJsonSchemaService.register().lookupExportMarker(id);
                log.info("Unregistering " + marker.getParent().getName() + " as " + id);
                marker.resetId();
                this.result("De-registration Success", null);
            }
        }
        catch (JSONException je) {
            log.log(Level.WARNING, "Could not read JSON: " + this.loggableJson(message.toString()), je);
        }
        catch (ExportMarkerNotFoundException | MissingJsonValueException e) {
            log.log(Level.WARNING, "Cannot unregister unknown id", (Throwable)e);
        }
    }

    @Override
    public BIcon getIcon() {
        return BJsonExportMarker.addExportBadge(super.getIcon());
    }

    @Override
    protected Property[] getRerunTriggers() {
        return new Property[]{remoteKey};
    }
}

