/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.handler.exportMarker;

import com.tridium.json.JSONException;
import com.tridiumx.jsonToolkit.exportMarker.BJsonExportMarker;
import com.tridiumx.jsonToolkit.inbound.handler.exportMarker.BJsonExportDeregistrationHandler;
import com.tridiumx.jsonToolkit.util.MissingJsonValueException;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="localKey", type="String", defaultValue="niagaraId")
public class BJsonExportRegistrationHandler
extends BJsonExportDeregistrationHandler {
    @Generated
    public static final Property localKey = BJsonExportRegistrationHandler.newProperty((int)0, (String)"niagaraId", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonExportRegistrationHandler.class);

    @Generated
    public String getLocalKey() {
        return this.getString(localKey);
    }

    @Generated
    public void setLocalKey(String v) {
        this.setString(localKey, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void routeValue(BString message, Context cx) {
        BOrd handleOrd;
        BComponent p;
        String platformId;
        String niagaraId;
        try {
            Object[] res = this.lookupKeys(message.toString(), log, false, new String[]{this.getLocalKey(), this.getRemoteKey()});
            niagaraId = (String)res[0];
            platformId = (String)res[1];
        }
        catch (JSONException je) {
            log.log(Level.WARNING, "Could not read JSON: " + this.loggableJson(message.toString()), je);
            return;
        }
        catch (MissingJsonValueException bre) {
            log.log(Level.WARNING, "could not extract local and remote keys", (Throwable)((Object)bre));
            return;
        }
        if (niagaraId == null || platformId == null) {
            log.warning("Cannot extract: " + this.loggableJson(message.toString()));
            return;
        }
        this.processRouterExt(message);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Extracted handle ord " + niagaraId);
        }
        if ((p = (BComponent)(handleOrd = BOrd.make((String)niagaraId)).get((BObject)Sys.getStation())) == null) {
            log.warning("No point found for handle: " + niagaraId);
        } else {
            this.applyIdToMarker(p, platformId);
        }
    }

    private void applyIdToMarker(BComponent p, String platformId) {
        BJsonExportMarker[] ids = (BJsonExportMarker[])p.getChildren(BJsonExportMarker.class);
        if (ids.length != 1) {
            log.warning("There must be a single Export marker on the point to apply the id!" + p.getSlotPath() + " :: " + platformId);
        } else {
            BJsonExportMarker marker = ids[0];
            if (marker.getId() != null && !marker.getId().isEmpty()) {
                log.warning("Replacing ID " + marker.getId() + " with  " + platformId + " for " + p.getSlotPath());
            }
            marker.setId(platformId);
            log.info("Applied Id: " + platformId + " to " + p.getSlotPath());
            this.result("Registration Success", null);
        }
    }

    @Override
    protected Property[] getRerunTriggers() {
        return new Property[]{localKey, remoteKey};
    }
}

